/*
 * Decompiled with CFR 0.152.
 */
package com.lynden.gmapsfx;

import com.lynden.gmapsfx.MapComponentInitializedListener;
import com.lynden.gmapsfx.MapNotInitializedException;
import com.lynden.gmapsfx.MapReadyListener;
import com.lynden.gmapsfx.javascript.JavaFxWebEngine;
import com.lynden.gmapsfx.javascript.JavascriptRuntime;
import com.lynden.gmapsfx.javascript.event.MapStateEventType;
import com.lynden.gmapsfx.javascript.object.DirectionsPane;
import com.lynden.gmapsfx.javascript.object.GoogleMap;
import com.lynden.gmapsfx.javascript.object.LatLong;
import com.lynden.gmapsfx.javascript.object.MapOptions;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.CyclicBarrier;
import javafx.application.Platform;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.concurrent.Worker;
import javafx.event.Event;
import javafx.event.EventDispatchChain;
import javafx.event.EventDispatcher;
import javafx.event.EventHandler;
import javafx.geometry.Point2D;
import javafx.scene.Node;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.AnchorPane;
import javafx.scene.web.WebEngine;
import javafx.scene.web.WebErrorEvent;
import javafx.scene.web.WebEvent;
import javafx.scene.web.WebView;
import netscape.javascript.JSObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Text;

public class GoogleMapView
extends AnchorPane {
    private static final Logger LOG = LoggerFactory.getLogger(GoogleMapView.class);
    protected static final String GOOGLE_MAPS_API_LINK = "https://maps.googleapis.com/maps/api/js?v=3.exp";
    protected static final String GOOGLE_MAPS_API_VERSION = "3.exp";
    private boolean usingCustomHtml;
    protected final String language;
    protected final String region;
    protected String key;
    protected WebView webview;
    protected JavaFxWebEngine webengine;
    protected boolean initialized = false;
    protected final CyclicBarrier barrier = new CyclicBarrier(2);
    protected final List<MapComponentInitializedListener> mapInitializedListeners = new ArrayList<MapComponentInitializedListener>();
    protected final List<MapReadyListener> mapReadyListeners = new ArrayList<MapReadyListener>();
    protected GoogleMap map;
    protected DirectionsPane direc;
    protected boolean disableDoubleClick = false;

    public GoogleMapView() {
        this(false);
    }

    public GoogleMapView(boolean debug) {
        this(null, debug);
    }

    public GoogleMapView(String mapResourcePath) {
        this(mapResourcePath, false);
    }

    public GoogleMapView(String mapResourcePath, boolean debug) {
        this(mapResourcePath, null, null, debug);
    }

    public GoogleMapView(String language, String key) {
        this(null, language, key, false);
    }

    public GoogleMapView(String mapResourcePath, String language, String key, boolean debug) {
        this(mapResourcePath, language, null, key, debug);
    }

    public GoogleMapView(String mapResourcePath, String language, String region, String key, boolean debug) {
        String htmlFile;
        this.language = "en";
        this.region = "US";
        this.key = key;
        if (mapResourcePath == null) {
            htmlFile = this.getHtmlFile(debug);
        } else {
            htmlFile = mapResourcePath;
            this.usingCustomHtml = true;
        }
        CountDownLatch latch = new CountDownLatch(1);
        Runnable initWebView = () -> {
            try {
                this.webview = new WebView();
                EventDispatcher originalDispatcher = this.webview.getEventDispatcher();
                this.webview.setEventDispatcher((EventDispatcher)new MyEventDispatcher(originalDispatcher));
                this.webengine = new JavaFxWebEngine(this.webview.getEngine());
                JavascriptRuntime.setDefaultWebEngine(this.webengine);
                this.setFont(this.webview.getEngine());
                GoogleMapView.setTopAnchor((Node)this.webview, (Double)0.0);
                GoogleMapView.setLeftAnchor((Node)this.webview, (Double)0.0);
                GoogleMapView.setBottomAnchor((Node)this.webview, (Double)0.0);
                GoogleMapView.setRightAnchor((Node)this.webview, (Double)0.0);
                this.getChildren().add((Object)this.webview);
                this.webview.widthProperty().addListener(e -> this.mapResized());
                this.webview.heightProperty().addListener(e -> this.mapResized());
                this.webengine.setOnAlert((EventHandler<WebEvent<String>>)((EventHandler)e -> LOG.info("Alert: " + (String)e.getData())));
                this.webengine.setOnError((EventHandler<WebErrorEvent>)((EventHandler)e -> LOG.error("Error: " + e.getMessage())));
                this.webengine.getLoadWorker().stateProperty().addListener((ChangeListener)new ChangeListener<Worker.State>(){

                    public void changed(ObservableValue ov, Worker.State oldState, Worker.State newState) {
                        if (newState == Worker.State.SUCCEEDED) {
                            GoogleMapView.this.initialiseScript();
                        }
                    }
                });
                this.webengine.load(((Object)((Object)this)).getClass().getResource(htmlFile).toExternalForm());
            }
            finally {
                latch.countDown();
            }
        };
        if (Platform.isFxApplicationThread()) {
            initWebView.run();
        } else {
            Platform.runLater((Runnable)initWebView);
        }
        try {
            latch.await();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    protected String getHtmlFile(boolean debug) {
        if (debug) {
            return "html/maps-debug.html";
        }
        return "html/maps.html";
    }

    private void initialiseScript() {
        if (!this.usingCustomHtml) {
            JSObject window = (JSObject)this.webengine.executeScript("window");
            window.setMember("libLoadBridge", new MapLibraryLoadBridge());
            String script = "loadMapLibrary('3.exp','" + this.key + "','" + this.language + "','" + this.region + "');";
            this.webengine.executeScript(script);
        } else {
            this.setInitialized(true);
            this.fireMapInitializedListeners();
        }
    }

    private void setFont(WebEngine webEngine) {
        webEngine.getLoadWorker().stateProperty().addListener((observable, oldValue, newValue) -> {
            if (newValue == Worker.State.SUCCEEDED) {
                Document document = (Document)webEngine.executeScript("document");
                Element styleNode = document.createElement("style");
                Text styleContent = document.createTextNode("* { font-family: Arial, Helvetica, san-serif !important; }");
                styleNode.appendChild(styleContent);
                document.getDocumentElement().getElementsByTagName("head").item(0).appendChild(styleNode);
            }
        });
    }

    private void mapResized() {
        if (this.initialized && this.map != null) {
            this.webengine.executeScript("google.maps.event.trigger(" + this.map.getVariableName() + ", 'resize')");
        }
    }

    public void setKey(String key) {
        this.key = key;
    }

    public void setZoom(int zoom) {
        this.checkInitialized();
        this.map.setZoom(zoom);
    }

    public void setCenter(double latitude, double longitude) {
        this.checkInitialized();
        LatLong latLong = new LatLong(latitude, longitude);
        this.map.setCenter(latLong);
    }

    public GoogleMap getMap() {
        this.checkInitialized();
        return this.map;
    }

    public GoogleMap createMap(MapOptions mapOptions) {
        return this.createMap(mapOptions, false);
    }

    public GoogleMap createMap() {
        return this.createMap(null, false);
    }

    public GoogleMap createMap(boolean withDirectionsPanel) {
        return this.createMap(null, withDirectionsPanel);
    }

    public GoogleMap createMap(MapOptions mapOptions, boolean withDirectionsPanel) {
        this.checkInitialized();
        this.map = mapOptions != null ? this.internal_createMap(mapOptions) : this.internal_createMap();
        this.direc = new DirectionsPane();
        if (withDirectionsPanel) {
            this.map.showDirectionsPane();
        }
        this.map.addStateEventHandler(MapStateEventType.projection_changed, () -> {
            if (this.map.getProjection() != null) {
                this.mapResized();
                this.fireMapReadyListeners();
            }
        });
        return this.map;
    }

    protected GoogleMap internal_createMap() {
        return new GoogleMap();
    }

    protected GoogleMap internal_createMap(MapOptions mapOptions) {
        return new GoogleMap(mapOptions);
    }

    public DirectionsPane getDirec() {
        return this.direc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addMapInializedListener(MapComponentInitializedListener listener) {
        List<MapComponentInitializedListener> list = this.mapInitializedListeners;
        synchronized (list) {
            this.mapInitializedListeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeMapInitializedListener(MapComponentInitializedListener listener) {
        List<MapComponentInitializedListener> list = this.mapInitializedListeners;
        synchronized (list) {
            this.mapInitializedListeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addMapReadyListener(MapReadyListener listener) {
        List<MapReadyListener> list = this.mapReadyListeners;
        synchronized (list) {
            this.mapReadyListeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeReadyListener(MapReadyListener listener) {
        List<MapReadyListener> list = this.mapReadyListeners;
        synchronized (list) {
            this.mapReadyListeners.remove(listener);
        }
    }

    public Point2D fromLatLngToPoint(LatLong loc) {
        this.checkInitialized();
        return this.map.fromLatLngToPoint(loc);
    }

    public void panBy(double x, double y) {
        this.checkInitialized();
        this.map.panBy(x, y);
    }

    public boolean isDisableDoubleClick() {
        return this.disableDoubleClick;
    }

    public void setDisableDoubleClick(boolean disableDoubleClick) {
        this.disableDoubleClick = disableDoubleClick;
    }

    protected void setInitialized(boolean initialized) {
        this.initialized = initialized;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireMapInitializedListeners() {
        List<MapComponentInitializedListener> list = this.mapInitializedListeners;
        synchronized (list) {
            for (MapComponentInitializedListener listener : this.mapInitializedListeners) {
                listener.mapInitialized();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireMapReadyListeners() {
        List<MapReadyListener> list = this.mapReadyListeners;
        synchronized (list) {
            for (MapReadyListener listener : this.mapReadyListeners) {
                listener.mapReady();
            }
        }
    }

    protected JSObject executeJavascript(String function) {
        Object returnObject = this.webengine.executeScript(function);
        return (JSObject)returnObject;
    }

    protected String getJavascriptMethod(String methodName, Object ... args) {
        StringBuilder sb = new StringBuilder();
        sb.append(methodName).append("(");
        for (Object arg : args) {
            sb.append(arg).append(",");
        }
        sb.replace(sb.length() - 1, sb.length(), ")");
        return sb.toString();
    }

    protected void checkInitialized() {
        if (!this.initialized) {
            throw new MapNotInitializedException();
        }
    }

    public WebView getWebview() {
        return this.webview;
    }

    public class MyEventDispatcher
    implements EventDispatcher {
        private final EventDispatcher originalDispatcher;

        public MyEventDispatcher(EventDispatcher originalDispatcher) {
            this.originalDispatcher = originalDispatcher;
        }

        public Event dispatchEvent(Event event, EventDispatchChain tail) {
            MouseEvent mouseEvent;
            if (event instanceof MouseEvent && (mouseEvent = (MouseEvent)event).getClickCount() == 2 && GoogleMapView.this.disableDoubleClick) {
                mouseEvent.consume();
            }
            return this.originalDispatcher.dispatchEvent(event, tail);
        }
    }

    public class MapLibraryLoadBridge {
        public void mapLibraryLoaded() {
            GoogleMapView.this.setInitialized(true);
            GoogleMapView.this.fireMapInitializedListeners();
        }
    }
}

