/*
 * Decompiled with CFR 0.152.
 */
package com.lynden.gmapsfx.service.directions;

import com.lynden.gmapsfx.javascript.JavascriptObject;
import com.lynden.gmapsfx.javascript.object.DirectionsPane;
import com.lynden.gmapsfx.javascript.object.GoogleMap;
import netscape.javascript.JSObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DirectionsRenderer
extends JavascriptObject {
    private static final Logger LOG = LoggerFactory.getLogger(DirectionsRenderer.class);

    public DirectionsRenderer() {
        super("google.maps.DirectionsRenderer");
    }

    public DirectionsRenderer(JSObject type) {
        super("google.maps.DirectionsRenderer", type);
        LOG.trace("map: " + this.getJSObject().getMember("map").toString() + "\n" + "draggable: " + this.getJSObject().getMember("draggable").toString());
    }

    public DirectionsRenderer(boolean drag, GoogleMap map, DirectionsPane panel) {
        super("google.maps.DirectionsRenderer");
        this.getJSObject().eval(this.getVariableName() + ".setOptions({draggable:" + drag + "});");
        this.getJSObject().eval(this.getVariableName() + ".setMap(" + map.getVariableName() + ");");
        this.getJSObject().eval(this.getVariableName() + ".setPanel(" + panel.getVariableName() + ");");
    }

    public DirectionsRenderer(boolean drag, GoogleMap map, DirectionsPane panel, String strokeColor) {
        super("google.maps.DirectionsRenderer");
        this.getJSObject().eval(this.getVariableName() + ".setOptions({draggable:" + drag + ", polylineOptions: { strokeColor: '" + strokeColor + "'}});");
        this.getJSObject().eval(this.getVariableName() + ".setMap(" + map.getVariableName() + ");");
        this.getJSObject().eval(this.getVariableName() + ".setPanel(" + panel.getVariableName() + ");");
    }

    public void setMap(GoogleMap map) {
        if (map == null) {
            this.getJSObject().eval(this.getVariableName() + ".setMap(null);");
        } else {
            this.getJSObject().eval(this.getVariableName() + ".setMap(" + map.getVariableName() + ");");
        }
    }

    public void clearDirections() {
        this.setMap(null);
    }

    public void setOptions(String options) {
        this.getJSObject().eval(this.getVariableName() + ".setOptions({draggable:" + options + "});");
    }

    public void setPanel(DirectionsPane panel) {
        this.getJSObject().eval(this.getVariableName() + ".setPanel(" + panel.getVariableName() + ");");
    }

    public String toString() {
        return "map: " + this.getJSObject().getMember("map").toString() + "\n" + "draggable: " + this.getJSObject().getMember("draggable").toString() + "\n" + "panel: " + this.getJSObject().getMember("panel").toString() + "\n" + "directions: " + this.getJSObject().getMember("directions").toString();
    }
}

