/*
 * Decompiled with CFR 0.152.
 */
package com.lynden.gmapsfx.service.geocoding;

import com.lynden.gmapsfx.javascript.JavascriptObject;
import com.lynden.gmapsfx.javascript.object.LatLong;
import com.lynden.gmapsfx.service.geocoding.GeocoderRequest;
import com.lynden.gmapsfx.service.geocoding.GeocoderStatus;
import com.lynden.gmapsfx.service.geocoding.GeocodingResult;
import com.lynden.gmapsfx.service.geocoding.GeocodingServiceCallback;
import netscape.javascript.JSObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GeocodingService
extends JavascriptObject {
    private static final Logger LOG = LoggerFactory.getLogger(GeocodingService.class);
    public GeocodingServiceCallback callback;

    public GeocodingService() {
        super("google.maps.Geocoder");
    }

    public void reverseGeocode(double lat, double lon, GeocodingServiceCallback callback) {
        this.getGeocoding(new GeocoderRequest(null, new LatLong(lat, lon), null, null, null, null), callback);
    }

    public void geocode(String address, GeocodingServiceCallback callback) {
        this.getGeocoding(new GeocoderRequest(address), callback);
    }

    public void getGeocoding(GeocoderRequest req, GeocodingServiceCallback callback) {
        this.callback = callback;
        JSObject doc = (JSObject)this.getJSObject().eval("document");
        doc.setMember(this.getVariableName(), this);
        StringBuilder r = new StringBuilder(this.getVariableName()).append(".").append("geocode(").append(req.getVariableName()).append(", ").append("function(results, status) {alert('rec:'+status);\ndocument.").append(this.getVariableName()).append(".processResponse(results, status);});");
        LOG.trace("Geocoding direct call: " + r.toString());
        this.getJSObject().eval(r.toString());
    }

    public void processResponse(Object results, Object status) {
        JSObject jsres;
        Object len;
        GeocoderStatus pStatus = GeocoderStatus.UNKNOWN_ERROR;
        if (status instanceof String && results instanceof JSObject && GeocoderStatus.OK.equals((Object)(pStatus = GeocoderStatus.valueOf((String)status))) && (len = (jsres = (JSObject)results).getMember("length")) instanceof Number) {
            int n = ((Number)len).intValue();
            GeocodingResult[] ers = new GeocodingResult[n];
            for (int i = 0; i < n; ++i) {
                Object obj = jsres.getSlot(i);
                if (!(obj instanceof JSObject)) continue;
                ers[i] = new GeocodingResult((JSObject)obj);
            }
            this.callback.geocodedResultsReceived(ers, pStatus);
            return;
        }
        this.callback.geocodedResultsReceived(new GeocodingResult[0], pStatus);
    }
}

