/*
 * Decompiled with CFR 0.152.
 */
package cards.pay.paycardsrecognizer.sdk.camera;

import android.annotation.TargetApi;
import android.hardware.Camera;
import android.os.Build;
import android.os.Handler;
import android.os.Looper;
import android.support.annotation.Nullable;
import android.support.annotation.RestrictTo;

@RestrictTo(value={RestrictTo.Scope.LIBRARY})
public final class AutoFocusManager {
    private final Camera mCamera;
    @Nullable
    private final FocusMoveCallback mCallback;
    @Nullable
    private FocusManager mFocusManager;
    private Handler mHandler;

    public AutoFocusManager(Camera camera, @Nullable FocusMoveCallback focusMoveCallback) {
        AutoFocusManager autoFocusManager = this;
        this.mCamera = camera;
        autoFocusManager.mCallback = focusMoveCallback;
        autoFocusManager.mHandler = new Handler(Looper.myLooper());
    }

    private boolean isCameraFocusContinuous() {
        String string = ((AutoFocusManager)((Object)string)).mCamera.getParameters().getFocusMode();
        return "continuous-picture".equals(string) || "continuous-video".equals(string) || "edof".equals(string);
    }

    private boolean isCameraFocusManual() {
        String string = ((AutoFocusManager)((Object)string)).mCamera.getParameters().getFocusMode();
        return "auto".equals(string) || "macro".equals(string);
    }

    public void start() {
        FocusManager focusManager = this.mFocusManager;
        if (focusManager != null) {
            focusManager.stop();
            this.mFocusManager = null;
        }
        if (this.isCameraFocusContinuous()) {
            this.mFocusManager = new AutoFocusManagerImpl(this.mCamera, this.mCallback, this.mHandler);
            this.mFocusManager.start();
        } else if (this.isCameraFocusManual()) {
            this.mFocusManager = new ManualFocusManagerImpl(this.mCamera, this.mCallback, this.mHandler);
            this.mFocusManager.start();
        }
    }

    public void stop() {
        FocusManager focusManager = this.mFocusManager;
        if (focusManager != null) {
            focusManager.stop();
            this.mFocusManager = null;
        }
    }

    public void requestFocus() {
        FocusManager focusManager = ((AutoFocusManager)((Object)focusManager)).mFocusManager;
        if (focusManager != null) {
            focusManager.requestFocus();
        }
    }

    private static class AutoFocusManagerImpl
    implements FocusManager {
        private final Camera mCamera;
        @Nullable
        private final FocusMoveCallback mCallback;
        private final Handler mHandler;
        private boolean mCameraMoving;
        private final Runnable mResetFocusRunnable = new Runnable(){

            @Override
            public void run() {
                try {
                    2 v0 = this;
                    v0.AutoFocusManagerImpl.this.resumeAutoFocus();
                    v0.AutoFocusManagerImpl.this.restartCounter(1000);
                }
                catch (Exception exception) {}
            }
        };

        @TargetApi(value=16)
        public AutoFocusManagerImpl(Camera camera, @Nullable FocusMoveCallback focusMoveCallback, Handler handler) {
            this.mCamera = camera;
            this.mCallback = focusMoveCallback;
            this.mHandler = handler;
            if (Build.VERSION.SDK_INT >= 16 && this.mCallback != null) {
                this.mCamera.setAutoFocusMoveCallback(new Camera.AutoFocusMoveCallback(){

                    public void onAutoFocusMoving(boolean bl, Camera camera) {
                        1 v0 = this;
                        v0.AutoFocusManagerImpl.this.mCallback.onAutoFocusMoving(bl, camera);
                        AutoFocusManagerImpl.access$702(v0.AutoFocusManagerImpl.this, bl);
                    }
                });
            }
        }

        private void resumeAutoFocus() {
            this.cancelAutoFocusSafe();
        }

        private void restartCounter(int n) {
            this.mHandler.removeCallbacks(this.mResetFocusRunnable);
            if (n == 0) {
                this.mHandler.post(this.mResetFocusRunnable);
            } else {
                this.mHandler.postDelayed(this.mResetFocusRunnable, (long)n);
            }
        }

        private void cancelAutoFocusSafe() {
            try {
                this.mCamera.cancelAutoFocus();
            }
            catch (RuntimeException runtimeException) {}
        }

        static /* synthetic */ boolean access$702(AutoFocusManagerImpl autoFocusManagerImpl, boolean bl) {
            autoFocusManagerImpl.mCameraMoving = bl;
            return bl;
        }

        @Override
        public void start() {
            AutoFocusManagerImpl autoFocusManagerImpl = this;
            autoFocusManagerImpl.resumeAutoFocus();
            autoFocusManagerImpl.restartCounter(1000);
        }

        @Override
        public void stop() {
            this.mHandler.removeCallbacks(this.mResetFocusRunnable);
        }

        @Override
        public void requestFocus() {
            if (!this.mCameraMoving) {
                AutoFocusManagerImpl autoFocusManagerImpl = this;
                autoFocusManagerImpl.cancelAutoFocusSafe();
                autoFocusManagerImpl.restartCounter(1000);
            }
        }
    }

    private static class ManualFocusManagerImpl
    implements FocusManager {
        private static boolean sFocusCompleteWorking;
        private final Camera mCamera;
        @Nullable
        private final FocusMoveCallback mCallback;
        private final Handler mHandler;
        private boolean mIsFocusMoving;
        private final Runnable mRequestFocusRunnable = new Runnable(){

            @Override
            public void run() {
                block5: {
                    2 v0 = this;
                    2 v1 = v0;
                    v0.ManualFocusManagerImpl.this.mCamera.autoFocus(ManualFocusManagerImpl.this.mAutoFocusCallback);
                    ManualFocusManagerImpl.access$302(v0.ManualFocusManagerImpl.this, true);
                    if (v1.ManualFocusManagerImpl.this.mCallback == null) break block5;
                    FocusMoveCallback focusMoveCallback = ManualFocusManagerImpl.this.mCallback;
                    try {
                        focusMoveCallback.onAutoFocusMoving(true, ManualFocusManagerImpl.this.mCamera);
                    }
                    catch (Exception exception) {
                        2 v4 = this;
                        ManualFocusManagerImpl.access$302(v4.ManualFocusManagerImpl.this, false);
                        if (v4.ManualFocusManagerImpl.this.mCallback == null) break block5;
                        ManualFocusManagerImpl.this.mCallback.onAutoFocusMoving(false, ManualFocusManagerImpl.this.mCamera);
                    }
                }
            }
        };
        private final Camera.AutoFocusCallback mAutoFocusCallback = new Camera.AutoFocusCallback(){

            /*
             * WARNING - void declaration
             */
            public void onAutoFocus(boolean bl, Camera camera) {
                void var1_4;
                ManualFocusManagerImpl manualFocusManagerImpl;
                if (manualFocusManagerImpl.ManualFocusManagerImpl.this.mCallback != null) {
                    void var2_5;
                    manualFocusManagerImpl.ManualFocusManagerImpl.this.mCallback.onAutoFocusComplete(bl, (Camera)var2_5);
                }
                ManualFocusManagerImpl.access$302(manualFocusManagerImpl.ManualFocusManagerImpl.this, false);
                if (!sFocusCompleteWorking) {
                    sFocusCompleteWorking = true;
                }
                manualFocusManagerImpl = manualFocusManagerImpl.ManualFocusManagerImpl.this;
                if (bl) {
                    int n = 3000;
                } else {
                    int n = 500;
                }
                manualFocusManagerImpl.restartCounter((int)var1_4);
            }
        };

        @TargetApi(value=16)
        public ManualFocusManagerImpl(Camera camera, @Nullable FocusMoveCallback focusMoveCallback, Handler handler) {
            this.mCamera = camera;
            this.mCallback = focusMoveCallback;
            this.mHandler = handler;
            if (Build.VERSION.SDK_INT >= 16 && this.mCallback != null) {
                this.mCamera.setAutoFocusMoveCallback(new Camera.AutoFocusMoveCallback(){

                    public void onAutoFocusMoving(boolean bl, Camera camera) {
                        ManualFocusManagerImpl.this.mCallback.onAutoFocusMoving(bl, camera);
                    }
                });
            }
        }

        private void restartCounter(int n) {
            this.mHandler.removeCallbacks(this.mRequestFocusRunnable);
            if (n == 0) {
                this.mHandler.post(this.mRequestFocusRunnable);
            } else {
                this.mHandler.postDelayed(this.mRequestFocusRunnable, (long)n);
            }
        }

        private void cancelAutoFocusSafe() {
            try {
                this.mCamera.cancelAutoFocus();
            }
            catch (RuntimeException runtimeException) {}
        }

        static /* synthetic */ boolean access$302(ManualFocusManagerImpl manualFocusManagerImpl, boolean bl) {
            manualFocusManagerImpl.mIsFocusMoving = bl;
            return bl;
        }

        @Override
        public void start() {
            ManualFocusManagerImpl manualFocusManagerImpl = this;
            manualFocusManagerImpl.cancelAutoFocusSafe();
            manualFocusManagerImpl.restartCounter(500);
        }

        @Override
        public void stop() {
            ManualFocusManagerImpl manualFocusManagerImpl = this;
            manualFocusManagerImpl.mHandler.removeCallbacks(this.mRequestFocusRunnable);
            manualFocusManagerImpl.cancelAutoFocusSafe();
        }

        @Override
        public void requestFocus() {
            if (!this.mIsFocusMoving || !sFocusCompleteWorking) {
                ManualFocusManagerImpl manualFocusManagerImpl = this;
                manualFocusManagerImpl.cancelAutoFocusSafe();
                manualFocusManagerImpl.restartCounter(0);
            }
        }
    }

    private static interface FocusManager {
        public void start();

        public void stop();

        public void requestFocus();
    }

    public static interface FocusMoveCallback {
        public void onAutoFocusMoving(boolean var1, Camera var2);

        public void onAutoFocusComplete(boolean var1, Camera var2);
    }
}

