/*
 * Decompiled with CFR 0.152.
 */
package cards.pay.paycardsrecognizer.sdk.camera;

import android.content.Context;
import android.graphics.SurfaceTexture;
import android.hardware.Camera;
import android.support.annotation.Nullable;
import android.view.WindowManager;
import cards.pay.paycardsrecognizer.sdk.camera.AutoFocusManager;
import cards.pay.paycardsrecognizer.sdk.camera.CameraConfigurationUtils;
import cards.pay.paycardsrecognizer.sdk.camera.CameraUtils;
import cards.pay.paycardsrecognizer.sdk.camera.ProcessFrameThread;
import cards.pay.paycardsrecognizer.sdk.camera.RecognitionUnavailableException;
import cards.pay.paycardsrecognizer.sdk.camera.TorchManager;
import cards.pay.paycardsrecognizer.sdk.ndk.RecognitionCore;
import java.io.IOException;

class CameraManager {
    private final Context mAppContext;
    private final RecognitionCore mRecognitionCore;
    @Nullable
    private Camera mCamera;
    private AutoFocusManager mAutoFocusManager;
    private TorchManager mTorchManager;
    private volatile ProcessFrameThread mProcessThread;
    private AutoFocusManager.FocusMoveCallback mFocusCallbacks;
    private ProcessFrameThread.Callbacks mProcessFrameCallbacks;
    private boolean mIsResumed;
    private boolean mIsProcessFramesActive;

    public CameraManager(Context context) {
        this.mAppContext = context.getApplicationContext();
        this.mRecognitionCore = RecognitionCore.getInstance(this.mAppContext);
        this.mIsResumed = true;
        this.mIsProcessFramesActive = true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void openCameraInternal() throws Exception {
        Camera.Parameters parameters;
        if (this.mCamera != null) {
            this.releaseCamera();
        }
        try {
            this.mCamera = Camera.open();
            parameters = this.mCamera.getParameters();
        }
        catch (Exception exception) {
            this.releaseCamera();
            throw exception;
        }
        CameraUtils.NativeSupportedSize nativeSupportedSize = CameraUtils.findBestCameraSupportedSize(parameters.getSupportedPreviewSizes());
        if (nativeSupportedSize == CameraUtils.NativeSupportedSize.RESOLUTION_NO_CAMERA) throw new RecognitionUnavailableException(3);
        Camera.Parameters parameters2 = parameters;
        parameters2.setPreviewSize(nativeSupportedSize.size.width, nativeSupportedSize.size.height);
        parameters2.setPreviewFormat(842094169);
        CameraConfigurationUtils.setBestExposure(parameters2, false);
        CameraConfigurationUtils.initWhiteBalance(parameters2);
        CameraConfigurationUtils.initAutoFocus(parameters2);
        CameraConfigurationUtils.setMetering(parameters2);
        this.mCamera.setParameters(parameters);
    }

    private synchronized boolean isTorchManagerShouldBeActive() {
        return this.mCamera != null && this.mIsResumed && this.mIsProcessFramesActive;
    }

    private boolean isAutofocusShouldBeActive() {
        return this.mCamera != null && this.mIsResumed;
    }

    private synchronized void syncTorchManager() {
        if (this.mTorchManager != null) {
            if (this.isTorchManagerShouldBeActive()) {
                this.mTorchManager.resume();
            } else {
                this.mTorchManager.pause();
            }
        }
    }

    private synchronized void syncAutofocusManager() {
        if (this.mAutoFocusManager != null) {
            if (this.isAutofocusShouldBeActive()) {
                this.mAutoFocusManager.start();
            } else {
                this.mAutoFocusManager.stop();
            }
        }
    }

    private synchronized void syncProcessThread(boolean bl) {
        if (this.mIsResumed && this.mIsProcessFramesActive && this.mCamera != null) {
            if (bl || this.mProcessThread == null) {
                this.startProcessThread();
            }
        } else if (this.mProcessThread != null) {
            this.stopProcessThread();
        }
    }

    private synchronized void startProcessThread() {
        if (this.mCamera == null) {
            return;
        }
        CameraManager cameraManager = this;
        cameraManager.stopProcessThread();
        cameraManager.mProcessThread = new ProcessFrameThread(this.mAppContext, this.mCamera, new ProcessFrameThread.Callbacks(){

            @Override
            public void onFrameProcessed(int n) {
                if (CameraManager.this.mProcessFrameCallbacks != null) {
                    CameraManager.this.mProcessFrameCallbacks.onFrameProcessed(n);
                }
            }
        });
        cameraManager.mProcessThread.start();
        final ProcessFrameThread processFrameThread = cameraManager.mProcessThread;
        cameraManager.mCamera.setPreviewCallbackWithBuffer(new Camera.PreviewCallback(){

            public void onPreviewFrame(byte[] byArray, Camera camera) {
                if (CameraManager.this.mCamera == null) {
                    return;
                }
                processFrameThread.processFrame(byArray);
            }
        });
        processFrameThread = cameraManager.mCamera.getParameters().getPreviewSize();
        for (int i = 0; i < 3; ++i) {
            this.mCamera.addCallbackBuffer(new byte[((Camera.Size)processFrameThread).width * ((Camera.Size)processFrameThread).height * 3 / 2]);
        }
    }

    private synchronized void stopProcessThread() {
        if (cameraManager2.mProcessThread != null) {
            CameraManager cameraManager = cameraManager2;
            cameraManager.mProcessThread.setActive(false);
            cameraManager.mProcessThread = null;
            CameraManager cameraManager2 = cameraManager.mCamera;
            if (cameraManager2 != null) {
                cameraManager2.setPreviewCallbackWithBuffer(null);
            }
        }
    }

    @Nullable
    public Camera getCamera() {
        return this.mCamera;
    }

    public Camera.Size getCurrentPreviewSize() {
        CameraManager cameraManager = cameraManager.mCamera;
        if (cameraManager == null) {
            return null;
        }
        return cameraManager.getParameters().getPreviewSize();
    }

    public int calculateDataRotation() {
        return CameraUtils.getBackCameraDataRotation(((WindowManager)this.mAppContext.getSystemService("window")).getDefaultDisplay());
    }

    public synchronized void openCamera() throws Exception {
        if (this.mCamera != null) {
            this.releaseCamera();
        }
        CameraManager cameraManager = this;
        cameraManager.openCameraInternal();
        cameraManager.mAutoFocusManager = new AutoFocusManager(this.mCamera, this.mFocusCallbacks);
        cameraManager.syncAutofocusManager();
        cameraManager.mTorchManager = new TorchManager(this.mRecognitionCore, this.mCamera);
        cameraManager.syncTorchManager();
        cameraManager.syncProcessThread(true);
    }

    public synchronized void releaseCamera() {
        CameraManager cameraManager = this;
        cameraManager.stopProcessThread();
        Object object = cameraManager.mAutoFocusManager;
        if (object != null) {
            ((AutoFocusManager)object).stop();
            this.mAutoFocusManager = null;
        }
        if ((object = this.mTorchManager) != null) {
            ((TorchManager)object).destroy();
            this.mTorchManager = null;
        }
        if ((object = this.mCamera) != null) {
            CameraManager cameraManager2 = this;
            object.setPreviewCallbackWithBuffer(null);
            cameraManager2.mCamera.stopPreview();
            cameraManager2.mCamera.release();
            cameraManager2.mCamera = null;
        }
    }

    public void setAutoFocusCallbacks(AutoFocusManager.FocusMoveCallback focusMoveCallback) {
        this.mFocusCallbacks = focusMoveCallback;
    }

    public void setProcessFrameCallbacks(ProcessFrameThread.Callbacks callbacks) {
        this.mProcessFrameCallbacks = callbacks;
    }

    public void toggleFlash() {
        TorchManager torchManager = ((CameraManager)((Object)torchManager)).mTorchManager;
        if (torchManager == null) {
            return;
        }
        torchManager.toggleTorch();
    }

    public void requestFocus() {
        AutoFocusManager autoFocusManager = ((CameraManager)((Object)autoFocusManager)).mAutoFocusManager;
        if (autoFocusManager != null) {
            autoFocusManager.requestFocus();
        }
    }

    public synchronized void pause() {
        if (!this.mIsResumed) {
            return;
        }
        CameraManager cameraManager = this;
        cameraManager.mIsResumed = false;
        cameraManager.syncAutofocusManager();
        cameraManager.syncTorchManager();
        cameraManager.syncProcessThread(false);
    }

    public synchronized void resume() {
        if (this.mIsResumed) {
            return;
        }
        CameraManager cameraManager = this;
        cameraManager.mIsResumed = true;
        cameraManager.syncAutofocusManager();
        cameraManager.syncTorchManager();
        cameraManager.syncProcessThread(false);
    }

    public synchronized void resumeProcessFrames() {
        if (this.mIsProcessFramesActive) {
            return;
        }
        CameraManager cameraManager = this;
        cameraManager.mIsProcessFramesActive = true;
        cameraManager.syncAutofocusManager();
        cameraManager.syncTorchManager();
        cameraManager.syncProcessThread(false);
    }

    public synchronized void pauseProcessFrames() {
        if (!this.mIsProcessFramesActive) {
            return;
        }
        CameraManager cameraManager = this;
        cameraManager.mIsProcessFramesActive = false;
        cameraManager.syncAutofocusManager();
        cameraManager.syncTorchManager();
        cameraManager.syncProcessThread(false);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void startPreview(SurfaceTexture surfaceTexture) throws IOException, RuntimeException {
        Exception exception2;
        try {
            try {
                if (this.mCamera != null) {
                    CameraManager cameraManager = this;
                    cameraManager.mCamera.setPreviewTexture(surfaceTexture);
                    cameraManager.mCamera.startPreview();
                }
                return;
            }
            catch (RuntimeException exception2) {
            }
        }
        catch (IOException exception2) {
            // empty catch block
        }
        this.releaseCamera();
        throw exception2;
    }
}

