/*
 * Decompiled with CFR 0.152.
 */
package cards.pay.paycardsrecognizer.sdk.camera;

import android.content.Context;
import android.support.annotation.RestrictTo;
import android.support.v4.content.ContextCompat;
import cards.pay.paycardsrecognizer.sdk.camera.BlockingOperationException;
import cards.pay.paycardsrecognizer.sdk.camera.CameraUtils;
import cards.pay.paycardsrecognizer.sdk.ndk.RecognitionCore;
import com.facebook.device.yearclass.YearClass;
import java.util.Locale;

@RestrictTo(value={RestrictTo.Scope.LIBRARY})
public final class RecognitionAvailabilityChecker {
    public static Result doCheck(Context context) {
        return RecognitionAvailabilityChecker.doCheckInternal(context).build();
    }

    private static RecognitionCheckResultBuilder doCheckInternal(Context context) {
        RecognitionCheckResultBuilder recognitionCheckResultBuilder = new RecognitionCheckResultBuilder().isBlockingCheck(false).isDeviceNewEnough(RecognitionAvailabilityChecker.isDeviceNewEnough(context)).hasCamera(RecognitionAvailabilityChecker.isDeviceHasCamera(context));
        boolean bl = ContextCompat.checkSelfPermission((Context)context, (String)"android.permission.CAMERA") == 0;
        recognitionCheckResultBuilder = recognitionCheckResultBuilder.hasCameraPermission(bl);
        try {
            recognitionCheckResultBuilder.isCameraSupported(CameraUtils.isCameraSupported());
        }
        catch (BlockingOperationException blockingOperationException) {}
        if (RecognitionCore.isInitialized()) {
            recognitionCheckResultBuilder.recognitionCoreSupported(RecognitionCore.getInstance(context).isDeviceSupported());
        }
        return recognitionCheckResultBuilder;
    }

    public static boolean isDeviceNewEnough(Context context) {
        return YearClass.get((Context)context) >= 2011;
    }

    public static boolean isDeviceHasCamera(Context context) {
        context = context.getPackageManager();
        boolean bl = context.hasSystemFeature("android.hardware.camera");
        context.hasSystemFeature("android.hardware.camera.autofocus");
        return bl;
    }

    private static class RecognitionCheckResultBuilder {
        private boolean isBlockingCheck = true;
        private int hasCameraPermission = 0;
        private int isDeviceNewEnough = 0;
        private int recognitionCoreSupported = 0;
        private int hasCamera = 0;
        private int isCameraSupported = 0;

        private int toStatus(boolean bl) {
            return bl ? 1 : -1;
        }

        public RecognitionCheckResultBuilder isBlockingCheck(boolean bl) {
            this.isBlockingCheck = bl;
            return this;
        }

        public RecognitionCheckResultBuilder isDeviceNewEnough(boolean bl) {
            RecognitionCheckResultBuilder recognitionCheckResultBuilder = this;
            recognitionCheckResultBuilder.isDeviceNewEnough = recognitionCheckResultBuilder.toStatus(bl);
            return recognitionCheckResultBuilder;
        }

        public RecognitionCheckResultBuilder recognitionCoreSupported(boolean bl) {
            RecognitionCheckResultBuilder recognitionCheckResultBuilder = this;
            recognitionCheckResultBuilder.recognitionCoreSupported = recognitionCheckResultBuilder.toStatus(bl);
            return recognitionCheckResultBuilder;
        }

        public RecognitionCheckResultBuilder hasCamera(boolean bl) {
            RecognitionCheckResultBuilder recognitionCheckResultBuilder = this;
            recognitionCheckResultBuilder.hasCamera = recognitionCheckResultBuilder.toStatus(bl);
            return recognitionCheckResultBuilder;
        }

        public RecognitionCheckResultBuilder hasCameraPermission(boolean bl) {
            RecognitionCheckResultBuilder recognitionCheckResultBuilder = this;
            recognitionCheckResultBuilder.hasCameraPermission = recognitionCheckResultBuilder.toStatus(bl);
            return recognitionCheckResultBuilder;
        }

        public RecognitionCheckResultBuilder isCameraSupported(boolean bl) {
            RecognitionCheckResultBuilder recognitionCheckResultBuilder = this;
            recognitionCheckResultBuilder.isCameraSupported = recognitionCheckResultBuilder.toStatus(bl);
            return recognitionCheckResultBuilder;
        }

        public Result build() {
            return new Result(this.isBlockingCheck, this.isDeviceNewEnough, this.recognitionCoreSupported, this.hasCamera, this.hasCameraPermission, this.isCameraSupported);
        }
    }

    public static class Result {
        public final boolean isBlockingCheck;
        public final int isDeviceNewEnough;
        public final int recognitionCoreSupported;
        public final int hasCamera;
        public final int hasCameraPermission;
        public final int isCameraSupported;

        Result(boolean bl, int n, int n2, int n3, int n4, int n5) {
            this.isBlockingCheck = bl;
            this.isDeviceNewEnough = n;
            this.recognitionCoreSupported = n2;
            this.hasCamera = n3;
            this.hasCameraPermission = n4;
            this.isCameraSupported = n5;
        }

        private boolean isFailedNonBlocking() {
            return this.isDeviceNewEnough == -1 || this.recognitionCoreSupported == -1 || this.hasCamera == -1 || this.hasCameraPermission == -1 || this.isCameraSupported == -1;
        }

        private String statusToString(int n) {
            if (n != -1) {
                if (n != 0) {
                    if (n == 1) {
                        return "yes";
                    }
                    throw new IllegalArgumentException();
                }
                return "not checked";
            }
            return "no";
        }

        public boolean isFailed() {
            if (this.isBlockingCheck) {
                return this.isPassed() ^ true;
            }
            return this.isFailedNonBlocking();
        }

        public boolean isPassed() {
            return this.isDeviceNewEnough == 1 && this.recognitionCoreSupported == 1 && this.hasCamera == 1 && this.hasCameraPermission == 1 && this.isCameraSupported == 1;
        }

        public boolean isFailedOnCameraPermission() {
            return this.hasCameraPermission == -1 && this.isDeviceNewEnough != -1 && this.recognitionCoreSupported != -1 && this.hasCamera != -1 && this.isCameraSupported != -1;
        }

        public String getMessage() {
            if (this.isDeviceNewEnough == -1) {
                return "Device is considered being too old for smooth camera experience, so camera will not be used.";
            }
            if (this.hasCamera == -1) {
                return "No camera";
            }
            if (this.hasCameraPermission == -1) {
                return "No camera permission";
            }
            if (this.isCameraSupported == -1) {
                return "Camera not supported";
            }
            if (this.recognitionCoreSupported == -1) {
                return "Unsupported architecture";
            }
            return this.toString();
        }

        public String toString() {
            Object[] objectArray = new Object[5];
            Object[] objectArray2 = objectArray;
            Result result = this;
            Result result2 = this;
            Result result3 = this;
            Result result4 = this;
            Result result5 = this;
            objectArray2[0] = result5.statusToString(result5.isDeviceNewEnough);
            objectArray2[1] = result4.statusToString(result4.hasCamera);
            objectArray2[2] = result3.statusToString(result3.hasCameraPermission);
            objectArray2[3] = result2.statusToString(result2.recognitionCoreSupported);
            objectArray[4] = result.statusToString(result.isCameraSupported);
            return String.format(Locale.US, "Is new enough: %s, has camera: %s, has camera persmission: %s, recognition library supported: %s, camera supported: %s", objectArray2);
        }
    }
}

