/*
 * Decompiled with CFR 0.152.
 */
package cards.pay.paycardsrecognizer.sdk.camera;

import android.content.Context;
import android.graphics.SurfaceTexture;
import android.hardware.Camera;
import android.opengl.GLES20;
import android.opengl.Matrix;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.support.annotation.RestrictTo;
import android.view.SurfaceHolder;
import cards.pay.paycardsrecognizer.sdk.camera.AutoFocusManager;
import cards.pay.paycardsrecognizer.sdk.camera.CameraManager;
import cards.pay.paycardsrecognizer.sdk.camera.ProcessFrameThread;
import cards.pay.paycardsrecognizer.sdk.camera.ScanManagerHandler;
import cards.pay.paycardsrecognizer.sdk.camera.gles.Drawable2d;
import cards.pay.paycardsrecognizer.sdk.camera.gles.EglCore;
import cards.pay.paycardsrecognizer.sdk.camera.gles.GlUtil;
import cards.pay.paycardsrecognizer.sdk.camera.gles.Sprite2d;
import cards.pay.paycardsrecognizer.sdk.camera.gles.Texture2dProgram;
import cards.pay.paycardsrecognizer.sdk.camera.gles.WindowSurface;
import java.io.IOException;
import java.lang.ref.WeakReference;

@RestrictTo(value={RestrictTo.Scope.LIBRARY})
public final class RenderThread
extends Thread {
    private volatile RenderHandler mHandler;
    private final Object mStartLock = new Object();
    private boolean mReady = false;
    private ScanManagerHandler mMainHandler;
    private final Context mAppContext;
    private CameraManager mCameraManager;
    private SurfaceTexture mCameraTexture;
    private EglCore mEglCore;
    private WindowSurface mWindowSurface;
    private Texture2dProgram mTexProgram;
    private final Sprite2d mRect = new Sprite2d(new Drawable2d());
    private float[] mDisplayProjectionMatrix = new float[16];
    private int mWindowSurfaceWidth;
    private int mWindowSurfaceHeight;
    private int mCameraPreviewWidth = 1280;
    private int mCameraPreviewHeight = 720;
    private int mCameraRotation;
    private float mPosX;
    private float mPosY;
    private volatile boolean mOnFreeze;

    public RenderThread(Context context, ScanManagerHandler scanManagerHandler) {
        this.mMainHandler = scanManagerHandler;
        this.mAppContext = context.getApplicationContext();
    }

    private void shutdown() {
        this.mCameraManager.releaseCamera();
        Looper.myLooper().quit();
    }

    private void surfaceAvailable(SurfaceHolder surfaceHolder, boolean bl) {
        RenderThread renderThread = this;
        renderThread.mWindowSurface = new WindowSurface(this.mEglCore, surfaceHolder, false);
        renderThread.mWindowSurface.makeCurrent();
        renderThread.mTexProgram = new Texture2dProgram();
        int n = renderThread.mTexProgram.createTextureObject();
        renderThread.mCameraTexture = new SurfaceTexture(n);
        renderThread.mRect.setTexture(n);
        if (!bl) {
            RenderThread renderThread2 = this;
            renderThread2.mWindowSurfaceWidth = renderThread2.mWindowSurface.getWidth();
            renderThread2.mWindowSurfaceHeight = renderThread2.mWindowSurface.getHeight();
            renderThread2.finishSurfaceSetup();
        }
        this.mCameraTexture.setOnFrameAvailableListener(new SurfaceTexture.OnFrameAvailableListener(){

            public void onFrameAvailable(SurfaceTexture surfaceTexture) {
                RenderThread.this.mHandler.sendFrameAvailable();
            }
        });
    }

    private void frameAvailable() {
        RenderThread renderThread = this;
        renderThread.mCameraTexture.updateTexImage();
        renderThread.draw();
    }

    private void releaseGl() {
        GlUtil.checkGlError("releaseGl start");
        Object object = this.mWindowSurface;
        if (object != null) {
            ((WindowSurface)object).release();
            this.mWindowSurface = null;
        }
        if ((object = this.mTexProgram) != null) {
            ((Texture2dProgram)object).release();
            this.mTexProgram = null;
        }
        GlUtil.checkGlError("releaseGl done");
        this.mEglCore.makeNothingCurrent();
    }

    private void orientationChanged(int n) {
        this.mCameraRotation = n;
        this.updateGeometry();
    }

    private void freeze() {
        this.mOnFreeze = true;
    }

    private void unfreeze() {
        this.mOnFreeze = false;
    }

    private void surfaceDestroyed() {
        this.releaseGl();
    }

    private void finishSurfaceSetup() {
        RenderThread renderThread = this;
        int n = renderThread.mWindowSurfaceWidth;
        int n2 = renderThread.mWindowSurfaceHeight;
        GLES20.glViewport((int)0, (int)0, (int)n, (int)n2);
        float[] fArray = this.mDisplayProjectionMatrix;
        float f = n;
        float f2 = n2;
        Matrix.orthoM((float[])fArray, (int)0, (float)0.0f, (float)f, (float)0.0f, (float)f2, (float)-1.0f, (float)1.0f);
        this.mPosX = f / 2.0f;
        renderThread.mPosY = f2 / 2.0f;
        renderThread.updateGeometry();
        try {
            renderThread.mCameraManager.startPreview(this.mCameraTexture);
            return;
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    private void updateGeometry() {
        int n;
        int n2;
        RenderThread renderThread = this;
        int n3 = renderThread.mCameraPreviewWidth;
        int n4 = renderThread.mCameraPreviewHeight;
        if (renderThread.mCameraRotation % 180 == 0) {
            RenderThread renderThread2 = this;
            n2 = renderThread2.mWindowSurfaceWidth;
            n = renderThread2.mWindowSurfaceHeight;
        } else {
            RenderThread renderThread3 = this;
            n2 = renderThread3.mWindowSurfaceHeight;
            n = renderThread3.mWindowSurfaceWidth;
        }
        int n5 = n3 * n;
        int n6 = n4 * n2;
        if (n5 > n6) {
            n2 = (int)((float)n5 / (float)n4 + 0.5f);
        } else {
            n = (int)((float)n6 / (float)n3 + 0.5f);
        }
        RenderThread renderThread4 = this;
        renderThread4.mRect.setScale(n2, n);
        renderThread4.mRect.setPosition(this.mPosX, this.mPosY);
        renderThread4.mRect.setRotation((360 - this.mCameraRotation) % 360);
    }

    private void draw() {
        if (this.mOnFreeze) {
            return;
        }
        RenderThread renderThread = this;
        GlUtil.checkGlError("draw start");
        GLES20.glClearColor((float)0.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        GLES20.glClear((int)16384);
        renderThread.mRect.draw(this.mTexProgram, this.mDisplayProjectionMatrix);
        renderThread.mWindowSurface.swapBuffers();
        GlUtil.checkGlError("draw done");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public void run() {
        RenderThread renderThread = this;
        Looper.prepare();
        renderThread.mHandler = new RenderHandler(this);
        Object object = renderThread.mStartLock;
        // MONITORENTER : object
        this.mReady = true;
        this.mStartLock.notify();
        // MONITOREXIT : object
        try {
            renderThread.mEglCore = new EglCore(null, 0);
            renderThread.mCameraManager = new CameraManager(this.mAppContext);
            renderThread.mCameraManager.openCamera();
            renderThread.mCameraManager.setProcessFrameCallbacks(new ProcessFrameThread.Callbacks(){

                @Override
                public void onFrameProcessed(int n) {
                    RenderThread.this.mMainHandler.sendFrameProcessed(n);
                }
            });
            renderThread.mCameraManager.setAutoFocusCallbacks(new AutoFocusManager.FocusMoveCallback(){

                @Override
                public void onAutoFocusMoving(boolean bl, Camera camera) {
                    RenderThread.this.mMainHandler.sendAutoFocusMoving(bl, camera.getParameters().getFocusMode());
                }

                @Override
                public void onAutoFocusComplete(boolean bl, Camera camera) {
                    RenderThread.this.mMainHandler.sendAutoFocusComplete(bl, camera.getParameters().getFocusMode());
                }
            });
            object = renderThread.mCameraManager.getCurrentPreviewSize();
            renderThread.mCameraPreviewWidth = ((Camera.Size)object).width;
            renderThread.mCameraPreviewHeight = ((Camera.Size)object).height;
            renderThread.mCameraRotation = renderThread.mCameraManager.calculateDataRotation();
            renderThread.mMainHandler.sendCameraOpened(this.mCameraManager.getCamera().getParameters());
        }
        catch (Exception exception) {
            Object object2 = Looper.myLooper();
            if (object2 != null) {
                object2.quit();
            }
            if ((object2 = this.mEglCore) != null) {
                ((EglCore)object2).release();
            }
            RenderThread renderThread2 = this;
            renderThread2.mMainHandler.sendOpenCameraError(exception);
            object2 = renderThread2.mStartLock;
            // MONITORENTER : object2
            this.mReady = false;
            this.mStartLock.notify();
            // MONITOREXIT : object2
            return;
        }
        try {
            Looper.loop();
            renderThread.mCameraManager.releaseCamera();
            renderThread.releaseGl();
            renderThread.mEglCore.release();
            object = renderThread.mStartLock;
        }
        catch (Throwable throwable) {
            try {
                RenderThread renderThread3 = this;
                renderThread3.mMainHandler.sendRenderThreadError(throwable);
                renderThread3.mCameraManager.releaseCamera();
                renderThread3.releaseGl();
                renderThread3.mEglCore.release();
                Object object3 = renderThread3.mStartLock;
            }
            catch (Throwable throwable2) {
                RenderThread renderThread4 = this;
                renderThread4.mCameraManager.releaseCamera();
                renderThread4.releaseGl();
                renderThread4.mEglCore.release();
                Object object4 = renderThread4.mStartLock;
                // MONITORENTER : object4
                this.mReady = false;
                // MONITOREXIT : object4
                throw throwable2;
            }
            this.mReady = false;
            // MONITOREXIT : object3
            return;
        }
        this.mReady = false;
        // MONITOREXIT : object
        return;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitUntilReady() {
        Object object = this.mStartLock;
        synchronized (object) {
            while (true) {
                if (this.mReady) break;
                try {
                    this.mStartLock.wait();
                    continue;
                }
                catch (InterruptedException interruptedException) {
                    continue;
                }
                break;
            }
            return;
        }
    }

    public RenderHandler getHandler() {
        return this.mHandler;
    }

    void surfaceChanged(int n, int n2) {
        this.mWindowSurfaceWidth = n;
        this.mWindowSurfaceHeight = n2;
        this.finishSurfaceSetup();
    }

    static class RenderHandler
    extends Handler {
        private WeakReference<RenderThread> mWeakRenderThread;

        public RenderHandler(RenderThread renderThread) {
            this.mWeakRenderThread = new WeakReference<RenderThread>(renderThread);
        }

        public void sendSurfaceAvailable(SurfaceHolder surfaceHolder, boolean bl) {
            RenderHandler renderHandler = this;
            renderHandler.sendMessage(renderHandler.obtainMessage(0, bl ? 1 : 0, 0, surfaceHolder));
        }

        public void sendSurfaceChanged(int n, int n2, int n3) {
            RenderHandler renderHandler = this;
            renderHandler.sendMessage(renderHandler.obtainMessage(1, n2, n3));
        }

        public void sendSurfaceDestroyed() {
            RenderHandler renderHandler = this;
            renderHandler.sendMessage(renderHandler.obtainMessage(2));
        }

        public void sendShutdown() {
            RenderHandler renderHandler = this;
            renderHandler.sendMessage(renderHandler.obtainMessage(3));
        }

        public void sendFrameAvailable() {
            RenderHandler renderHandler = this;
            renderHandler.sendMessage(renderHandler.obtainMessage(4));
        }

        public void sendOrientationChanged(int n) {
            RenderHandler renderHandler = this;
            renderHandler.sendMessage(renderHandler.obtainMessage(5, n, 0));
        }

        public void sendUnfreeze() {
            RenderHandler renderHandler = this;
            renderHandler.sendMessage(renderHandler.obtainMessage(18));
        }

        public void sendFreeze() {
            RenderHandler renderHandler = this;
            renderHandler.sendMessage(renderHandler.obtainMessage(17));
        }

        public void sendRequestFocus() {
            RenderHandler renderHandler = this;
            renderHandler.sendMessage(renderHandler.obtainMessage(16));
        }

        public void sendPauseCamera() {
            RenderHandler renderHandler = this;
            renderHandler.sendMessage(renderHandler.obtainMessage(10));
        }

        public void sendResumeCamera() {
            RenderHandler renderHandler = this;
            renderHandler.sendMessage(renderHandler.obtainMessage(11));
        }

        public void sendPauseProcessFrames() {
            RenderHandler renderHandler = this;
            renderHandler.sendMessage(renderHandler.obtainMessage(12));
        }

        public void sendToggleFlash() {
            RenderHandler renderHandler = this;
            renderHandler.sendMessage(renderHandler.obtainMessage(15));
        }

        public void handleMessage(Message message) {
            int n = message.what;
            RenderThread renderThread = (RenderThread)this.mWeakRenderThread.get();
            if (renderThread == null) {
                return;
            }
            switch (n) {
                default: {
                    throw new RuntimeException("unknown message " + n);
                }
                case 18: {
                    renderThread.unfreeze();
                    break;
                }
                case 17: {
                    renderThread.freeze();
                    break;
                }
                case 16: {
                    renderThread.mCameraManager.requestFocus();
                    break;
                }
                case 15: {
                    renderThread.mCameraManager.toggleFlash();
                    break;
                }
                case 14: {
                    renderThread.mCameraManager.resumeProcessFrames();
                    break;
                }
                case 12: {
                    renderThread.mCameraManager.pauseProcessFrames();
                    break;
                }
                case 11: {
                    renderThread.mCameraManager.resume();
                    break;
                }
                case 10: {
                    renderThread.mCameraManager.pause();
                    break;
                }
                case 9: {
                    renderThread.draw();
                    break;
                }
                case 5: {
                    renderThread.orientationChanged(message.arg1);
                    break;
                }
                case 4: {
                    renderThread.frameAvailable();
                    break;
                }
                case 3: {
                    renderThread.shutdown();
                    break;
                }
                case 2: {
                    renderThread.surfaceDestroyed();
                    break;
                }
                case 1: {
                    renderThread.surfaceChanged(message.arg1, message.arg2);
                    break;
                }
                case 0: {
                    Message message2 = message;
                    SurfaceHolder surfaceHolder = (SurfaceHolder)message2.obj;
                    boolean bl = message2.arg1 != 0;
                    renderThread.surfaceAvailable(surfaceHolder, bl);
                }
            }
        }
    }
}

