/*
 * Decompiled with CFR 0.152.
 */
package cards.pay.paycardsrecognizer.sdk.camera;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Rect;
import android.hardware.Camera;
import android.hardware.Sensor;
import android.hardware.SensorEvent;
import android.hardware.SensorEventListener;
import android.hardware.SensorManager;
import android.support.annotation.MainThread;
import android.support.annotation.Nullable;
import android.support.annotation.RestrictTo;
import android.view.Display;
import android.view.SurfaceHolder;
import android.view.SurfaceView;
import android.view.View;
import android.view.WindowManager;
import cards.pay.paycardsrecognizer.sdk.camera.CameraUtils;
import cards.pay.paycardsrecognizer.sdk.camera.OrientationHelper;
import cards.pay.paycardsrecognizer.sdk.camera.RenderThread;
import cards.pay.paycardsrecognizer.sdk.camera.ScanManagerHandler;
import cards.pay.paycardsrecognizer.sdk.camera.WindowRotationListener;
import cards.pay.paycardsrecognizer.sdk.camera.widget.CameraPreviewLayout;
import cards.pay.paycardsrecognizer.sdk.camera.widget.CardDetectionStateView;
import cards.pay.paycardsrecognizer.sdk.camera.widget.OnWindowFocusChangedListener;
import cards.pay.paycardsrecognizer.sdk.ndk.DisplayConfigurationImpl;
import cards.pay.paycardsrecognizer.sdk.ndk.RecognitionCore;
import cards.pay.paycardsrecognizer.sdk.ndk.RecognitionResult;
import cards.pay.paycardsrecognizer.sdk.ndk.RecognitionStatusListener;
import cards.pay.paycardsrecognizer.sdk.utils.Size;

@RestrictTo(value={RestrictTo.Scope.LIBRARY})
public final class ScanManager {
    private static SurfaceHolder sSurfaceHolder;
    private final int mRecognitionMode;
    private final Context mAppContext;
    private final Callbacks mCallbacks;
    private RecognitionCore mRecognitionCore;
    private CameraPreviewLayout mPreviewLayout;
    private ScanManagerHandler mHandler;
    @Nullable
    private RenderThread mRenderThread;
    private final WindowRotationListener mWindowRotationListener;
    private final DisplayConfigurationImpl mDisplayConfiguration;
    private final RecognitionStatusListener mRecognitionStatusListener = new RecognitionStatusListener(){

        @Override
        public void onRecognitionComplete(RecognitionResult recognitionResult) {
            ScanManager.this.getCardDetectionStateView().setRecognitionResult(recognitionResult);
            if (recognitionResult.isFirst()) {
                if (ScanManager.this.mRenderThread != null) {
                    ScanManager.this.mRenderThread.getHandler().sendPauseProcessFrames();
                }
                ScanManager.this.getCardDetectionStateView().setDetectionState(15);
            }
            if (recognitionResult.isFinal()) {
                System.nanoTime();
            }
            ScanManager.this.mCallbacks.onRecognitionComplete(recognitionResult);
        }

        @Override
        public void onCardImageReceived(Bitmap bitmap) {
            ScanManager.this.mCallbacks.onCardImageReceived(bitmap);
        }
    };
    private final SensorEventListener mShakeEventListener = new SensorEventListener(){
        long lastUpdate;
        public double[] gravity = new double[3];

        public void onSensorChanged(SensorEvent object) {
            long l = System.currentTimeMillis();
            long l2 = l - this.lastUpdate;
            if (500L < l2) {
                SensorEvent sensorEvent = object;
                5 v1 = this;
                v1.lastUpdate = l;
                object = v1.gravity;
                double d = v1.gravity[0] * (double)0.8f;
                float[] fArray = sensorEvent.values;
                Object object2 = object;
                object2[0] = (SensorEvent)(d += (double)(fArray[0] * 0.19999999f));
                d = (double)(object2[1] * (double)0.8f + (double)(fArray[1] * 0.19999999f));
                object2[1] = (SensorEvent)d;
                d = (double)(object2[2] * (double)0.8f + (double)(fArray[2] * 0.19999999f));
                object2[2] = (SensorEvent)d;
                double d2 = (double)sensorEvent.values[0] - object[0];
                d = (double)fArray[1] - object[1];
                double d3 = (double)fArray[2] - object[2];
                double d4 = d;
                double d5 = d3;
                d = Math.sqrt(d2 * d2 + d4 * d4 + d5 * d5);
                if (3.3 < d && ScanManager.this.mRenderThread != null) {
                    ScanManager.this.mRenderThread.getHandler().sendRequestFocus();
                }
            }
        }

        public void onAccuracyChanged(Sensor sensor, int n) {
        }
    };

    public ScanManager(int n, Context context, CameraPreviewLayout cameraPreviewLayout, Callbacks callbacks) throws RuntimeException {
        if (n == 0) {
            n = 15;
        }
        ScanManager scanManager = this;
        this.mRecognitionMode = n;
        this.mAppContext = context.getApplicationContext();
        this.mCallbacks = callbacks;
        scanManager.mPreviewLayout = cameraPreviewLayout;
        scanManager.mRecognitionCore = RecognitionCore.getInstance(scanManager.mAppContext);
        scanManager.mHandler = new ScanManagerHandler(this);
        Display display = scanManager.getDisplay();
        scanManager.mDisplayConfiguration = new DisplayConfigurationImpl();
        scanManager.mDisplayConfiguration.setCameraParameters(CameraUtils.getBackCameraSensorOrientation());
        scanManager.mDisplayConfiguration.setDisplayParameters(display);
        scanManager.mRecognitionCore.setDisplayConfiguration(this.mDisplayConfiguration);
        scanManager.getSurfaceView().getHolder().addCallback(new SurfaceHolder.Callback(){

            public void surfaceCreated(SurfaceHolder surfaceHolder) {
                if (sSurfaceHolder == null) {
                    sSurfaceHolder = surfaceHolder;
                    if (ScanManager.this.mRenderThread != null) {
                        ScanManager.this.mRenderThread.getHandler().sendSurfaceAvailable(surfaceHolder, true);
                    }
                    return;
                }
                throw new RuntimeException("sSurfaceHolder is already set");
            }

            public void surfaceChanged(SurfaceHolder surfaceHolder, int n, int n2, int n3) {
                if (ScanManager.this.mRenderThread != null) {
                    ScanManager.this.mRenderThread.getHandler().sendSurfaceChanged(n, n2, n3);
                }
            }

            public void surfaceDestroyed(SurfaceHolder surfaceHolder) {
                if (ScanManager.this.mRenderThread != null) {
                    ScanManager.this.mRenderThread.getHandler().sendSurfaceDestroyed();
                }
                sSurfaceHolder = null;
            }
        });
        scanManager.mWindowRotationListener = new WindowRotationListener();
    }

    private SurfaceView getSurfaceView() {
        return this.mPreviewLayout.getSurfaceView();
    }

    private CardDetectionStateView getCardDetectionStateView() {
        return this.mPreviewLayout.getDetectionStateOverlay();
    }

    private Display getDisplay() {
        return ((WindowManager)this.mAppContext.getSystemService("window")).getDefaultDisplay();
    }

    private void refreshDisplayOrientation() {
        ScanManager scanManager = this;
        Display display = scanManager.getDisplay();
        scanManager.mDisplayConfiguration.setDisplayParameters(display);
        scanManager.mRecognitionCore.setDisplayConfiguration(this.mDisplayConfiguration);
        if (scanManager.mRenderThread != null) {
            int n = CameraUtils.getBackCameraDataRotation(display);
            this.mRenderThread.getHandler().sendOrientationChanged(n);
        }
    }

    private void setupCardDetectionCameraParameters(int n, int n2) {
        ScanManager scanManager = this;
        Size size = CameraUtils.CAMERA_RESOLUTION.size;
        size = OrientationHelper.rotateRect(scanManager.mRecognitionCore.getCardFrameRect(), size.height, size.width, 90, null);
        scanManager.mPreviewLayout.setCameraParameters(n, n2, CameraUtils.getBackCameraDataRotation(this.getDisplay()), (Rect)size);
    }

    private void startShakeDetector() {
        SensorManager sensorManager = (SensorManager)this.mAppContext.getSystemService("sensor");
        Sensor sensor = sensorManager.getDefaultSensor(1);
        if (sensor != null) {
            sensorManager.registerListener(this.mShakeEventListener, sensor, 1);
        }
    }

    private void stopShakeDetector() {
        ((SensorManager)this.mAppContext.getSystemService("sensor")).unregisterListener(this.mShakeEventListener);
    }

    public void onResume() {
        ScanManager scanManager = this;
        scanManager.mRenderThread = new RenderThread(this.mAppContext, this.mHandler);
        scanManager.mRenderThread.setName("Camera thread");
        scanManager.mRenderThread.start();
        scanManager.mRenderThread.waitUntilReady();
        RenderThread.RenderHandler renderHandler = scanManager.mRenderThread.getHandler();
        SurfaceHolder surfaceHolder = sSurfaceHolder;
        if (surfaceHolder != null) {
            renderHandler.sendSurfaceAvailable(surfaceHolder, false);
        }
        ScanManager scanManager2 = this;
        scanManager2.mDisplayConfiguration.setCameraParameters(CameraUtils.getBackCameraSensorOrientation());
        scanManager2.mRecognitionCore.setRecognitionMode(this.mRecognitionMode);
        scanManager2.mRecognitionCore.setStatusListener(this.mRecognitionStatusListener);
        scanManager2.mRecognitionCore.resetResult();
        RenderThread.RenderHandler renderHandler2 = scanManager2.mRenderThread.getHandler();
        renderHandler2.sendOrientationChanged(CameraUtils.getBackCameraDataRotation(this.getDisplay()));
        renderHandler2.sendUnfreeze();
        scanManager2.mPreviewLayout.setOnWindowFocusChangedListener(new OnWindowFocusChangedListener(){

            @Override
            public void onWindowFocusChanged(View view, boolean bl) {
                if (bl) {
                    ScanManager.this.setRecognitionCoreIdle(false);
                } else {
                    ScanManager.this.setRecognitionCoreIdle(true);
                }
            }
        });
        scanManager2.startShakeDetector();
        scanManager2.mWindowRotationListener.register(this.mAppContext, this.getDisplay(), new WindowRotationListener.RotationListener(){

            @Override
            public void onWindowRotationChanged() {
                ScanManager.this.refreshDisplayOrientation();
            }
        });
        scanManager2.getCardDetectionStateView().setRecognitionResult(RecognitionResult.empty());
        scanManager2.setRecognitionCoreIdle(false);
    }

    public void onPause() {
        ScanManager scanManager = this;
        scanManager.setRecognitionCoreIdle(true);
        scanManager.stopShakeDetector();
        scanManager.mPreviewLayout.setOnWindowFocusChangedListener(null);
        scanManager.mRecognitionCore.setStatusListener(null);
        RenderThread renderThread = scanManager.mRenderThread;
        if (renderThread != null) {
            block3: {
                renderThread.getHandler().sendShutdown();
                try {
                    this.mRenderThread.join();
                }
                catch (InterruptedException interruptedException) {
                    Callbacks callbacks = this.mCallbacks;
                    if (callbacks == null) break block3;
                    callbacks.onOpenCameraError(interruptedException);
                }
            }
            this.mRenderThread = null;
        }
        this.mWindowRotationListener.unregister();
    }

    public void toggleFlash() {
        RenderThread renderThread = ((ScanManager)((Object)renderThread)).mRenderThread;
        if (renderThread == null) {
            return;
        }
        renderThread.getHandler().sendToggleFlash();
    }

    public void setRecognitionCoreIdle(boolean bl) {
        ScanManager scanManager = renderThread;
        scanManager.mRecognitionCore.setIdle(bl);
        RenderThread renderThread = scanManager.mRenderThread;
        if (renderThread != null) {
            if (bl) {
                renderThread.getHandler().sendPauseCamera();
            } else {
                renderThread.getHandler().sendResumeCamera();
            }
        }
    }

    @MainThread
    void onCameraOpened(Camera.Parameters parameters) {
        ScanManager scanManager = object;
        Object object = parameters.getPreviewSize();
        scanManager.setupCardDetectionCameraParameters(((Camera.Size)object).width, ((Camera.Size)object).height);
        object = scanManager.mCallbacks;
        if (object != null) {
            object.onCameraOpened(parameters);
        }
    }

    @MainThread
    void onOpenCameraError(Exception exception) {
        Callbacks callbacks = this.mCallbacks;
        if (callbacks != null) {
            callbacks.onOpenCameraError(exception);
        }
        this.mRenderThread = null;
    }

    @MainThread
    void onRenderThreadError(Throwable throwable) {
        Callbacks callbacks = this.mCallbacks;
        if (callbacks != null) {
            callbacks.onOpenCameraError((Exception)throwable);
        }
        this.mRenderThread = null;
    }

    @MainThread
    void onFrameProcessed(int n) {
        if (this.mCallbacks != null) {
            this.mPreviewLayout.getDetectionStateOverlay().setDetectionState(n);
        }
    }

    @MainThread
    void onFpsReport(String string) {
        Callbacks callbacks = ((ScanManager)((Object)callbacks)).mCallbacks;
        if (callbacks != null) {
            callbacks.onFpsReport(string);
        }
    }

    @MainThread
    void onAutoFocusMoving(boolean bl, String string) {
        Callbacks callbacks = ((ScanManager)((Object)callbacks)).mCallbacks;
        if (callbacks != null) {
            callbacks.onAutoFocusMoving(bl, string);
        }
    }

    @MainThread
    void onAutoFocusComplete(boolean bl, String string) {
        Callbacks callbacks = ((ScanManager)((Object)callbacks)).mCallbacks;
        if (callbacks != null) {
            callbacks.onAutoFocusComplete(bl, string);
        }
    }

    public void freezeCameraPreview() {
        RenderThread renderThread = ((ScanManager)((Object)renderThread)).mRenderThread;
        if (renderThread != null) {
            renderThread.getHandler().sendFreeze();
        }
    }

    public static interface Callbacks {
        public void onCameraOpened(Camera.Parameters var1);

        public void onOpenCameraError(Exception var1);

        public void onRecognitionComplete(RecognitionResult var1);

        public void onCardImageReceived(Bitmap var1);

        public void onFpsReport(String var1);

        public void onAutoFocusMoving(boolean var1, String var2);

        public void onAutoFocusComplete(boolean var1, String var2);
    }
}

