/*
 * Decompiled with CFR 0.152.
 */
package cards.pay.paycardsrecognizer.sdk.camera;

import android.hardware.Camera;
import android.os.Handler;
import android.os.Message;
import android.support.annotation.RestrictTo;
import cards.pay.paycardsrecognizer.sdk.camera.ScanManager;
import java.lang.ref.WeakReference;

@RestrictTo(value={RestrictTo.Scope.LIBRARY})
public final class ScanManagerHandler
extends Handler {
    private WeakReference<ScanManager> mWeakScanManager;

    public ScanManagerHandler(ScanManager scanManager) {
        this.mWeakScanManager = new WeakReference<ScanManager>(scanManager);
    }

    public void sendOpenCameraError(Exception exception) {
        ScanManagerHandler scanManagerHandler = this;
        scanManagerHandler.sendMessage(scanManagerHandler.obtainMessage(1, exception));
    }

    public void sendRenderThreadError(Throwable throwable) {
        ScanManagerHandler scanManagerHandler = this;
        scanManagerHandler.sendMessage(scanManagerHandler.obtainMessage(2, throwable));
    }

    public void sendCameraOpened(Camera.Parameters parameters) {
        ScanManagerHandler scanManagerHandler = this;
        scanManagerHandler.sendMessage(scanManagerHandler.obtainMessage(3, parameters));
    }

    public void sendFrameProcessed(int n) {
        ScanManagerHandler scanManagerHandler = this;
        scanManagerHandler.sendMessage(scanManagerHandler.obtainMessage(4, n, 0));
    }

    public void sendAutoFocusMoving(boolean bl, String string) {
        ScanManagerHandler scanManagerHandler = this;
        scanManagerHandler.sendMessage(scanManagerHandler.obtainMessage(6, bl ? 1 : 0, 0, string));
    }

    public void sendAutoFocusComplete(boolean bl, String string) {
        ScanManagerHandler scanManagerHandler = this;
        scanManagerHandler.sendMessage(scanManagerHandler.obtainMessage(7, bl ? 1 : 0, 0, string));
    }

    public void handleMessage(Message message) {
        ScanManager scanManager = (ScanManager)((ScanManagerHandler)((Object)scanManager)).mWeakScanManager.get();
        if (scanManager == null) {
            return;
        }
        switch (message.what) {
            default: {
                throw new RuntimeException("Unknown message " + message.what);
            }
            case 7: {
                boolean bl = message.arg1 != 0;
                scanManager.onAutoFocusComplete(bl, (String)message.obj);
                break;
            }
            case 6: {
                boolean bl = message.arg1 != 0;
                scanManager.onAutoFocusMoving(bl, (String)message.obj);
                break;
            }
            case 5: {
                scanManager.onFpsReport((String)message.obj);
                break;
            }
            case 4: {
                scanManager.onFrameProcessed(message.arg1);
                break;
            }
            case 3: {
                scanManager.onCameraOpened((Camera.Parameters)message.obj);
                break;
            }
            case 2: {
                scanManager.onRenderThreadError((Throwable)message.obj);
                break;
            }
            case 1: {
                scanManager.onOpenCameraError((Exception)message.obj);
            }
        }
    }
}

