/*
 * Decompiled with CFR 0.152.
 */
package cards.pay.paycardsrecognizer.sdk.camera;

import android.annotation.TargetApi;
import android.content.Context;
import android.hardware.display.DisplayManager;
import android.os.Build;
import android.os.Handler;
import android.support.annotation.RestrictTo;
import android.util.Log;
import android.view.Display;
import android.view.OrientationEventListener;
import cards.pay.paycardsrecognizer.sdk.camera.OrientationHelper;

@RestrictTo(value={RestrictTo.Scope.LIBRARY})
public final class WindowRotationListener {
    private static boolean DBG = false;
    private static final Impl sImpl = Build.VERSION.SDK_INT >= 17 ? new ImplApi17() : new ImplDefault();

    public void register(Context context, Display display, RotationListener rotationListener) {
        sImpl.register(context, display, rotationListener);
    }

    public void unregister() {
        sImpl.unregister();
    }

    @TargetApi(value=17)
    private static class ImplApi17
    implements Impl,
    DisplayManager.DisplayListener {
        private RotationListener mListener;
        private final Handler mHandler = new Handler();
        private DisplayManager mDisplayManager;
        private int mDisplayId;

        @Override
        public void register(Context context, Display display, RotationListener rotationListener) {
            this.mListener = rotationListener;
            this.mDisplayManager = (DisplayManager)context.getSystemService("display");
            ImplApi17 implApi17 = this;
            this.mDisplayManager.registerDisplayListener((DisplayManager.DisplayListener)implApi17, implApi17.mHandler);
            this.mDisplayId = display.getDisplayId();
        }

        @Override
        public void unregister() {
            DisplayManager displayManager = this.mDisplayManager;
            if (displayManager == null) {
                return;
            }
            ImplApi17 implApi17 = this;
            displayManager.unregisterDisplayListener((DisplayManager.DisplayListener)this);
            implApi17.mDisplayManager = null;
            implApi17.mListener = null;
        }

        public void onDisplayAdded(int n) {
            if (DBG) {
                Log.d((String)"WindowRotationListener", (String)("onDisplayAdded() called with: displayId = [" + n + "]"));
            }
        }

        public void onDisplayRemoved(int n) {
            if (DBG) {
                Log.d((String)"WindowRotationListener", (String)("onDisplayRemoved() called with: displayId = [" + n + "]"));
            }
        }

        public void onDisplayChanged(int n) {
            RotationListener rotationListener;
            if (DBG) {
                Log.d((String)"WindowRotationListener", (String)("onDisplayChanged() called with: displayId = [" + n + "]"));
            }
            if ((rotationListener = this.mListener) != null && n == this.mDisplayId) {
                rotationListener.onWindowRotationChanged();
            }
        }
    }

    private static class ImplDefault
    implements Impl {
        private Display mDisplay;
        private RotationListener mListener;
        private OrientationEventListener mOrientationListener;

        private ImplDefault() {
        }

        @Override
        public void register(Context context, Display display, RotationListener rotationListener) {
            this.mDisplay = display;
            this.mListener = rotationListener;
            this.mOrientationListener = new OrientationEventListener(this, context){
                int lastWindowOrientation;
                int lastOrientation;
                final /* synthetic */ ImplDefault this$0;
                {
                    1 v0 = this;
                    this.this$0 = implDefault;
                    super(context);
                    v0.lastOrientation = v0.lastWindowOrientation = OrientationHelper.getDisplayRotationDegrees(v0.this$0.mDisplay);
                }

                public void onOrientationChanged(int n) {
                    if (this.this$0.mDisplay == null) {
                        return;
                    }
                    if ((n = (n + 45) / 90 * 90) == this.lastOrientation) {
                        return;
                    }
                    this.lastOrientation = n;
                    int n2 = OrientationHelper.getDisplayRotationDegrees(this.this$0.mDisplay);
                    if (n2 == this.lastWindowOrientation) {
                        return;
                    }
                    this.lastWindowOrientation = n2;
                    if (n == -1) {
                        return;
                    }
                    if (this.this$0.mListener != null) {
                        this.this$0.mListener.onWindowRotationChanged();
                    }
                }
            };
            this.mOrientationListener.enable();
        }

        @Override
        public void unregister() {
            OrientationEventListener orientationEventListener = this.mOrientationListener;
            if (orientationEventListener == null) {
                return;
            }
            ImplDefault implDefault = this;
            orientationEventListener.disable();
            implDefault.mOrientationListener = null;
            implDefault.mDisplay = null;
            implDefault.mListener = null;
        }
    }

    private static interface Impl {
        public void register(Context var1, Display var2, RotationListener var3);

        public void unregister();
    }

    public static interface RotationListener {
        public void onWindowRotationChanged();
    }
}

