/*
 * Decompiled with CFR 0.152.
 */
package cards.pay.paycardsrecognizer.sdk.camera.gles;

import android.support.annotation.RestrictTo;
import cards.pay.paycardsrecognizer.sdk.camera.gles.GlUtil;
import java.nio.FloatBuffer;

@RestrictTo(value={RestrictTo.Scope.LIBRARY})
public final class Drawable2d {
    private static final float[] RECTANGLE_COORDS = new float[]{-0.5f, -0.5f, 0.5f, -0.5f, -0.5f, 0.5f, 0.5f, 0.5f};
    private static final float[] RECTANGLE_TEX_COORDS = new float[]{0.0f, 1.0f, 1.0f, 1.0f, 0.0f, 0.0f, 1.0f, 0.0f};
    private static final FloatBuffer RECTANGLE_BUF = GlUtil.createFloatBuffer(RECTANGLE_COORDS);
    private static final FloatBuffer RECTANGLE_TEX_BUF = GlUtil.createFloatBuffer(RECTANGLE_TEX_COORDS);
    private FloatBuffer mVertexArray = RECTANGLE_BUF;
    private FloatBuffer mTexCoordArray = RECTANGLE_TEX_BUF;
    private int mVertexCount;
    private int mCoordsPerVertex;
    private int mVertexStride;
    private int mTexCoordStride;

    public Drawable2d() {
        int n = this.mCoordsPerVertex = 2;
        this.mVertexStride = n * 4;
        this.mVertexCount = RECTANGLE_COORDS.length / n;
        this.mTexCoordStride = 8;
    }

    public FloatBuffer getVertexArray() {
        return this.mVertexArray;
    }

    public FloatBuffer getTexCoordArray() {
        return this.mTexCoordArray;
    }

    public int getVertexCount() {
        return this.mVertexCount;
    }

    public int getVertexStride() {
        return this.mVertexStride;
    }

    public int getTexCoordStride() {
        return this.mTexCoordStride;
    }

    public int getCoordsPerVertex() {
        return this.mCoordsPerVertex;
    }

    public String toString() {
        return "[Drawable2d: Rectangle]";
    }
}

