/*
 * Decompiled with CFR 0.152.
 */
package cards.pay.paycardsrecognizer.sdk.camera.gles;

import android.opengl.GLES20;
import cards.pay.paycardsrecognizer.sdk.camera.gles.GlUtil;
import java.nio.Buffer;
import java.nio.FloatBuffer;

public class Texture2dProgram {
    private int mProgramHandle;
    private int muMVPMatrixLoc;
    private int muTexMatrixLoc;
    private int muKernelLoc;
    private int muTexOffsetLoc;
    private int muColorAdjustLoc;
    private int maPositionLoc;
    private int maTextureCoordLoc;
    private int mTextureTarget;
    private float[] mKernel;
    private float[] mTexOffset;
    private float mColorAdjust;

    public Texture2dProgram() {
        Texture2dProgram texture2dProgram = this;
        texture2dProgram.mKernel = new float[9];
        texture2dProgram.mTextureTarget = 36197;
        texture2dProgram.mProgramHandle = GlUtil.createProgram("uniform mat4 uMVPMatrix;\nuniform mat4 uTexMatrix;\nattribute vec4 aPosition;\nattribute vec4 aTextureCoord;\nvarying vec2 vTextureCoord;\nvoid main() {\n    gl_Position = uMVPMatrix * aPosition;\n    vTextureCoord = (uTexMatrix * aTextureCoord).xy;\n}\n", "#extension GL_OES_EGL_image_external : require\nprecision mediump float;\nvarying vec2 vTextureCoord;\nuniform samplerExternalOES sTexture;\nvoid main() {\n    gl_FragColor = texture2D(sTexture, vTextureCoord);\n}\n");
        texture2dProgram.maPositionLoc = GLES20.glGetAttribLocation((int)texture2dProgram.mProgramHandle, (String)"aPosition");
        GlUtil.checkLocation(texture2dProgram.maPositionLoc, "aPosition");
        texture2dProgram.maTextureCoordLoc = GLES20.glGetAttribLocation((int)texture2dProgram.mProgramHandle, (String)"aTextureCoord");
        GlUtil.checkLocation(texture2dProgram.maTextureCoordLoc, "aTextureCoord");
        texture2dProgram.muMVPMatrixLoc = GLES20.glGetUniformLocation((int)texture2dProgram.mProgramHandle, (String)"uMVPMatrix");
        GlUtil.checkLocation(texture2dProgram.muMVPMatrixLoc, "uMVPMatrix");
        texture2dProgram.muTexMatrixLoc = GLES20.glGetUniformLocation((int)texture2dProgram.mProgramHandle, (String)"uTexMatrix");
        GlUtil.checkLocation(texture2dProgram.muTexMatrixLoc, "uTexMatrix");
        texture2dProgram.muKernelLoc = GLES20.glGetUniformLocation((int)texture2dProgram.mProgramHandle, (String)"uKernel");
        if (texture2dProgram.muKernelLoc < 0) {
            Texture2dProgram texture2dProgram2 = this;
            texture2dProgram2.muKernelLoc = -1;
            texture2dProgram2.muTexOffsetLoc = -1;
            texture2dProgram2.muColorAdjustLoc = -1;
        } else {
            Texture2dProgram texture2dProgram3 = this;
            texture2dProgram3.muTexOffsetLoc = GLES20.glGetUniformLocation((int)texture2dProgram3.mProgramHandle, (String)"uTexOffset");
            GlUtil.checkLocation(texture2dProgram3.muTexOffsetLoc, "uTexOffset");
            texture2dProgram3.muColorAdjustLoc = GLES20.glGetUniformLocation((int)texture2dProgram3.mProgramHandle, (String)"uColorAdjust");
            GlUtil.checkLocation(texture2dProgram3.muColorAdjustLoc, "uColorAdjust");
            texture2dProgram3.setKernel(new float[]{0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f}, 0.0f);
            texture2dProgram3.setTexSize(256, 256);
        }
    }

    private void setKernel(float[] fArray, float f) {
        if (fArray.length == 9) {
            System.arraycopy(fArray, 0, this.mKernel, 0, 9);
            this.mColorAdjust = f;
            return;
        }
        throw new IllegalArgumentException("Kernel size is " + fArray.length + " vs. " + 9);
    }

    public void release() {
        GLES20.glDeleteProgram((int)this.mProgramHandle);
        this.mProgramHandle = -1;
    }

    public int createTextureObject() {
        int[] nArray = new int[1];
        GLES20.glGenTextures((int)1, (int[])nArray, (int)0);
        GlUtil.checkGlError("glGenTextures");
        int n = nArray[0];
        GLES20.glBindTexture((int)this.mTextureTarget, (int)n);
        GlUtil.checkGlError("glBindTexture " + n);
        GLES20.glTexParameterf((int)36197, (int)10241, (float)9728.0f);
        GLES20.glTexParameterf((int)36197, (int)10240, (float)9729.0f);
        GLES20.glTexParameteri((int)36197, (int)10242, (int)33071);
        GLES20.glTexParameteri((int)36197, (int)10243, (int)33071);
        GlUtil.checkGlError("glTexParameter");
        return n;
    }

    public void setTexSize(int n, int n2) {
        float f = 1.0f / (float)n;
        float f2 = 1.0f / (float)n2;
        float f3 = -f;
        float f4 = -f2;
        this.mTexOffset = new float[]{f3, f4, 0.0f, f4, f, f4, f3, 0.0f, 0.0f, 0.0f, f, 0.0f, f3, f2, 0.0f, f2, f, f2};
    }

    public void draw(float[] fArray, FloatBuffer floatBuffer, int n, int n2, int n3, int n4, float[] fArray2, FloatBuffer floatBuffer2, int n5, int n6) {
        Texture2dProgram texture2dProgram = this;
        GlUtil.checkGlError("draw start");
        GLES20.glUseProgram((int)texture2dProgram.mProgramHandle);
        GlUtil.checkGlError("glUseProgram");
        GLES20.glActiveTexture((int)33984);
        GLES20.glBindTexture((int)texture2dProgram.mTextureTarget, (int)n5);
        GLES20.glUniformMatrix4fv((int)texture2dProgram.muMVPMatrixLoc, (int)1, (boolean)false, (float[])fArray, (int)0);
        GlUtil.checkGlError("glUniformMatrix4fv");
        GLES20.glUniformMatrix4fv((int)texture2dProgram.muTexMatrixLoc, (int)1, (boolean)false, (float[])fArray2, (int)0);
        GlUtil.checkGlError("glUniformMatrix4fv");
        GLES20.glEnableVertexAttribArray((int)texture2dProgram.maPositionLoc);
        GlUtil.checkGlError("glEnableVertexAttribArray");
        GLES20.glVertexAttribPointer((int)texture2dProgram.maPositionLoc, (int)n3, (int)5126, (boolean)false, (int)n4, (Buffer)floatBuffer);
        GlUtil.checkGlError("glVertexAttribPointer");
        GLES20.glEnableVertexAttribArray((int)texture2dProgram.maTextureCoordLoc);
        GlUtil.checkGlError("glEnableVertexAttribArray");
        GLES20.glVertexAttribPointer((int)texture2dProgram.maTextureCoordLoc, (int)2, (int)5126, (boolean)false, (int)n6, (Buffer)floatBuffer2);
        GlUtil.checkGlError("glVertexAttribPointer");
        int n7 = texture2dProgram.muKernelLoc;
        if (n7 >= 0) {
            Texture2dProgram texture2dProgram2 = this;
            GLES20.glUniform1fv((int)n7, (int)9, (float[])this.mKernel, (int)0);
            GLES20.glUniform2fv((int)texture2dProgram2.muTexOffsetLoc, (int)9, (float[])this.mTexOffset, (int)0);
            GLES20.glUniform1f((int)texture2dProgram2.muColorAdjustLoc, (float)this.mColorAdjust);
        }
        Texture2dProgram texture2dProgram3 = this;
        GLES20.glDrawArrays((int)5, (int)n, (int)n2);
        GlUtil.checkGlError("glDrawArrays");
        GLES20.glDisableVertexAttribArray((int)texture2dProgram3.maPositionLoc);
        GLES20.glDisableVertexAttribArray((int)texture2dProgram3.maTextureCoordLoc);
        GLES20.glBindTexture((int)texture2dProgram3.mTextureTarget, (int)0);
        GLES20.glUseProgram((int)0);
    }
}

