/*
 * Decompiled with CFR 0.152.
 */
package cards.pay.paycardsrecognizer.sdk.camera.widget;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.Typeface;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.util.TypedValue;
import android.view.View;
import cards.pay.paycardsrecognizer.sdk.R;
import cards.pay.paycardsrecognizer.sdk.camera.widget.CardRectCoordsMapper;
import cards.pay.paycardsrecognizer.sdk.ndk.RecognitionResult;
import cards.pay.paycardsrecognizer.sdk.utils.CardUtils;
import cards.pay.paycardsrecognizer.sdk.utils.Fonts;

public class CardDetectionStateView
extends View {
    private volatile int mDetectionState;
    private volatile String mRecognitionResultDate;
    private volatile String mRecognitionResultCardNumber;
    private volatile String mRecognitionResultHolder;
    private CardRectCoordsMapper mCardFrame;
    private float mDisplayDensity;
    private Typeface mCardTypeface;
    private final Rect mCardRectInvalidation = new Rect();
    private float mCornerPaddingLeft;
    private float mCornerPaddingTop;
    private float mCornerLineWidth;
    private float mCornerRadius;
    private Drawable mCardGradientDrawable;
    private BitmapDrawable mCornerTopLeftDrawable;
    private BitmapDrawable mCornerTopRightDrawable;
    private BitmapDrawable mCornerBottomLeftDrawable;
    private BitmapDrawable mCornerBottomRightDrawable;
    private BitmapDrawable mLineTopDrawable;
    private BitmapDrawable mLineLeftDrawable;
    private BitmapDrawable mLineRightDrawable;
    private BitmapDrawable mLineBottomDrawable;
    private Paint mBackgroundPaint;
    private Paint mCardNumberPaint;
    private Paint mCardDatePaint;
    private Paint mCardHolderPaint;

    public CardDetectionStateView(Context context) {
        this(context, null);
    }

    public CardDetectionStateView(Context context, AttributeSet attributeSet) {
        this(context, attributeSet, 0);
    }

    public CardDetectionStateView(Context context, AttributeSet attributeSet, int n) {
        super(context, attributeSet, n);
        this.init(context);
    }

    private void init(Context context) {
        CardDetectionStateView cardDetectionStateView = this;
        CardDetectionStateView cardDetectionStateView2 = this;
        float f = this.getResources().getDisplayMetrics().density;
        CardDetectionStateView cardDetectionStateView3 = this;
        cardDetectionStateView3.mDisplayDensity = f;
        cardDetectionStateView3.mCardFrame = new CardRectCoordsMapper();
        int n = context.getResources().getColor(R.color.wocr_card_shadow_color);
        this.mCornerPaddingLeft = this.mCornerPaddingTop = f * 1.0f;
        this.mCornerLineWidth = f * 5.0f;
        this.mCornerRadius = f * 8.0f;
        this.mCardGradientDrawable = context.getResources().getDrawable(R.drawable.wocr_frame_rect_gradient);
        this.initCornerDrawables(context);
        cardDetectionStateView2.initLineDrawables(context);
        cardDetectionStateView2.mBackgroundPaint = new Paint();
        cardDetectionStateView2.mBackgroundPaint.setColor(n);
        cardDetectionStateView.mCardTypeface = Fonts.getCardFont(context);
        cardDetectionStateView.mCardNumberPaint = cardDetectionStateView.createCardTextPaint();
        cardDetectionStateView.mCardDatePaint = cardDetectionStateView.createCardTextPaint();
        cardDetectionStateView.mCardHolderPaint = cardDetectionStateView.createCardTextPaint();
        if (cardDetectionStateView.isInEditMode()) {
            CardDetectionStateView cardDetectionStateView4 = this;
            cardDetectionStateView4.mDetectionState = 15;
            cardDetectionStateView4.mRecognitionResultCardNumber = CardUtils.prettyPrintCardNumber("1234567890123456");
            cardDetectionStateView4.mRecognitionResultDate = "05/18";
            cardDetectionStateView4.mRecognitionResultHolder = "CARDHOLDER NAME";
        }
    }

    private Paint createCardTextPaint() {
        Paint paint;
        Paint paint2;
        Paint paint3 = paint2 = paint;
        paint2(193);
        paint3.setTypeface(this.mCardTypeface);
        paint3.setColor(-1);
        paint3.setShadowLayer(6.0f, 3.0f, 3.0f, -16777216);
        paint.setTextSize(this.mDisplayDensity * 12.0f);
        return paint;
    }

    private void initCornerDrawables(Context context) {
        Matrix matrix;
        CardDetectionStateView cardDetectionStateView = cardDetectionStateView4;
        cardDetectionStateView.mCornerTopLeftDrawable = (BitmapDrawable)context.getResources().getDrawable(R.drawable.wocr_card_frame_rect_corner_top_left);
        cardDetectionStateView.setPrimaryColorOnBitmap(cardDetectionStateView.mCornerTopLeftDrawable, context);
        Matrix matrix2 = matrix;
        CardDetectionStateView cardDetectionStateView2 = cardDetectionStateView4;
        CardDetectionStateView cardDetectionStateView3 = cardDetectionStateView4;
        matrix2();
        CardDetectionStateView cardDetectionStateView4 = cardDetectionStateView4.mCornerTopLeftDrawable.getBitmap();
        matrix2.setRotate(90.0f);
        CardDetectionStateView cardDetectionStateView5 = cardDetectionStateView4;
        int n = cardDetectionStateView5.getWidth();
        int n2 = cardDetectionStateView5.getHeight();
        cardDetectionStateView3.mCornerTopRightDrawable = new BitmapDrawable(context.getResources(), Bitmap.createBitmap((Bitmap)cardDetectionStateView5, (int)0, (int)0, (int)n, (int)n2, (Matrix)matrix2, (boolean)true));
        cardDetectionStateView3.setPrimaryColorOnBitmap(cardDetectionStateView3.mCornerTopRightDrawable, context);
        matrix2.setRotate(180.0f);
        CardDetectionStateView cardDetectionStateView6 = cardDetectionStateView4;
        n = cardDetectionStateView6.getWidth();
        n2 = cardDetectionStateView6.getHeight();
        cardDetectionStateView2.mCornerBottomRightDrawable = new BitmapDrawable(context.getResources(), Bitmap.createBitmap((Bitmap)cardDetectionStateView6, (int)0, (int)0, (int)n, (int)n2, (Matrix)matrix2, (boolean)true));
        cardDetectionStateView2.setPrimaryColorOnBitmap(cardDetectionStateView2.mCornerBottomRightDrawable, context);
        matrix.setRotate(270.0f);
        CardDetectionStateView cardDetectionStateView7 = cardDetectionStateView4;
        int n3 = cardDetectionStateView7.getWidth();
        n = cardDetectionStateView7.getHeight();
        cardDetectionStateView.mCornerBottomLeftDrawable = new BitmapDrawable(context.getResources(), Bitmap.createBitmap((Bitmap)cardDetectionStateView7, (int)0, (int)0, (int)n3, (int)n, (Matrix)matrix2, (boolean)true));
        cardDetectionStateView.setPrimaryColorOnBitmap(cardDetectionStateView.mCornerBottomLeftDrawable, context);
    }

    private void setPrimaryColorOnBitmap(BitmapDrawable bitmapDrawable, Context context) {
        if (Build.VERSION.SDK_INT >= 21) {
            TypedValue typedValue;
            CardDetectionStateView cardDetectionStateView = typedValue;
            cardDetectionStateView();
            context.getTheme().resolveAttribute(R.attr.PaymentSDK_PrimaryColor, (TypedValue)cardDetectionStateView, true);
            bitmapDrawable.setTint(typedValue.data);
        }
    }

    private void initLineDrawables(Context context) {
        Matrix matrix;
        CardDetectionStateView cardDetectionStateView = cardDetectionStateView5;
        cardDetectionStateView.mLineTopDrawable = (BitmapDrawable)context.getResources().getDrawable(R.drawable.wocr_card_frame_rect_line_top);
        Matrix matrix2 = matrix;
        CardDetectionStateView cardDetectionStateView2 = cardDetectionStateView5;
        CardDetectionStateView cardDetectionStateView3 = cardDetectionStateView5;
        CardDetectionStateView cardDetectionStateView4 = cardDetectionStateView5;
        matrix2();
        CardDetectionStateView cardDetectionStateView5 = cardDetectionStateView4.mLineTopDrawable.getBitmap();
        cardDetectionStateView4.setPrimaryColorOnBitmap(cardDetectionStateView4.mLineTopDrawable, context);
        matrix2.setRotate(90.0f);
        CardDetectionStateView cardDetectionStateView6 = cardDetectionStateView5;
        int n = cardDetectionStateView6.getWidth();
        int n2 = cardDetectionStateView6.getHeight();
        cardDetectionStateView3.mLineRightDrawable = new BitmapDrawable(context.getResources(), Bitmap.createBitmap((Bitmap)cardDetectionStateView6, (int)0, (int)0, (int)n, (int)n2, (Matrix)matrix2, (boolean)true));
        cardDetectionStateView3.setPrimaryColorOnBitmap(cardDetectionStateView3.mLineRightDrawable, context);
        matrix2.setRotate(180.0f);
        CardDetectionStateView cardDetectionStateView7 = cardDetectionStateView5;
        n = cardDetectionStateView7.getWidth();
        n2 = cardDetectionStateView7.getHeight();
        cardDetectionStateView2.mLineBottomDrawable = new BitmapDrawable(context.getResources(), Bitmap.createBitmap((Bitmap)cardDetectionStateView7, (int)0, (int)0, (int)n, (int)n2, (Matrix)matrix2, (boolean)true));
        cardDetectionStateView2.setPrimaryColorOnBitmap(cardDetectionStateView2.mLineBottomDrawable, context);
        matrix.setRotate(270.0f);
        CardDetectionStateView cardDetectionStateView8 = cardDetectionStateView5;
        int n3 = cardDetectionStateView8.getWidth();
        n = cardDetectionStateView8.getHeight();
        cardDetectionStateView.mLineLeftDrawable = new BitmapDrawable(context.getResources(), Bitmap.createBitmap((Bitmap)cardDetectionStateView8, (int)0, (int)0, (int)n3, (int)n, (Matrix)matrix2, (boolean)true));
        cardDetectionStateView.setPrimaryColorOnBitmap(cardDetectionStateView.mLineLeftDrawable, context);
    }

    private void drawBackground(Canvas canvas) {
        Canvas canvas2 = canvas;
        Canvas canvas3 = canvas;
        CardDetectionStateView cardDetectionStateView = this;
        Canvas canvas4 = canvas;
        CardDetectionStateView cardDetectionStateView2 = this;
        canvas = cardDetectionStateView2.mCardFrame.getCardRect();
        float f = this.getWidth();
        float f2 = canvas.top;
        Paint paint = cardDetectionStateView2.mBackgroundPaint;
        canvas4.drawRect(0.0f, 0.0f, f, f2, paint);
        f = canvas.bottom;
        f2 = cardDetectionStateView.getWidth();
        float f3 = cardDetectionStateView.getHeight();
        Paint paint2 = cardDetectionStateView.mBackgroundPaint;
        canvas3.drawRect(0.0f, f, f2, f3, paint2);
        Canvas canvas5 = canvas;
        f = canvas5.top;
        f2 = canvas5.left;
        f3 = canvas5.bottom;
        paint2 = this.mBackgroundPaint;
        canvas2.drawRect(0.0f, f, f2, f3, paint2);
        canvas2.drawRect((float)canvas.right, (float)canvas.top, (float)this.getWidth(), (float)canvas.bottom, this.mBackgroundPaint);
    }

    private void drawCorners(Canvas canvas) {
        int n = this.mDetectionState;
        CardDetectionStateView cardDetectionStateView = this;
        cardDetectionStateView.mCardGradientDrawable.draw(canvas);
        cardDetectionStateView.mCornerTopLeftDrawable.draw(canvas);
        cardDetectionStateView.mCornerTopRightDrawable.draw(canvas);
        cardDetectionStateView.mCornerBottomLeftDrawable.draw(canvas);
        cardDetectionStateView.mCornerBottomRightDrawable.draw(canvas);
        if ((n & 1) != 0) {
            this.mLineTopDrawable.draw(canvas);
        }
        if ((n & 4) != 0) {
            this.mLineLeftDrawable.draw(canvas);
        }
        if ((n & 8) != 0) {
            this.mLineRightDrawable.draw(canvas);
        }
        if ((n & 2) != 0) {
            this.mLineBottomDrawable.draw(canvas);
        }
    }

    private void drawRecognitionResult(Canvas canvas) {
        CardDetectionStateView cardDetectionStateView = this;
        String string = cardDetectionStateView.mRecognitionResultDate;
        String string2 = cardDetectionStateView.mRecognitionResultCardNumber;
        String string3 = cardDetectionStateView.mRecognitionResultHolder;
        if (!TextUtils.isEmpty((CharSequence)string2)) {
            canvas.drawText(string2, this.mCardFrame.getCardNumberPos().x, this.mCardFrame.getCardNumberPos().y, this.mCardNumberPaint);
        }
        if (!TextUtils.isEmpty((CharSequence)string)) {
            canvas.drawText(string, this.mCardFrame.getCardDatePos().x, this.mCardFrame.getCardDatePos().y, this.mCardDatePaint);
        }
        if (!TextUtils.isEmpty((CharSequence)string3)) {
            canvas.drawText(string3, this.mCardFrame.getCardHolderPos().x, this.mCardFrame.getCardHolderPos().y, this.mCardHolderPaint);
        }
    }

    private void refreshCardRectCoords() {
        CardDetectionStateView cardDetectionStateView = this;
        cardDetectionStateView.refreshCardRectInvalidation();
        cardDetectionStateView.refreshDrawableBounds();
        cardDetectionStateView.refreshTextSize();
    }

    private void refreshCardRectInvalidation() {
        CardDetectionStateView cardDetectionStateView = this;
        Rect rect = cardDetectionStateView.mCardFrame.getCardRect();
        int n = (int)(cardDetectionStateView.mCornerPaddingLeft + 0.5f) + (int)(this.mCornerLineWidth / 2.0f + 0.5f);
        Rect rect2 = cardDetectionStateView.mCardRectInvalidation;
        rect2.left = rect.left - n;
        rect2.top = rect.top - n;
        rect2.right = rect.right + n;
        cardDetectionStateView.mCardRectInvalidation.bottom = rect.bottom + n;
    }

    private void refreshDrawableBounds() {
        CardDetectionStateView cardDetectionStateView = this;
        Rect rect = cardDetectionStateView.mCardFrame.getCardRect();
        CardDetectionStateView cardDetectionStateView2 = this;
        cardDetectionStateView2.mCardGradientDrawable.setBounds(rect);
        int n = cardDetectionStateView2.mCornerTopLeftDrawable.getIntrinsicWidth();
        int n2 = cardDetectionStateView2.mCornerTopLeftDrawable.getIntrinsicHeight();
        int n3 = (int)(cardDetectionStateView2.mCornerLineWidth / 2.0f + 0.5f);
        float f = n3;
        int n4 = Math.round((float)rect.left - this.mCornerPaddingLeft - f);
        int n5 = Math.round((float)(rect.right - n) + this.mCornerPaddingLeft + f);
        int n6 = Math.round((float)rect.top - this.mCornerPaddingTop - f);
        int n7 = Math.round((float)(rect.bottom - n2) + this.mCornerPaddingTop + f);
        int n8 = n4 + n;
        cardDetectionStateView.mCornerTopLeftDrawable.setBounds(n4, n6, n8, n6 + n2);
        int n9 = n5 + n;
        cardDetectionStateView.mCornerTopRightDrawable.setBounds(n5, n6, n9, n6 + n);
        n = n7 + n2;
        cardDetectionStateView.mCornerBottomLeftDrawable.setBounds(n4, n7, n8, n);
        cardDetectionStateView.mCornerBottomRightDrawable.setBounds(n5, n7, n9, n);
        n7 = (int)cardDetectionStateView.mCornerRadius;
        BitmapDrawable bitmapDrawable = cardDetectionStateView.mLineTopDrawable;
        n8 = n4 + n7;
        n5 = n9 - n7;
        bitmapDrawable.setBounds(n8, n6, n5, n6 + bitmapDrawable.getIntrinsicHeight());
        bitmapDrawable = cardDetectionStateView.mLineLeftDrawable;
        n6 += n7;
        n7 = n - n7;
        bitmapDrawable.setBounds(n4, n6, n4 + bitmapDrawable.getIntrinsicWidth(), n7);
        BitmapDrawable bitmapDrawable2 = cardDetectionStateView.mLineRightDrawable;
        bitmapDrawable2.setBounds(n9 - bitmapDrawable2.getIntrinsicWidth(), n6, n9, n7);
        BitmapDrawable bitmapDrawable3 = cardDetectionStateView.mLineBottomDrawable;
        bitmapDrawable3.setBounds(n8, n - bitmapDrawable3.getIntrinsicHeight(), n5, n);
    }

    private void refreshTextSize() {
        CardDetectionStateView cardDetectionStateView = this;
        cardDetectionStateView.mCardNumberPaint.setTextSize(this.mCardFrame.getCardNumberFontSize());
        cardDetectionStateView.mCardDatePaint.setTextSize(this.mCardFrame.getCardDateFontSize());
        cardDetectionStateView.mCardHolderPaint.setTextSize(this.mCardFrame.getCardHolderFontSize());
    }

    protected void onSizeChanged(int n, int n2, int n3, int n4) {
        CardDetectionStateView cardDetectionStateView = this;
        super.onSizeChanged(n, n2, n3, n4);
        if (cardDetectionStateView.mCardFrame.setViewSize(n, n2)) {
            this.refreshCardRectCoords();
        }
    }

    protected void onDraw(Canvas canvas) {
        if (this.mCardGradientDrawable.getBounds().width() == 0) {
            return;
        }
        this.drawBackground(canvas);
        this.drawCorners(canvas);
        this.drawRecognitionResult(canvas);
    }

    public synchronized void setDetectionState(int n) {
        if (cardDetectionStateView2.mDetectionState != n) {
            CardDetectionStateView cardDetectionStateView = cardDetectionStateView2;
            cardDetectionStateView.mDetectionState = n;
            CardDetectionStateView cardDetectionStateView2 = cardDetectionStateView.mCardRectInvalidation;
            cardDetectionStateView.postInvalidate(((Rect)cardDetectionStateView2).left, ((Rect)cardDetectionStateView2).top, ((Rect)cardDetectionStateView2).right, ((Rect)cardDetectionStateView2).bottom);
        }
    }

    public synchronized void setRecognitionResult(RecognitionResult recognitionResult) {
        cardDetectionStateView2.mRecognitionResultCardNumber = !TextUtils.isEmpty((CharSequence)recognitionResult.getNumber()) ? CardUtils.prettyPrintCardNumber(recognitionResult.getNumber()) : null;
        cardDetectionStateView2.mRecognitionResultDate = !TextUtils.isEmpty((CharSequence)recognitionResult.getDate()) ? recognitionResult.getDate().substring(0, 2) + '/' + recognitionResult.getDate().substring(2) : null;
        CardDetectionStateView cardDetectionStateView = cardDetectionStateView2;
        cardDetectionStateView.mRecognitionResultHolder = recognitionResult.getName();
        CardDetectionStateView cardDetectionStateView2 = cardDetectionStateView.mCardRectInvalidation;
        cardDetectionStateView.postInvalidate(((Rect)cardDetectionStateView2).left, ((Rect)cardDetectionStateView2).top, ((Rect)cardDetectionStateView2).right, ((Rect)cardDetectionStateView2).bottom);
    }

    void setCameraParameters(int n, int n2, int n3, Rect rect) {
        if (this.mCardFrame.setCameraParameters(n, n2, n3, rect)) {
            CardDetectionStateView cardDetectionStateView = this;
            cardDetectionStateView.refreshCardRectCoords();
            cardDetectionStateView.invalidate();
        }
    }
}

