/*
 * Decompiled with CFR 0.152.
 */
package cards.pay.paycardsrecognizer.sdk.camera.widget;

import android.graphics.PointF;
import android.graphics.Rect;
import cards.pay.paycardsrecognizer.sdk.camera.OrientationHelper;

class CardRectCoordsMapper {
    private static final int[] DEFAULT_CAMERA_RESOLUTION = new int[]{1280, 720};
    private static final Rect DEFAULT_CAMERA_RECT = new Rect(432, 30, 848, 690);
    private static final Rect DEFAULT_CAMERA_RECT_LANDSCAPE = new Rect(310, 152, 970, 568);
    private static final PointF DEFAULT_CARD_NUMBER_POS = new PointF(60.0f, 268.0f);
    private static final PointF DEFAULT_CARD_DATE_POS = new PointF(289.0f, 321.0f);
    private static final PointF DEFAULT_CARD_HOLDER_POS = new PointF(33.0f, 364.0f);
    private final Rect mCardCameraRectRaw;
    private final int[] mCameraPreviewSize;
    private int mCameraRotation;
    private final Rect mCardRect;
    private final Rect mCardCameraRect;
    private final PointF mCardNumberPos;
    private final PointF mCardDatePos;
    private final PointF mCardHolderPos;
    private int mViewWidth;
    private int mViewHeight;
    private int mTranslateX;
    private int mTranslateY;
    private float mScale;
    private boolean mCameraRectInitialized;

    CardRectCoordsMapper() {
        CardRectCoordsMapper cardRectCoordsMapper = object;
        cardRectCoordsMapper.mCardCameraRectRaw = new Rect();
        int[] nArray = new int[2];
        Object object = nArray;
        object[0] = DEFAULT_CAMERA_RESOLUTION[0];
        nArray[1] = DEFAULT_CAMERA_RESOLUTION[1];
        cardRectCoordsMapper.mCameraPreviewSize = nArray;
        cardRectCoordsMapper.mCameraRotation = 90;
        cardRectCoordsMapper.mCardRect = new Rect();
        cardRectCoordsMapper.mCardCameraRect = new Rect();
        cardRectCoordsMapper.mCardNumberPos = new PointF();
        cardRectCoordsMapper.mCardDatePos = new PointF();
        cardRectCoordsMapper.mCardHolderPos = new PointF();
        cardRectCoordsMapper.mViewWidth = 1280;
        cardRectCoordsMapper.mViewHeight = 720;
        cardRectCoordsMapper.mTranslateX = 0;
        cardRectCoordsMapper.mTranslateY = 0;
        cardRectCoordsMapper.mScale = 1.0f;
        cardRectCoordsMapper.mCardCameraRectRaw.set(DEFAULT_CAMERA_RECT);
    }

    private void refreshCameraDefaults() {
        Object object;
        if (((CardRectCoordsMapper)object).mViewHeight > ((CardRectCoordsMapper)object).mViewWidth) {
            CardRectCoordsMapper cardRectCoordsMapper = object;
            cardRectCoordsMapper.mCameraRotation = 90;
            object = cardRectCoordsMapper.mCameraPreviewSize;
            object[0] = DEFAULT_CAMERA_RESOLUTION[0];
            cardRectCoordsMapper.mCameraPreviewSize[1] = DEFAULT_CAMERA_RESOLUTION[1];
            cardRectCoordsMapper.mCardCameraRectRaw.set(DEFAULT_CAMERA_RECT);
        } else {
            CardRectCoordsMapper cardRectCoordsMapper = object;
            cardRectCoordsMapper.mCameraRotation = 0;
            object = cardRectCoordsMapper.mCameraPreviewSize;
            object[0] = DEFAULT_CAMERA_RESOLUTION[0];
            cardRectCoordsMapper.mCameraPreviewSize[1] = DEFAULT_CAMERA_RESOLUTION[1];
            cardRectCoordsMapper.mCardCameraRectRaw.set(DEFAULT_CAMERA_RECT_LANDSCAPE);
        }
    }

    private void sync() {
        CardRectCoordsMapper cardRectCoordsMapper = this;
        cardRectCoordsMapper.refreshTransform();
        cardRectCoordsMapper.refreshCardRect();
        cardRectCoordsMapper.refreshCardTextPositions();
    }

    private void refreshTransform() {
        float f;
        int n;
        int n2;
        int n3;
        float f2;
        CardRectCoordsMapper cardRectCoordsMapper = this;
        int n4 = 0;
        int n5 = 0;
        float f3 = cardRectCoordsMapper.getCameraHeightRotated();
        float f4 = cardRectCoordsMapper.getCameraWidthRotated();
        int n6 = this.mViewHeight;
        int n7 = this.mViewWidth;
        if (f2 * (float)n3 > f3 * (float)n2) {
            float f5 = (float)n6 / f3;
            n = (int)(((float)n7 - f4 * f5) / 2.0f);
            n5 = n4;
            f = f5;
        } else {
            f = (float)n7 / f4;
            n = (int)(((float)n6 - f3 * f) / 2.0f);
            int n8 = n5;
            n5 = n;
            n = n8;
        }
        this.mScale = f;
        this.mTranslateX = n;
        this.mTranslateY = n5;
        int[] nArray = this.mCameraPreviewSize;
        OrientationHelper.rotateRect(this.mCardCameraRectRaw, this.mCameraPreviewSize[0], nArray[1], this.mCameraRotation, this.mCardCameraRect);
    }

    private void refreshCardRect() {
        Rect rect = this.mCardRect;
        float f = this.mScale;
        Rect rect2 = rect;
        Rect rect3 = rect;
        Rect rect4 = rect;
        rect = this.mCardCameraRect;
        int n = this.mTranslateX;
        rect4.left = (int)(f * (float)rect.left + 0.5f) + n;
        int n2 = this.mTranslateY;
        rect3.top = (int)(f * (float)rect.top + 0.5f) + n2;
        rect2.right = (int)(f * (float)rect.right + 0.5f) + n;
        this.mCardRect.bottom = (int)(f * (float)rect.bottom + 0.5f) + n2;
    }

    private void refreshCardTextPositions() {
        CardRectCoordsMapper cardRectCoordsMapper = this;
        cardRectCoordsMapper.mapToViewCoordinates(DEFAULT_CARD_NUMBER_POS, this.mCardNumberPos);
        cardRectCoordsMapper.mapToViewCoordinates(DEFAULT_CARD_DATE_POS, this.mCardDatePos);
        cardRectCoordsMapper.mapToViewCoordinates(DEFAULT_CARD_HOLDER_POS, this.mCardHolderPos);
    }

    private int getCameraWidthRotated() {
        int n = this.mCameraRotation;
        return n != 0 && n != 180 ? this.mCameraPreviewSize[1] : this.mCameraPreviewSize[0];
    }

    private int getCameraHeightRotated() {
        int n = this.mCameraRotation;
        return n != 0 && n != 180 ? this.mCameraPreviewSize[0] : this.mCameraPreviewSize[1];
    }

    public Rect getCardRect() {
        return this.mCardRect;
    }

    public PointF getCardNumberPos() {
        return this.mCardNumberPos;
    }

    public float getCardNumberFontSize() {
        return this.mScale * 40.0f;
    }

    public PointF getCardDatePos() {
        return this.mCardDatePos;
    }

    public float getCardDateFontSize() {
        return this.mScale * 27.0f;
    }

    public PointF getCardHolderPos() {
        return this.mCardHolderPos;
    }

    public float getCardHolderFontSize() {
        return this.mScale * 27.0f;
    }

    public boolean setViewSize(int n, int n2) {
        if (n != 0 && n2 != 0 && this.mViewWidth != n && this.mViewHeight != n2) {
            this.mViewWidth = n;
            this.mViewHeight = n2;
            if (!this.mCameraRectInitialized) {
                this.refreshCameraDefaults();
            }
            this.sync();
            return true;
        }
        return false;
    }

    public boolean setCameraParameters(int n, int n2, int n3, Rect rect) {
        int[] nArray = this.mCameraPreviewSize;
        boolean bl = n == this.mCameraPreviewSize[0] && n2 == nArray[1];
        boolean bl2 = this.mCameraRotation == n3;
        boolean bl3 = bl;
        bl = this.mCardCameraRectRaw.equals((Object)rect);
        if (bl3 && bl2 && bl && this.mCameraRectInitialized) {
            return false;
        }
        CardRectCoordsMapper cardRectCoordsMapper = this;
        this.mCameraPreviewSize[0] = n;
        this.mCameraPreviewSize[1] = n2;
        cardRectCoordsMapper.mCameraRotation = n3;
        cardRectCoordsMapper.mCardCameraRectRaw.set(rect);
        cardRectCoordsMapper.mCameraRectInitialized = true;
        cardRectCoordsMapper.sync();
        return true;
    }

    public void mapToViewCoordinates(PointF pointF, PointF pointF2) {
        float f = cardRectCoordsMapper.mScale;
        CardRectCoordsMapper cardRectCoordsMapper = cardRectCoordsMapper.mCardRect;
        pointF2.x = f * pointF.x + (float)((Rect)cardRectCoordsMapper).left;
        pointF2.y = f * pointF.y + (float)((Rect)cardRectCoordsMapper).top;
    }
}

