/*
 * Decompiled with CFR 0.152.
 */
package cards.pay.paycardsrecognizer.sdk.ui;

import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.os.Parcelable;
import android.support.annotation.Nullable;
import android.support.annotation.RestrictTo;
import android.support.v4.app.Fragment;
import android.support.v4.view.ViewCompat;
import android.support.v7.app.AppCompatActivity;
import android.util.Log;
import android.view.View;
import cards.pay.paycardsrecognizer.sdk.Card;
import cards.pay.paycardsrecognizer.sdk.camera.RecognitionAvailabilityChecker;
import cards.pay.paycardsrecognizer.sdk.camera.RecognitionCoreUtils;
import cards.pay.paycardsrecognizer.sdk.camera.RecognitionUnavailableException;
import cards.pay.paycardsrecognizer.sdk.ui.InitLibraryFragment;
import cards.pay.paycardsrecognizer.sdk.ui.ScanCardFragment;
import cards.pay.paycardsrecognizer.sdk.ui.ScanCardRequest;

public class ScanCardActivity
extends AppCompatActivity
implements ScanCardFragment.InteractionListener,
InitLibraryFragment.InteractionListener {
    private void showInitLibrary() {
        InitLibraryFragment initLibraryFragment;
        ScanCardActivity scanCardActivity = object;
        Object object = initLibraryFragment;
        initLibraryFragment = new InitLibraryFragment();
        scanCardActivity.getSupportFragmentManager().beginTransaction().replace(0x1020002, (Fragment)object, "InitLibraryFragment").setCustomAnimations(0, 0).commitNow();
    }

    private void showScanCard() {
        ScanCardFragment scanCardFragment;
        ScanCardFragment scanCardFragment2;
        ScanCardActivity scanCardActivity = this;
        ScanCardFragment scanCardFragment3 = scanCardFragment2 = scanCardFragment;
        scanCardFragment3();
        Bundle bundle = new Bundle(1);
        bundle.putParcelable("cards.pay.paycardsrecognizer.sdk.ui.ScanCardActivity.SCAN_CARD_REQUEST", (Parcelable)this.getScanRequest());
        scanCardFragment3.setArguments(bundle);
        scanCardFragment2.setHeaderParams(this.getIntent().getStringExtra("orderTitle"), this.getIntent().getStringExtra("shopName"), this.getIntent().getStringExtra("amount"));
        scanCardFragment.setThemeResId(this.getIntent().getIntExtra("themeResId", -1));
        scanCardActivity.getSupportFragmentManager().beginTransaction().replace(0x1020002, (Fragment)scanCardFragment2, "ScanCardFragment").setCustomAnimations(0, 0).commitNow();
        ViewCompat.requestApplyInsets((View)scanCardActivity.findViewById(0x1020002));
    }

    private ScanCardRequest getScanRequest() {
        if ((object = (ScanCardRequest)object.getIntent().getParcelableExtra("cards.pay.paycardsrecognizer.sdk.ui.ScanCardActivity.SCAN_CARD_REQUEST")) == null) {
            Object object = ScanCardRequest.getDefault();
        }
        return object;
    }

    protected void onCreate(Bundle object) {
        ScanCardActivity scanCardActivity = this;
        super.onCreate((Bundle)object);
        scanCardActivity.getWindow().setFlags(8192, 8192);
        scanCardActivity.getDelegate().onPostCreate(null);
        if (object == null) {
            object = RecognitionAvailabilityChecker.doCheck((Context)this);
            if (((RecognitionAvailabilityChecker.Result)object).isFailed() && !((RecognitionAvailabilityChecker.Result)object).isFailedOnCameraPermission()) {
                this.onScanCardFailed(new RecognitionUnavailableException(((RecognitionAvailabilityChecker.Result)object).getMessage()));
            } else if (!RecognitionCoreUtils.isRecognitionCoreDeployRequired((Context)this) && !((RecognitionAvailabilityChecker.Result)object).isFailedOnCameraPermission()) {
                this.showScanCard();
            } else {
                this.showInitLibrary();
            }
        }
    }

    @Override
    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public void onScanCardFailed(Exception exception) {
        RuntimeException runtimeException;
        ScanCardActivity scanCardActivity = runtimeException2;
        RuntimeException runtimeException2 = runtimeException;
        runtimeException = new RuntimeException("onScanCardFinishedWithError()", exception);
        Log.e((String)"ScanCardActivity", (String)"Scan card failed", (Throwable)runtimeException2);
        scanCardActivity.setResult(1);
        scanCardActivity.finish();
    }

    @Override
    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public void onScanCardFinished(Card card, @Nullable byte[] byArray) {
        Intent intent;
        Intent intent2 = intent;
        new Intent().putExtra("RESULT_PAYCARDS_CARD", (Parcelable)card);
        if (byArray != null) {
            intent2.putExtra("RESULT_CARD_IMAGE", byArray);
        }
        ScanCardActivity scanCardActivity = this;
        scanCardActivity.setResult(-1, intent2);
        scanCardActivity.finish();
    }

    @Override
    public void onInitLibraryFailed(Throwable throwable) {
        RuntimeException runtimeException;
        ScanCardActivity scanCardActivity = runtimeException2;
        RuntimeException runtimeException2 = runtimeException;
        runtimeException = new RuntimeException("onInitLibraryFailed()", throwable);
        Log.e((String)"ScanCardActivity", (String)"Init library failed", (Throwable)runtimeException2);
        scanCardActivity.setResult(1);
        scanCardActivity.finish();
    }

    @Override
    public void onScanCardCanceled(int n) {
        Intent intent;
        ScanCardActivity scanCardActivity = scanCardActivity2;
        ScanCardActivity scanCardActivity2 = intent;
        new Intent().putExtra("RESULT_CANCEL_REASON", n);
        scanCardActivity.setResult(0, (Intent)scanCardActivity2);
        scanCardActivity.finish();
    }

    @Override
    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public void onInitLibraryComplete() {
        if (this.isFinishing()) {
            return;
        }
        this.showScanCard();
    }
}

