/*
 * Decompiled with CFR 0.152.
 */
package cards.pay.paycardsrecognizer.sdk.ui;

import android.content.Context;
import android.graphics.Bitmap;
import android.hardware.Camera;
import android.media.SoundPool;
import android.os.Bundle;
import android.support.annotation.Nullable;
import android.support.annotation.RestrictTo;
import android.support.v4.app.Fragment;
import android.text.TextUtils;
import android.view.ContextThemeWrapper;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.Animation;
import android.widget.ImageView;
import android.widget.TextView;
import cards.pay.paycardsrecognizer.sdk.Card;
import cards.pay.paycardsrecognizer.sdk.R;
import cards.pay.paycardsrecognizer.sdk.camera.ScanManager;
import cards.pay.paycardsrecognizer.sdk.camera.widget.CameraPreviewLayout;
import cards.pay.paycardsrecognizer.sdk.ndk.RecognitionResult;
import cards.pay.paycardsrecognizer.sdk.ui.ScanCardRequest;
import cards.pay.paycardsrecognizer.sdk.ui.views.ProgressBarIndeterminate;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;

@RestrictTo(value={RestrictTo.Scope.LIBRARY})
public class ScanCardFragment
extends Fragment {
    private CameraPreviewLayout mCameraPreviewLayout;
    private ProgressBarIndeterminate mProgressBar;
    private ViewGroup mMainContent;
    @Nullable
    private View mFlashButton;
    @Nullable
    private ScanManager mScanManager;
    private SoundPool mSoundPool;
    private int mCapturedSoundId = -1;
    private InteractionListener mListener;
    private ScanCardRequest mRequest;
    private String orderTitle = "";
    private String shopName = "";
    private String amount = "";
    private int themeResId = -1;

    private void innitSoundPool() {
        if (this.mRequest.isSoundEnabled()) {
            this.mSoundPool = new SoundPool(1, 1, 0);
            this.mCapturedSoundId = this.mSoundPool.load((Context)this.getActivity(), R.raw.wocr_capture_card, 0);
        }
    }

    private void initView(View view) {
        view = this.mFlashButton;
        if (view != null) {
            view.setOnClickListener(new View.OnClickListener(){

                public void onClick(View view) {
                    if (ScanCardFragment.this.mScanManager != null) {
                        ScanCardFragment.this.mScanManager.toggleFlash();
                    }
                }
            });
        }
    }

    private void showMainContent() {
        ScanCardFragment scanCardFragment = this;
        scanCardFragment.mMainContent.setVisibility(0);
        scanCardFragment.mCameraPreviewLayout.setVisibility(0);
    }

    private void hideMainContent() {
        ScanCardFragment scanCardFragment = this;
        scanCardFragment.mMainContent.setVisibility(4);
        scanCardFragment.mCameraPreviewLayout.setVisibility(4);
    }

    private void finishWithError(Exception exception) {
        InteractionListener interactionListener = ((ScanCardFragment)((Object)interactionListener)).mListener;
        if (interactionListener != null) {
            interactionListener.onScanCardFailed(exception);
        }
    }

    private void finishWithResult(Card card, @Nullable byte[] byArray) {
        InteractionListener interactionListener = ((ScanCardFragment)((Object)interactionListener)).mListener;
        if (interactionListener != null) {
            interactionListener.onScanCardFinished(card, byArray);
        }
    }

    private boolean isTablet() {
        return this.getResources().getBoolean(R.bool.wocr_is_tablet);
    }

    private void playCaptureSound() {
        int n = this.mCapturedSoundId;
        if (n >= 0) {
            this.mSoundPool.play(n, 1.0f, 1.0f, 0, 0, 1.0f);
        }
    }

    public void setHeaderParams(String string, String string2, String string3) {
        this.orderTitle = string;
        this.shopName = string2;
        this.amount = string3;
    }

    public void setThemeResId(int n) {
        this.themeResId = n;
    }

    public void onAttach(Context context) {
        ScanCardFragment scanCardFragment = this;
        super.onAttach(context);
        try {
            scanCardFragment.mListener = (InteractionListener)scanCardFragment.getActivity();
            return;
        }
        catch (ClassCastException classCastException) {
            throw new RuntimeException("Parent must implement " + InteractionListener.class.getSimpleName());
        }
    }

    public void onCreate(Bundle bundle) {
        ScanCardFragment scanCardFragment = this;
        super.onCreate(bundle);
        scanCardFragment.mRequest = null;
        if (scanCardFragment.getArguments() != null) {
            this.mRequest = (ScanCardRequest)this.getArguments().getParcelable("cards.pay.paycardsrecognizer.sdk.ui.ScanCardActivity.SCAN_CARD_REQUEST");
        }
        if (this.mRequest == null) {
            this.mRequest = ScanCardRequest.getDefault();
        }
        if (bundle != null) {
            if (bundle.getString("orderTitle") != null) {
                this.orderTitle = bundle.getString("orderTitle");
            }
            if (bundle.getString("shopName") != null) {
                this.shopName = bundle.getString("shopName");
            }
            if (bundle.getString("amount") != null) {
                this.amount = bundle.getString("amount");
            }
            this.themeResId = bundle.getInt("themeResId");
        }
    }

    public Animation onCreateAnimation(int n, boolean bl, int n2) {
        Animation animation = new Animation(this){};
        animation.setDuration(0L);
        return animation;
    }

    @Nullable
    public View onCreateView(LayoutInflater layoutInflater, @Nullable ViewGroup viewGroup, @Nullable Bundle bundle) {
        ScanCardFragment scanCardFragment = this;
        super.onCreateView(layoutInflater, viewGroup, bundle);
        layoutInflater = scanCardFragment.themeResId != -1 ? layoutInflater.cloneInContext((Context)new ContextThemeWrapper((Context)this.getActivity(), this.themeResId)).inflate(R.layout.wocr_fragment_scan_card, viewGroup, false) : layoutInflater.inflate(R.layout.wocr_fragment_scan_card, viewGroup, false);
        this.mProgressBar = (ProgressBarIndeterminate)layoutInflater.findViewById(R.id.wocr_progress_bar);
        this.mCameraPreviewLayout = (CameraPreviewLayout)layoutInflater.findViewById(R.id.wocr_card_recognition_view);
        this.mMainContent = (ViewGroup)layoutInflater.findViewById(R.id.wocr_main_content);
        this.mFlashButton = layoutInflater.findViewById(R.id.wocr_iv_flash_id);
        if (!this.isTablet()) {
            LayoutInflater layoutInflater2 = layoutInflater;
            ((ImageView)layoutInflater2.findViewById(R.id.backButtonImageView)).setOnClickListener(new View.OnClickListener(){

                public void onClick(View view) {
                    if (ScanCardFragment.this.mListener != null) {
                        ScanCardFragment.this.mListener.onScanCardCanceled(1);
                    }
                }
            });
            ((TextView)layoutInflater2.findViewById(R.id.shopNameView)).setText((CharSequence)this.shopName);
            ((TextView)layoutInflater2.findViewById(R.id.orderTextView)).setText((CharSequence)this.orderTitle);
            ((TextView)layoutInflater2.findViewById(R.id.currencyTextView)).setText((CharSequence)this.amount);
        }
        ScanCardFragment scanCardFragment2 = this;
        scanCardFragment2.initView((View)layoutInflater);
        scanCardFragment2.showMainContent();
        scanCardFragment2.mProgressBar.setVisibility(0);
        return layoutInflater;
    }

    public void onActivityCreated(@Nullable Bundle bundle) {
        ScanCardFragment scanCardFragment = this;
        super.onActivityCreated(bundle);
        if (!scanCardFragment.isTablet()) {
            this.getActivity().setRequestedOrientation(1);
        } else {
            this.mCameraPreviewLayout.setBackgroundColor(-16777216);
        }
        int n = 1;
        if (this.mRequest.isScanCardHolderEnabled()) {
            n = 5;
        }
        if (this.mRequest.isScanExpirationDateEnabled()) {
            n |= 2;
        }
        if (this.mRequest.isGrabCardImageEnabled()) {
            n |= 8;
        }
        this.mScanManager = new ScanManager(n, (Context)this.getActivity(), this.mCameraPreviewLayout, new ScanManager.Callbacks(){
            private byte[] mLastCardImage = null;

            @Nullable
            private byte[] compressCardImage(Bitmap bitmap) {
                ByteArrayOutputStream byteArrayOutputStream;
                ByteArrayOutputStream byteArrayOutputStream2 = byteArrayOutputStream;
                byteArrayOutputStream = new ByteArrayOutputStream();
                return bitmap.compress(Bitmap.CompressFormat.JPEG, 80, (OutputStream)byteArrayOutputStream2) ? byteArrayOutputStream2.toByteArray() : null;
            }

            @Override
            public void onCameraOpened(Camera.Parameters parameters) {
                boolean bl = parameters.getSupportedFlashModes() != null && !parameters.getSupportedFlashModes().isEmpty();
                if (ScanCardFragment.this.getView() == null) {
                    return;
                }
                3 v0 = this;
                v0.ScanCardFragment.this.mProgressBar.hideSlow();
                v0.ScanCardFragment.this.mCameraPreviewLayout.setBackgroundDrawable(null);
                if (v0.ScanCardFragment.this.mFlashButton != null) {
                    View view = ScanCardFragment.this.mFlashButton;
                    int n = bl ? 0 : 8;
                    view.setVisibility(n);
                }
                ScanCardFragment.this.innitSoundPool();
            }

            @Override
            public void onOpenCameraError(Exception exception) {
                3 v0 = this;
                v0.ScanCardFragment.this.mProgressBar.hideSlow();
                v0.ScanCardFragment.this.hideMainContent();
                v0.ScanCardFragment.this.finishWithError(exception);
            }

            @Override
            public void onRecognitionComplete(RecognitionResult object) {
                if (((RecognitionResult)object).isFirst()) {
                    if (card2.ScanCardFragment.this.mScanManager != null) {
                        card2.ScanCardFragment.this.mScanManager.freezeCameraPreview();
                    }
                    card2.ScanCardFragment.this.playCaptureSound();
                }
                if (((RecognitionResult)object).isFinal()) {
                    Card card;
                    String string = TextUtils.isEmpty((CharSequence)((RecognitionResult)object).getDate()) ? null : ((RecognitionResult)object).getDate().substring(0, 2) + '/' + ((RecognitionResult)object).getDate().substring(2);
                    3 v0 = card2;
                    Card card2 = card;
                    card = new Card(((RecognitionResult)object).getNumber(), ((RecognitionResult)object).getName(), string);
                    object = v0.mLastCardImage;
                    v0.mLastCardImage = null;
                    v0.ScanCardFragment.this.finishWithResult(card2, (byte[])object);
                }
            }

            @Override
            public void onCardImageReceived(Bitmap bitmap) {
                this.mLastCardImage = this.compressCardImage(bitmap);
            }

            @Override
            public void onFpsReport(String string) {
            }

            @Override
            public void onAutoFocusMoving(boolean bl, String string) {
            }

            @Override
            public void onAutoFocusComplete(boolean bl, String string) {
            }
        });
    }

    public void onStart() {
        super.onStart();
    }

    public void onStop() {
        super.onStop();
    }

    public void onSaveInstanceState(Bundle bundle) {
        Bundle bundle2 = bundle;
        bundle.putString("orderTitle", this.orderTitle);
        bundle.putString("shopName", this.shopName);
        bundle.putString("amount", this.amount);
        bundle2.putInt("themeResId", this.themeResId);
        super.onSaveInstanceState(bundle2);
    }

    public void onDetach() {
        super.onDetach();
    }

    public void onResume() {
        ScanCardFragment scanCardFragment = scanManager;
        super.onResume();
        ScanManager scanManager = scanCardFragment.mScanManager;
        if (scanManager != null) {
            scanManager.onResume();
        }
    }

    public void onPause() {
        ScanCardFragment scanCardFragment = scanManager;
        super.onPause();
        ScanManager scanManager = scanCardFragment.mScanManager;
        if (scanManager != null) {
            scanManager.onPause();
        }
    }

    public void onDestroy() {
        ScanCardFragment scanCardFragment = this;
        super.onDestroy();
        SoundPool soundPool = scanCardFragment.mSoundPool;
        if (soundPool != null) {
            soundPool.release();
            this.mSoundPool = null;
        }
        this.mCapturedSoundId = -1;
    }

    public static interface InteractionListener {
        public void onScanCardCanceled(int var1);

        public void onScanCardFailed(Exception var1);

        public void onScanCardFinished(Card var1, byte[] var2);
    }
}

