/*
 * Decompiled with CFR 0.152.
 */
package com.mcreations.renderer.velocity;

import java.io.File;
import java.io.FileWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;
import org.apache.velocity.runtime.resource.loader.ClasspathResourceLoader;
import org.apache.velocity.runtime.resource.loader.FileResourceLoader;

public class VelocityRenderer {
    private static final Logger LOG = LogManager.getLogger(VelocityRenderer.class);
    public static final String[][] OPTIONS = new String[][]{{"s", "src", "src-path", "Source path for velocity template files"}, {"f", "files", "files-wildcard", "Velocity template file names pattern, by example: *.vm"}, {"d", "dest", "destination-path", "Destination path for rendered velocity template files"}};
    private static final String APPLICATION_NAME = "VelocityRenderer";

    public static void main(String[] args) {
        VelocityRenderer velocityRenderer = new VelocityRenderer();
        String sourcePath = null;
        String destPath = null;
        String filePattern = null;
        DefaultParser parser = new DefaultParser();
        HelpFormatter formatter = new HelpFormatter();
        Options options = new Options();
        for (String[] option : OPTIONS) {
            options.addOption(Option.builder((String)option[0]).argName(option[1]).type(String.class).longOpt(option[2]).hasArg(true).desc(option[3]).build());
        }
        try {
            CommandLine line = parser.parse(options, args);
            for (String[] option : OPTIONS) {
                if (line.hasOption(option[2])) continue;
                formatter.printHelp(APPLICATION_NAME, options);
                System.exit(-1);
            }
            sourcePath = line.getOptionValue("s");
            destPath = line.getOptionValue("d");
            filePattern = line.getOptionValue("f");
        }
        catch (ParseException e) {
            formatter.printHelp(APPLICATION_NAME, options);
        }
        LOG.info((Object)("sourcePath=" + sourcePath));
        LOG.info((Object)("destPath=" + destPath));
        LOG.info((Object)("filePattern=" + filePattern));
        try {
            velocityRenderer.render(sourcePath, destPath, filePattern, null);
        }
        catch (Exception e) {
            LOG.error((Object)"Rendering velocity templats failed: ", (Throwable)e);
            System.exit(-2);
        }
    }

    public void render(String sourcePath, String destPath, String filePattern, Map<String, Object> additionalContextParameters) throws Exception {
        List<Object> foundFiles = new ArrayList();
        String filePatternLocal = filePattern;
        Stream<Path> foundStream = Files.find(Paths.get(sourcePath, new String[0]), Integer.MAX_VALUE, (path, basicFileAttributes) -> path.toFile().getName().matches(filePatternLocal), new FileVisitOption[0]);
        foundFiles = foundStream.sorted().map(f -> f.getFileName().toString()).collect(Collectors.toList());
        VelocityEngine ve = new VelocityEngine();
        ve.setProperty("resource.loader", (Object)"file,classpath");
        ve.setProperty("classpath.resource.loader.class", (Object)ClasspathResourceLoader.class.getName());
        ve.setProperty("class.resource.loader.class", (Object)ClasspathResourceLoader.class.getName());
        ve.setProperty("file.resource.loader.class", (Object)FileResourceLoader.class.getName());
        ve.setProperty("input.encoding", (Object)"UTF-8");
        ve.setProperty("file.resource.loader.path", (Object)Paths.get(sourcePath, new String[0]).toString());
        ve.setProperty("runtime.log.logsystem.log4j.logger", (Object)VelocityRenderer.class.getName());
        ve.init();
        VelocityContext context = new VelocityContext();
        if (additionalContextParameters != null && !additionalContextParameters.isEmpty()) {
            for (String string : additionalContextParameters.keySet()) {
                context.put(string, additionalContextParameters.get(string));
            }
        }
        context.put("envVars", System.getenv());
        for (String string : foundFiles) {
            Template t = ve.getTemplate(string);
            File destFile = Paths.get(destPath, FilenameUtils.getBaseName((String)string)).toFile();
            FileWriter writer = new FileWriter(destFile, false);
            t.merge((Context)context, (Writer)writer);
            writer.flush();
            writer.close();
            LOG.info((Object)("Rendered velocity template file saved here: " + destFile.getAbsolutePath()));
            LOG.info((Object)("\n" + FileUtils.readFileToString((File)destFile, (Charset)StandardCharsets.UTF_8)));
        }
    }
}

