package com.m3.util

/**
 * Useful extractors
 *
 */

object AsInt {
  def unapply(s: String): Option[Int] = try {
    Some(s.toInt)
  } catch {
    case e: NumberFormatException => None
  }
}

object AsLong {
  def unapply(s: String): Option[Long] = try {
    Some(s.toLong)
  } catch {
    case e: NumberFormatException => None
  }
}

object AsShort {
  def unapply(s: String): Option[Short] = {
    try {
      Some(s.toShort)
    } catch {
      case e: NumberFormatException => None
    }
  }
}

object AsFloat {
  def unapply(s: String): Option[Float] = {
    try {
      Some(s.toFloat)
    } catch {
      case e: NumberFormatException => None
    }
  }
}

object AsDouble {
  def unapply(s: String): Option[Double] = {
    try {
      Some(s.toDouble)
    } catch {
      case e: NumberFormatException => None
    }
  }
}
