package com.m3.util

/**
 * An emulation the Ruby's Object#tap.
 *
 * see also  http://yuroyoro.hatenablog.com/entry/20110323/1300854858
 */
class Tapper[A](obj: A) {

  def tap(f: A => Unit): A = { Option(obj).foreach(f); obj }

  def tapOption(f: A => Unit): Option[A] = { Option(obj).foreach(f); Option(obj) }

}

/**
 * {{{
 * def foo: Option[Bar] =
 *   allCatch opt {
 *     ... any process that an exception may be thrown
 *   } noneTap {
 *     Logger.info("An exception has occured")
 *   }
 * }}}
 * @param underlying
 * @tparam A
 */
class OptionTapper[A](underlying: Option[A]) {

  def noneTap(f: => Unit): Option[A] = { if (underlying.isEmpty) f; underlying }
  def someTap(f: A => Unit): Option[A] = { underlying.foreach(f); underlying }

}
/**
 * {{{
 * def foo: Either[Bar, Baz] =
 *   allCatch either {
 *     ... any process that an exception may be thrown
 *   } leftTap { exception =>
 *     Logger.info("An exception has occured", exception)
 *   }
 * }}}
 * @param underlying
 * @tparam A
 * @tparam B
 */
class EitherTapper[A, B](underlying: Either[A, B]) {
  import Tapper._

  def leftTap(f: A => Unit): Either[A, B] = underlying.tap(_.left.foreach(f))
  def rightTap(f: B => Unit): Either[A, B] = underlying.tap(_.right.foreach(f))

}
object Tapper {

  implicit def any2tapper[A](a: A): Tapper[A] = new Tapper(a)
  implicit def option2optionTapper[A](o: Option[A]): OptionTapper[A] = new OptionTapper(o)
  implicit def either2eitherTapper[A, B](e: Either[A, B]): EitherTapper[A, B] = new EitherTapper(e)

}