/*
 * Decompiled with CFR 0.152.
 */
package com.m3.memcached.facade;

import com.m3.memcached.facade.adaptor.MemcachedClientAdaptor;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;

public class Configuration {
    public static final String DEFAULT_PROPERTIES_FILENAME = "memcached.properties";
    public static final String KEY_CLIENT_ADAPTOR_CLASS_NAME = "clientAdaptorClassName";
    public static final String KEY_CLIENT_SERVER_ADDRESSES = "serverAddresses";
    public static final String KEY_NAMESPACE = "namespace";
    private Class<? extends MemcachedClientAdaptor> adaptorClass;
    private List<InetSocketAddress> addresses;
    private String namespace = "default";

    public static Configuration loadConfigFromProperties() throws IOException, ClassNotFoundException {
        return Configuration.loadConfigFromProperties(DEFAULT_PROPERTIES_FILENAME);
    }

    public static Configuration loadConfigFromProperties(String properties) throws IOException, ClassNotFoundException {
        String namespace;
        Configuration config = new Configuration();
        Properties props = new Properties();
        props.load(Configuration.class.getClassLoader().getResourceAsStream(properties));
        config.setAdaptorClassName(props.getProperty(KEY_CLIENT_ADAPTOR_CLASS_NAME));
        String addresses = props.getProperty(KEY_CLIENT_SERVER_ADDRESSES);
        if (addresses != null) {
            config.setAddressesAsString(addresses);
        }
        if ((namespace = props.getProperty(KEY_NAMESPACE)) != null) {
            config.setNamespace(namespace);
        }
        return config;
    }

    public Class<? extends MemcachedClientAdaptor> getAdaptorClass() {
        return this.adaptorClass;
    }

    public void setAdaptorClass(Class<? extends MemcachedClientAdaptor> adaptorClass) {
        this.adaptorClass = adaptorClass;
    }

    public void setAdaptorClassName(String adaptorClassName) throws ClassNotFoundException {
        if (adaptorClassName == null) {
            throw new IllegalArgumentException("adaptorClassName should not be null.");
        }
        this.adaptorClass = Class.forName(adaptorClassName);
    }

    public String getNamespace() {
        return this.namespace;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public List<InetSocketAddress> getAddresses() {
        return this.addresses;
    }

    public void setAddresses(List<InetSocketAddress> addresses) {
        this.addresses = addresses;
    }

    public void setAddressesAsString(String addresses) {
        String[] stringArray;
        if (addresses != null) {
            stringArray = addresses.split(",");
        } else {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = addresses;
        }
        this.setAddressesAsStringArray(stringArray);
    }

    public void setAddressesAsStringArray(String[] addresses) {
        this.addresses = new ArrayList<InetSocketAddress>();
        for (String address : addresses) {
            String[] splittedByColon = address.split(":");
            if (splittedByColon.length != 2) {
                throw new IllegalArgumentException("Invalid address format (" + address + ")");
            }
            this.addresses.add(new InetSocketAddress(splittedByColon[0], (int)Integer.valueOf(splittedByColon[1])));
        }
    }
}

