/*
 * Decompiled with CFR 0.152.
 */
package com.m3.memcached.facade;

import com.m3.memcached.facade.adaptor.MemcachedClientAdaptor;
import com.m3.memcached.facade.impl.ClientImpl;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MemcachedClient {
    private static final Logger log = LoggerFactory.getLogger(MemcachedClient.class);
    public static final String DEFAULT_NAMESPACE = "default";
    private ClientImpl clientImpl;

    MemcachedClient(MemcachedClientAdaptor clientAdaptor) throws Exception {
        Class<? extends ClientImpl> clazz = clientAdaptor.getClientImplClass();
        this.clientImpl = clazz.newInstance();
    }

    public void initialize(List<InetSocketAddress> addresses) throws IOException {
        this.clientImpl.initialize(addresses);
    }

    public void initialize(List<InetSocketAddress> addresses, String namespace) throws IOException {
        this.clientImpl.initialize(addresses);
        this.clientImpl.setNamespace(namespace);
    }

    public <T> T get(String key) throws IOException {
        this.ensureInitialized();
        return this.clientImpl.get(key);
    }

    public <T> void set(String key, int secondsToExpire, T value) throws IOException {
        this.ensureInitialized();
        this.clientImpl.set(key, secondsToExpire, value);
    }

    public <T> void setAndEnsure(String key, int secondsToExpire, T value) throws IOException {
        this.ensureInitialized();
        this.clientImpl.setAndEnsure(key, secondsToExpire, value);
    }

    public void delete(String key) throws IOException {
        this.ensureInitialized();
        this.clientImpl.delete(key);
    }

    public void shutdown() {
        block2: {
            try {
                this.clientImpl.shutdown();
            }
            catch (Exception e) {
                if (!log.isDebugEnabled()) break block2;
                log.debug("Failed to shutdown memcached client instance.", (Throwable)e);
            }
        }
    }

    public ClientImpl getClientImpl() {
        return this.clientImpl;
    }

    void ensureInitialized() throws IllegalStateException {
        if (this.clientImpl == null || !this.clientImpl.isInitialized()) {
            throw new IllegalStateException("Not yet initialized.");
        }
    }
}

