/*
 * Decompiled with CFR 0.152.
 */
package com.m3.memcached.facade;

import com.m3.memcached.facade.Configuration;
import com.m3.memcached.facade.MemcachedClient;
import com.m3.memcached.facade.adaptor.MemcachedClientAdaptor;
import com.m3.memcached.facade.util.Assertion;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public final class MemcachedClientPool {
    private static final String DEFAULT_CLIENT_ADAPTOR_NAME = "com.m3.memcached.facade.adaptor.SpymemcachedAdaptor";
    private Configuration config;
    private MemcachedClient client;
    @Deprecated
    private static final Map<String, MemcachedClient> DEPRECATED_POOL = new ConcurrentHashMap<String, MemcachedClient>();

    public MemcachedClientPool() throws Exception {
        this(null);
    }

    public MemcachedClientPool(Configuration config) throws Exception {
        if (config == null) {
            config = new Configuration();
            config.loadConfigFromProperties();
        }
        this.config = config;
        Class<MemcachedClientAdaptor> adaptorClass = config.getAdaptorClass();
        if (adaptorClass == null) {
            adaptorClass = Class.forName(DEFAULT_CLIENT_ADAPTOR_NAME);
        }
        this.client = new MemcachedClient(adaptorClass.newInstance());
        Assertion.notNullValue("config.getAddresses()", config.getAddresses());
        this.client.initialize(config.getAddresses(), config.getNamespace());
    }

    public Configuration getConfig() {
        return this.config;
    }

    public MemcachedClient getClient() {
        return this.client;
    }

    public void shutdown() {
        this.client.shutdown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        try {
            super.finalize();
        }
        finally {
            this.shutdown();
        }
    }

    @Deprecated
    public static MemcachedClient getMemcachedClient(Configuration config) throws Exception {
        MemcachedClient memcached;
        String namespace;
        if (config == null) {
            config = new Configuration();
            config.loadConfigFromProperties();
        }
        if ((namespace = config.getNamespace()) == null) {
            config.setNamespace("default");
        }
        if ((memcached = DEPRECATED_POOL.get(namespace)) != null) {
            return memcached;
        }
        Class<MemcachedClientAdaptor> adaptorClass = config.getAdaptorClass();
        if (adaptorClass == null) {
            adaptorClass = Class.forName(DEFAULT_CLIENT_ADAPTOR_NAME);
        }
        memcached = new MemcachedClient(adaptorClass.newInstance());
        Assertion.notNullValue("config.getAddresses()", config.getAddresses());
        memcached.initialize(config.getAddresses(), namespace);
        DEPRECATED_POOL.put(namespace, memcached);
        return memcached;
    }
}

