/*
 * Decompiled with CFR 0.152.
 */
package com.m3.memcached.facade.impl;

import com.m3.memcached.facade.impl.ClientImplBase;
import com.m3.memcached.facade.util.Assertion;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.List;
import java.util.concurrent.TimeUnit;
import net.spy.memcached.MemcachedClient;
import net.spy.memcached.internal.OperationFuture;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SpymemcachedClientImpl
extends ClientImplBase {
    private static final Logger log = LoggerFactory.getLogger(SpymemcachedClientImpl.class);
    private MemcachedClient memcached;

    void waitForConnectionReady() {
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    @Override
    public boolean isInitialized() {
        return this.memcached != null;
    }

    @Override
    public void initialize(List<InetSocketAddress> addresses) throws IOException {
        Assertion.notNullValue("addresses", addresses);
        this.memcached = new MemcachedClient(addresses);
        this.waitForConnectionReady();
    }

    @Override
    public void initialize(List<InetSocketAddress> addresses, String namespace) throws IOException {
        Assertion.notNullValue("addresses", addresses);
        this.memcached = new MemcachedClient(addresses);
        this.setNamespace(namespace);
        this.waitForConnectionReady();
    }

    @Override
    public void initialize(List<InetSocketAddress> addresses, String namespace, long maxWaitMillis) throws IOException {
        Assertion.notNullValue("addresses", addresses);
        this.memcached = new MemcachedClient(addresses);
        this.setNamespace(namespace);
        this.setMaxWaitMillis(maxWaitMillis);
        this.waitForConnectionReady();
    }

    @Override
    public <T> void set(String key, int secondsToExpire, T value) throws IOException {
        Assertion.notNullValue("key", key);
        if (this.hasNoAvailableServer()) {
            return;
        }
        this.memcached.set(this.getKeyWithNamespace(key), secondsToExpire, value);
    }

    @Override
    public <T> void setAndEnsure(String key, int secondsToExpire, T value) throws IOException {
        Assertion.notNullValue("key", key);
        if (this.hasNoAvailableServer()) {
            return;
        }
        OperationFuture future = this.memcached.set(this.getKeyWithNamespace(key), secondsToExpire, value);
        try {
            boolean result = (Boolean)future.get(5L, TimeUnit.SECONDS);
            if (!result) {
                String failedMessage = "Failed to set the value on memcached! (key:" + key + ",secondsToExpire:" + secondsToExpire + ",value:" + value + ")";
                throw new IOException(failedMessage);
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        catch (Exception e) {
            String failedMessage = "Failed to set the value on memcached! (key:" + key + ",secondsToExpire:" + secondsToExpire + ",value:" + value + ")";
            throw new IOException(failedMessage, e);
        }
    }

    @Override
    public <T> T get(String key) throws IOException {
        Assertion.notNullValue("key", key);
        try {
            if (this.hasNoAvailableServer()) {
                return null;
            }
            return (T)this.memcached.asyncGet(this.getKeyWithNamespace(key)).get(this.getMaxWaitMillis(), TimeUnit.MILLISECONDS);
        }
        catch (Throwable t) {
            String failedMessage = "Failed to get value on memcached! (key:" + key + ")";
            throw new IOException(failedMessage, t);
        }
    }

    @Override
    public void delete(String key) throws IOException {
        Assertion.notNullValue("key", key);
        try {
            if (this.hasNoAvailableServer()) {
                return;
            }
            this.memcached.delete(this.getKeyWithNamespace(key));
        }
        catch (Throwable t) {
            String failedMessage = "Failed to delete key on memcached! (key:" + key + ")";
            throw new IOException(failedMessage, t);
        }
    }

    @Override
    public void shutdown() {
        if (this.memcached == null) {
            throw new IllegalStateException("Memcached client instance has not been initialized yet.");
        }
        this.memcached.shutdown();
    }

    private boolean hasNoAvailableServer() {
        boolean unavailable = this.memcached.getAvailableServers().isEmpty();
        if (unavailable && log.isDebugEnabled()) {
            log.debug("No available memcached servers now.");
        }
        return unavailable;
    }
}

