/*
 * Decompiled with CFR 0.152.
 */
package com.m3.memcached.facade.impl;

import com.m3.memcached.facade.impl.ClientImplBase;
import com.m3.memcached.facade.impl.SpymemcachedClientImpl;
import com.m3.memcached.facade.util.Assertion;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.List;
import net.rubyeye.xmemcached.MemcachedClient;
import net.rubyeye.xmemcached.XMemcachedClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XmemcachedClientImpl
extends ClientImplBase {
    private static final Logger log = LoggerFactory.getLogger(SpymemcachedClientImpl.class);
    private MemcachedClient memcached;

    @Override
    public boolean isInitialized() {
        return this.memcached != null;
    }

    @Override
    public void initialize(List<InetSocketAddress> addresses) throws IOException {
        Assertion.notNullValue("addresses", addresses);
        this.memcached = new XMemcachedClient(addresses);
    }

    @Override
    public void initialize(List<InetSocketAddress> addresses, String namespace) throws IOException {
        Assertion.notNullValue("addresses", addresses);
        this.memcached = new XMemcachedClient(addresses);
        this.setNamespace(namespace);
    }

    @Override
    public void initialize(List<InetSocketAddress> addresses, String namespace, long maxWaitMillis) throws IOException {
        Assertion.notNullValue("addresses", addresses);
        this.memcached = new XMemcachedClient(addresses);
        this.setNamespace(namespace);
        this.setMaxWaitMillis(maxWaitMillis);
    }

    @Override
    public <T> void set(String key, int secondsToExpire, T value) throws IOException {
        Assertion.notNullValue("key", key);
        try {
            if (this.hasNoAvailableServer()) {
                return;
            }
            this.memcached.set(this.getKeyWithNamespace(key), secondsToExpire, value);
        }
        catch (Exception e) {
            String failedMessage = "Failed to set value on memcached! (key:" + key + ",secondsToExpire:" + secondsToExpire + ",value:" + value + ")";
            throw new IOException(failedMessage, e);
        }
    }

    @Override
    public <T> void setAndEnsure(String key, int secondsToExpire, T value) throws IOException {
        Assertion.notNullValue("key", key);
        try {
            if (this.hasNoAvailableServer()) {
                return;
            }
            this.set(key, secondsToExpire, value);
            Object cached = this.memcached.get(this.getKeyWithNamespace(key));
            if (cached == null) {
                String failedMessage = "Failed to set value on memcached! (key:" + key + ",secondsToExpire:" + secondsToExpire + ",value:" + value + ")";
                throw new IOException(failedMessage);
            }
        }
        catch (Exception e) {
            String failedMessage = "Failed to set value on memcached! (key:" + key + ",secondsToExpire:" + secondsToExpire + ",value:" + value + ")";
            throw new IOException(failedMessage, e);
        }
    }

    @Override
    public <T> T get(String key) throws IOException {
        Assertion.notNullValue("key", key);
        try {
            if (this.hasNoAvailableServer()) {
                return null;
            }
            return (T)this.memcached.get(this.getKeyWithNamespace(key));
        }
        catch (Exception e) {
            String failedMessage = "Failed to get value on memcached! (key:" + key + ")";
            throw new IOException(failedMessage, e);
        }
    }

    @Override
    public void delete(String key) throws IOException {
        Assertion.notNullValue("key", key);
        try {
            if (this.hasNoAvailableServer()) {
                return;
            }
            this.memcached.delete(this.getKeyWithNamespace(key));
        }
        catch (Throwable t) {
            String failedMessage = "Failed to delete key on memcached! (key:" + key + ")";
            throw new IOException(failedMessage, t);
        }
    }

    @Override
    public void shutdown() {
        block4: {
            if (this.memcached == null) {
                throw new IllegalStateException("Memcached client instance has not been initialized yet.");
            }
            try {
                if (!this.memcached.isShutdown()) {
                    this.memcached.shutdown();
                }
            }
            catch (IOException e) {
                String message = "Failed to shutdown memcached client because " + e.getMessage();
                log.info(message);
                if (!log.isDebugEnabled()) break block4;
                log.debug(message, (Throwable)e);
            }
        }
    }

    private boolean hasNoAvailableServer() {
        boolean unavailable = this.memcached.getAvailableServers().isEmpty();
        if (unavailable && log.isDebugEnabled()) {
            log.debug("No available memcached servers now.");
        }
        return unavailable;
    }
}

