/*
 * Decompiled with CFR 0.152.
 */
package com.m3.scalaflavor4j;

import com.m3.scalaflavor4j.F1;
import com.m3.scalaflavor4j.Seq;
import com.m3.scalaflavor4j.arm.Resource;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;

public class BufferedSource {
    private final InputStream stream;
    private final String encoding;

    public BufferedSource(File file, String enc) throws FileNotFoundException {
        this.stream = new FileInputStream(file);
        this.encoding = enc;
    }

    public BufferedSource(InputStream is, String enc) throws FileNotFoundException {
        this.stream = is;
        this.encoding = enc;
    }

    public InputStreamReader getInputStreamReader() throws UnsupportedEncodingException {
        if (this.encoding == null) {
            return new InputStreamReader(this.stream);
        }
        return new InputStreamReader(this.stream, this.encoding);
    }

    public Seq<Byte> toByteSeq() throws IOException {
        return Resource.managed(this.stream).map(new F1<InputStream, Seq<Byte>>(){

            @Override
            public Seq<Byte> apply(InputStream stream) throws Exception {
                return Resource.managed(BufferedSource.this.getInputStreamReader()).map(new F1<InputStreamReader, Seq<Byte>>(){

                    @Override
                    public Seq<Byte> apply(InputStreamReader isr) throws Exception {
                        int b;
                        ArrayList<Byte> bs = new ArrayList<Byte>();
                        while ((b = isr.read()) != -1) {
                            bs.add((byte)b);
                        }
                        return Seq.apply(bs);
                    }
                });
            }
        });
    }

    public Seq<Character> toCharSeq() throws IOException {
        return Resource.managed(this.stream).map(new F1<InputStream, Seq<Character>>(){

            @Override
            public Seq<Character> apply(InputStream stream) throws Exception {
                return Resource.managed(BufferedSource.this.getInputStreamReader()).map(new F1<InputStreamReader, Seq<Character>>(){

                    @Override
                    public Seq<Character> apply(InputStreamReader isr) throws Exception {
                        int c;
                        ArrayList<Character> cs = new ArrayList<Character>();
                        while ((c = isr.read()) != -1) {
                            cs.add(Character.valueOf((char)c));
                        }
                        return Seq.apply(cs);
                    }
                });
            }
        });
    }

    public Seq<String> toStringSeq() throws IOException {
        return this.getLines();
    }

    public Seq<String> getLines() throws IOException {
        return Resource.managed(this.stream).map(new F1<InputStream, Seq<String>>(){

            @Override
            public Seq<String> apply(InputStream stream) throws Exception {
                return Resource.managed(BufferedSource.this.getInputStreamReader()).map(new F1<InputStreamReader, Seq<String>>(){

                    @Override
                    public Seq<String> apply(InputStreamReader isr) throws Exception {
                        return Resource.managed(new BufferedReader(isr)).map(new F1<BufferedReader, Seq<String>>(){

                            @Override
                            public Seq<String> apply(BufferedReader br) throws Exception {
                                String line;
                                ArrayList<String> lines = new ArrayList<String>();
                                while ((line = br.readLine()) != null) {
                                    lines.add(line);
                                }
                                return Seq.apply(lines);
                            }
                        });
                    }
                });
            }
        });
    }
}

