/*
 * Decompiled with CFR 0.152.
 */
package com.m3.scalaflavor4j;

import com.m3.scalaflavor4j.Function0;
import com.m3.scalaflavor4j.Tuple;
import com.m3.scalaflavor4j.Tuple2;
import com.m3.scalaflavor4j.VoidFunction0;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.logging.Level;
import java.util.logging.Logger;
import jsr166y.ForkJoinPool;

public class ConcurrentOps {
    private static final Logger logger = Logger.getLogger(ConcurrentOps.class.getCanonicalName());
    private static ForkJoinPool forkJoinPool = new ForkJoinPool();

    private ConcurrentOps() {
    }

    public static <R> Future<R> future(final Function0<R> p) {
        FutureTask future = new FutureTask(new Callable<R>(){

            @Override
            public R call() throws Exception {
                return p.apply();
            }
        });
        forkJoinPool.execute(future);
        return future;
    }

    public static <A, B> Tuple2<A, B> par(final Function0<A> xp, final Function0<B> yp) throws InterruptedException, ExecutionException {
        FutureTask xpFuture = new FutureTask(new Callable<A>(){

            @Override
            public A call() throws Exception {
                return xp.apply();
            }
        });
        FutureTask ypFuture = new FutureTask(new Callable<B>(){

            @Override
            public B call() throws Exception {
                return yp.apply();
            }
        });
        forkJoinPool.execute(xpFuture);
        forkJoinPool.execute(ypFuture);
        return Tuple.apply(xpFuture.get(), ypFuture.get());
    }

    public static void spawn(final VoidFunction0 p) {
        forkJoinPool.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    p.apply();
                }
                catch (Throwable t) {
                    logger.log(Level.WARNING, "Exception is thrown on a spawn thread.", t);
                }
            }
        });
    }
}

