/*
 * Decompiled with CFR 0.152.
 */
package com.m3.scalaflavor4j;

import com.m3.scalaflavor4j.Either;
import com.m3.scalaflavor4j.F1;
import com.m3.scalaflavor4j.Function0;
import com.m3.scalaflavor4j.Function1;
import com.m3.scalaflavor4j.Left;
import com.m3.scalaflavor4j.Option;
import com.m3.scalaflavor4j.PredicateF1;
import com.m3.scalaflavor4j.Right;
import com.m3.scalaflavor4j.ScalaFlavor4JException;
import com.m3.scalaflavor4j.Seq;
import com.m3.scalaflavor4j.VoidF0;
import com.m3.scalaflavor4j.VoidFunction0;

public class ExceptionControl {
    private ExceptionControl() {
    }

    public static CatchBuilder catching(Class<? extends Throwable> ... catcher) {
        CatchBuilder builder = new CatchBuilder(Seq.apply(catcher));
        builder.setPromiscuously(false);
        return builder;
    }

    public static CatchBuilder catchingPromiscuously(Class<? extends Throwable> ... catcher) {
        CatchBuilder builder = new CatchBuilder(Seq.apply(catcher));
        builder.setPromiscuously(true);
        return builder;
    }

    public static HandlingByBuilder handling(Class<? extends Throwable> ... catcher) {
        HandlingByBuilder builder = new HandlingByBuilder(Seq.apply(catcher));
        builder.setPromiscuously(false);
        return builder;
    }

    public static <R> Catch<R> ignoring(Class<? extends Throwable> ... catcher) {
        return new CatchBuilder(Seq.apply(catcher)).withApply(new F1<Throwable, R>(){

            @Override
            public R apply(Throwable v1) throws Exception {
                return null;
            }
        });
    }

    public static <R> Catch<R> ultimately(VoidFunction0 body) {
        Catch c = new Catch(Seq.apply(new Class[0]), null, false);
        c.andFinally(body);
        return c;
    }

    public static CatchBuilder allCatch() {
        return new CatchBuilder(Seq.apply(Throwable.class));
    }

    public static class Catch<R>
    implements F1<Function0<R>, R> {
        private VoidF0 defaultFinallyHandler = new VoidF0(){

            @Override
            public void apply() {
            }
        };
        private final Seq<HandlerDef> handlerDefinitions;
        private VoidFunction0 finallyHandler = this.defaultFinallyHandler;
        private boolean promiscuously = false;

        public Catch(Seq<HandlerDef> handlerDefinitions, boolean promiscuously) {
            this.handlerDefinitions = handlerDefinitions;
            this.promiscuously = promiscuously;
        }

        public Catch(Seq<Class<? extends Throwable>> classes, Function1<Throwable, R> withApply) {
            this(classes, withApply, false);
        }

        public Catch(Seq<Class<? extends Throwable>> classes, Function1<Throwable, R> withApply, boolean promiscuously) {
            this.handlerDefinitions = Seq.apply(new HandlerDef(classes, withApply));
            this.promiscuously = promiscuously;
        }

        public Catch<R> andFinally(VoidFunction0 body) {
            this.finallyHandler = body;
            return this;
        }

        public Either<Throwable, R> either(Function0<R> block) {
            try {
                Applied applied = this._apply(block);
                if (applied.handled.isDefined()) {
                    return Left.apply(applied.handled);
                }
                return Right.apply(applied.result);
            }
            catch (Throwable e) {
                throw new ScalaFlavor4JException(e);
            }
        }

        public Option<R> opt(Function0<R> block) {
            try {
                Applied applied = this._apply(block);
                if (applied.handled.isDefined()) {
                    return Option.none();
                }
                return Option.apply(applied.result);
            }
            catch (Throwable e) {
                throw new ScalaFlavor4JException(e);
            }
        }

        private Applied _apply(Function0<R> block) throws Exception {
            try {
                Applied applied = new Applied(block.apply());
                return applied;
            }
            catch (Exception e) {
                if (!this.promiscuously && e instanceof InterruptedException) {
                    throw e;
                }
                Option<HandlerDef> handlerDefinition = this.handlerDefinitions.find((Function1<HandlerDef, Boolean>)new PredicateF1<HandlerDef>(){

                    @Override
                    public Boolean apply(HandlerDef handlerDef) {
                        return handlerDef.classesToHandle.find(new PredicateF1<Class<? extends Throwable>>(){

                            @Override
                            public Boolean apply(Class<? extends Throwable> targetClass) throws Exception {
                                try {
                                    return targetClass.cast(e) != null;
                                }
                                catch (ClassCastException cce) {
                                    return false;
                                }
                            }
                        }).isDefined();
                    }
                });
                if (!handlerDefinition.isDefined()) {
                    throw e;
                }
                Seq classesToHandle = handlerDefinition.getOrNull().classesToHandle;
                Function1 catchHandler = handlerDefinition.getOrNull().withApply;
                Class<? extends Throwable> classToHandle = classesToHandle.find(new PredicateF1<Class<? extends Throwable>>(){

                    @Override
                    public Boolean apply(Class<? extends Throwable> classToHandle) {
                        try {
                            return classToHandle.cast(e) != null;
                        }
                        catch (ClassCastException cce) {
                            return false;
                        }
                    }
                }).getOrNull();
                try {
                    Object handlerApplied = catchHandler.apply(classToHandle.cast(e));
                    Applied applied = new Applied(handlerApplied, e);
                    return applied;
                }
                catch (Exception e2) {
                    try {
                        throw e2;
                    }
                    catch (ClassCastException cce) {
                        throw e;
                    }
                }
            }
            finally {
                this.finallyHandler.apply();
            }
        }

        @Override
        public R apply(Function0<R> block) {
            try {
                return this._apply(block).result;
            }
            catch (Exception e) {
                throw new ScalaFlavor4JException(e);
            }
        }

        public Catch<R> or(Catch<R> that) {
            return new Catch<R>(this.handlerDefinitions.union(that.handlerDefinitions), this.promiscuously);
        }

        private class Applied {
            R result;
            Option<Throwable> handled = Option.none();

            public Applied(R result) {
                this.result = result;
            }

            public Applied(R result, Throwable handled) {
                this.result = result;
                this.handled = Option.apply(handled);
            }
        }

        private class HandlerDef {
            private Seq<Class<? extends Throwable>> classesToHandle;
            private Function1<Throwable, R> withApply;

            public HandlerDef(Seq<Class<? extends Throwable>> classesToHandle, Function1<Throwable, R> withApply) {
                this.classesToHandle = classesToHandle;
                this.withApply = withApply;
            }
        }
    }

    public static class CatchBuilder {
        protected boolean promiscuously = false;
        protected Seq<Class<? extends Throwable>> classesToCatch;

        protected CatchBuilder(Seq<Class<? extends Throwable>> classesToCatch) {
            this.classesToCatch = classesToCatch;
        }

        public boolean isPromiscuously() {
            return this.promiscuously;
        }

        public void setPromiscuously(boolean promiscuously) {
            this.promiscuously = promiscuously;
        }

        public <R> Catch<R> withApply(Function1<Throwable, R> f) {
            return new Catch<R>(this.classesToCatch, f, this.promiscuously);
        }
    }

    public static class HandlingByBuilder
    extends CatchBuilder {
        protected HandlingByBuilder(Seq<Class<? extends Throwable>> classesToCatch) {
            super(classesToCatch);
        }

        public <R> Catch<R> by(Function1<Throwable, R> f) {
            return super.withApply(f);
        }
    }
}

