/*
 * Decompiled with CFR 0.152.
 */
package com.m3.scalaflavor4j;

import com.m3.scalaflavor4j.CollectionLike;
import com.m3.scalaflavor4j.ConcurrentOps;
import com.m3.scalaflavor4j.ExceptionControl;
import com.m3.scalaflavor4j.F0;
import com.m3.scalaflavor4j.F1;
import com.m3.scalaflavor4j.FlatMapF1;
import com.m3.scalaflavor4j.FoldLeftF2;
import com.m3.scalaflavor4j.Function1;
import com.m3.scalaflavor4j.Nil;
import com.m3.scalaflavor4j.Option;
import com.m3.scalaflavor4j.ParSeq;
import com.m3.scalaflavor4j.SMap;
import com.m3.scalaflavor4j.ScalaFlavor4JException;
import com.m3.scalaflavor4j.Seq;
import com.m3.scalaflavor4j.VoidFunction1;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.Future;
import java.util.logging.Level;
import java.util.logging.Logger;
import jsr166y.ForkJoinPool;

public class ForkJoinParSeq<T>
extends ParSeq<T> {
    private static final long serialVersionUID = 1L;
    private final Nil<T> NIL = Nil.apply();
    private static final Logger logger = Logger.getLogger(ForkJoinParSeq.class.getCanonicalName());
    private static final ForkJoinPool forkJoinPool = new ForkJoinPool();
    protected final Collection<T> collection;

    public static <T> ForkJoinParSeq<T> apply(T ... values) {
        LinkedList list = new LinkedList();
        Collections.addAll(list, values);
        return ForkJoinParSeq.apply(list);
    }

    public static <T> ForkJoinParSeq<T> apply(Collection<T> collection) {
        return new ForkJoinParSeq<T>(collection);
    }

    ForkJoinParSeq(Collection<T> collection) {
        if (collection == null) {
            throw new IllegalArgumentException("List should not be null.");
        }
        this.collection = collection;
    }

    private static <T> T doBlocking(final Future<T> future) throws Exception {
        return (T)ExceptionControl.handling(Exception.class).by(new F1<Throwable, T>(){

            @Override
            public T apply(Throwable t) throws Exception {
                throw new ScalaFlavor4JException(t);
            }
        }).apply(new F0<T>(){

            @Override
            public T apply() throws Exception {
                return future.get();
            }
        });
    }

    @Override
    public int count(final Function1<T, Boolean> predicate) {
        if (this.isEmpty()) {
            return this.NIL.count(predicate);
        }
        return this.map(new F1<T, Integer>(){

            @Override
            public Integer apply(T element) throws Exception {
                return (Boolean)predicate.apply(element) != false ? 1 : 0;
            }
        }).toSeq().foldLeft(0, new FoldLeftF2<Integer, Integer>(){

            @Override
            public Integer apply(Integer sum, Integer i) throws Exception {
                return sum + i;
            }
        });
    }

    @Override
    public boolean exists(final Function1<T, Boolean> predicate) {
        if (this.isEmpty()) {
            return this.NIL.exists(predicate);
        }
        return this.map(new F1<T, Boolean>(){

            @Override
            public Boolean apply(T element) throws Exception {
                return (Boolean)predicate.apply(element);
            }
        }).toSeq().contains(true);
    }

    @Override
    public ParSeq<T> filter(final Function1<T, Boolean> predicate) {
        if (this.isEmpty()) {
            return ParSeq.apply(this.NIL.filter(predicate).toList());
        }
        return this.flatMap(new FlatMapF1<T, T>(){

            @Override
            public CollectionLike<T> apply(T element) throws Exception {
                if (((Boolean)predicate.apply(element)).booleanValue()) {
                    return Option.apply(element);
                }
                return Option.none();
            }
        });
    }

    @Override
    public ParSeq<T> filterNot(final Function1<T, Boolean> predicate) {
        if (this.isEmpty()) {
            return ParSeq.apply(this.NIL.filterNot(predicate).toList());
        }
        return this.flatMap(new FlatMapF1<T, T>(){

            @Override
            public CollectionLike<T> apply(T element) throws Exception {
                if (!((Boolean)predicate.apply(element)).booleanValue()) {
                    return Option.apply(element);
                }
                return Option.none();
            }
        });
    }

    @Override
    public <U> ParSeq<U> flatMap(final Function1<T, CollectionLike<U>> f) {
        if (this.isEmpty()) {
            return ParSeq.apply(this.NIL.flatMap(f).toList());
        }
        LinkedList futures = new LinkedList();
        for (final T element : this.collection) {
            futures.add(ConcurrentOps.future(new F0<CollectionLike<U>>(){

                @Override
                public CollectionLike<U> apply() throws Exception {
                    return (CollectionLike)f.apply(element);
                }
            }));
        }
        LinkedList results = new LinkedList();
        for (Future future : futures) {
            try {
                results.addAll(((CollectionLike)ForkJoinParSeq.doBlocking(future)).toList());
            }
            catch (Exception e) {
                throw new ScalaFlavor4JException(e);
            }
        }
        return ParSeq.apply(results);
    }

    @Override
    public boolean forall(final Function1<T, Boolean> predicate) {
        if (this.isEmpty()) {
            return this.NIL.forall(predicate);
        }
        Seq result = this.map(new F1<T, Boolean>(){

            @Override
            public Boolean apply(T element) throws Exception {
                return (Boolean)predicate.apply(element);
            }
        }).toSeq().distinct();
        return result.size() == 1 && (Boolean)result.head() != false;
    }

    @Override
    public void foreach(final VoidFunction1<T> f) {
        if (this.isEmpty()) {
            this.NIL.foreach(f);
            return;
        }
        for (final T element : this.collection) {
            forkJoinPool.execute(new Runnable(){

                @Override
                public void run() {
                    try {
                        f.apply(element);
                    }
                    catch (Throwable t) {
                        logger.log(Level.WARNING, "Exception is thrown on a spawn thread.", t);
                    }
                }
            });
        }
    }

    @Override
    public <U> SMap<U, Seq<T>> groupBy(final Function1<T, U> getGroupName) {
        if (this.isEmpty()) {
            return this.NIL.groupBy(getGroupName);
        }
        ParSeq<U> entries = this.map(new F1<T, GroupEntry<U>>(){

            @Override
            public GroupEntry<U> apply(T element) throws Exception {
                Object name = getGroupName.apply(element);
                return new GroupEntry(name, element);
            }
        });
        return entries.toSeq().foldLeft(SMap.apply(), new FoldLeftF2<SMap<U, Seq<T>>, GroupEntry<U>>(){

            @Override
            public SMap<U, Seq<T>> apply(SMap<U, Seq<T>> map, GroupEntry<U> entry) throws Exception {
                Seq<Object> groupMembers = map.getOrElse(entry.groupName, Seq.apply(new Object[0]));
                return map.updated(entry.groupName, groupMembers.append((Object[])new Object[]{entry.member}));
            }
        });
    }

    @Override
    public boolean isEmpty() {
        return this.collection == null || this.collection.size() == 0;
    }

    @Override
    public <U> ParSeq<U> map(final Function1<T, U> f) {
        if (this.isEmpty()) {
            return ParSeq.apply(this.NIL.map(f).toList());
        }
        LinkedList futures = new LinkedList();
        for (final T element : this.collection) {
            futures.add(ConcurrentOps.future(new F0<U>(){

                @Override
                public U apply() throws Exception {
                    return f.apply(element);
                }
            }));
        }
        LinkedList<T> results = new LinkedList<T>();
        for (Future future : futures) {
            try {
                results.add(ForkJoinParSeq.doBlocking(future));
            }
            catch (Exception e) {
                throw new ScalaFlavor4JException(e);
            }
        }
        return ParSeq.apply(results);
    }

    @Override
    public List<T> toList() {
        return new ArrayList<T>(this.collection);
    }

    @Override
    public Seq<T> toSeq() {
        return Seq.apply(new ArrayList<T>(this.collection));
    }

    private class GroupEntry<U> {
        U groupName;
        T member;

        public GroupEntry(U name, T value) {
            this.groupName = name;
            this.member = value;
        }
    }
}

