/*
 * Decompiled with CFR 0.152.
 */
package com.m3.scalaflavor4j;

import com.m3.scalaflavor4j.CollectionLike;
import com.m3.scalaflavor4j.F1;
import com.m3.scalaflavor4j.FlatMapF1;
import com.m3.scalaflavor4j.FoldLeftF2;
import com.m3.scalaflavor4j.FoldRightF2;
import com.m3.scalaflavor4j.Function1;
import com.m3.scalaflavor4j.Function2;
import com.m3.scalaflavor4j.Nil;
import com.m3.scalaflavor4j.Option;
import com.m3.scalaflavor4j.Pair;
import com.m3.scalaflavor4j.ParSeq;
import com.m3.scalaflavor4j.PredicateF1;
import com.m3.scalaflavor4j.SInt;
import com.m3.scalaflavor4j.SMap;
import com.m3.scalaflavor4j.SNum;
import com.m3.scalaflavor4j.ScalaFlavor4JException;
import com.m3.scalaflavor4j.Seq;
import com.m3.scalaflavor4j.Tuple;
import com.m3.scalaflavor4j.Tuple2;
import com.m3.scalaflavor4j.VoidF1;
import com.m3.scalaflavor4j.VoidFunction1;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class IndexedSeq<T>
extends Seq<T> {
    private static final long serialVersionUID = 1L;
    private final Nil<T> NIL = Nil.apply();
    protected final List<T> list;

    public static <T> IndexedSeq<T> apply(T ... values) {
        ArrayList<T> list = new ArrayList<T>();
        for (T value : values) {
            list.add(value);
        }
        return IndexedSeq.apply(list);
    }

    public static <T> IndexedSeq<T> apply(Collection<T> list) {
        return new IndexedSeq<T>(list);
    }

    protected IndexedSeq(Collection<T> list) {
        if (list == null) {
            throw new IllegalArgumentException("List should not be null.");
        }
        this.list = new ArrayList<T>(list);
    }

    @Override
    public IndexedSeq<T> append(T ... that) {
        ArrayList<T> newList = new ArrayList<T>();
        newList.addAll(this.toList());
        newList.addAll(Arrays.asList(that));
        return IndexedSeq.apply(newList);
    }

    @Override
    public boolean contains(final T elem) {
        return this.dropNull().foldLeft(false, new FoldLeftF2<Boolean, T>(){

            @Override
            public Boolean apply(Boolean contains, T exist) {
                if (!contains.booleanValue()) {
                    return exist.equals(elem);
                }
                return contains;
            }
        });
    }

    @Override
    public <U> Function1<Function2<T, U, Boolean>, Boolean> corresponds(final Seq<U> that) {
        if (this.size() != that.size()) {
            return new F1<Function2<T, U, Boolean>, Boolean>(){

                @Override
                public Boolean apply(Function2<T, U, Boolean> p) {
                    return false;
                }
            };
        }
        return new F1<Function2<T, U, Boolean>, Boolean>(){

            @Override
            public Boolean apply(final Function2<T, U, Boolean> p) {
                return ((IndexedSeq)IndexedSeq.this.zip(that)).forall(new F1<Tuple2<T, U>, Boolean>(){

                    @Override
                    public Boolean apply(Tuple2<T, U> e) throws Exception {
                        return (Boolean)p.apply(e._1(), e._2());
                    }
                });
            }
        };
    }

    @Override
    public <U> boolean corresponds(Seq<U> that, final Function2<T, U, Boolean> p) {
        if (this.size() != that.size()) {
            return false;
        }
        return ((IndexedSeq)this.zip((Seq)that)).forall(new F1<Tuple2<T, U>, Boolean>(){

            @Override
            public Boolean apply(Tuple2<T, U> e) throws Exception {
                return (Boolean)p.apply(e._1(), e._2());
            }
        });
    }

    @Override
    public int count(final Function1<T, Boolean> predicate) {
        return this.foldLeft(0, new FoldLeftF2<Integer, T>(){

            @Override
            public Integer apply(Integer count, T element) throws Exception {
                if (((Boolean)predicate.apply(element)).booleanValue()) {
                    return count + 1;
                }
                return count;
            }
        });
    }

    @Override
    public IndexedSeq<T> diff(final Seq<T> that) {
        return this.filterNot((Function1)new PredicateF1<T>(){

            @Override
            public Boolean apply(final T thisValue) {
                return that.foldLeft(false, new FoldLeftF2<Boolean, T>(){

                    @Override
                    public Boolean apply(Boolean isFound, T thatValue) {
                        if (!isFound.booleanValue()) {
                            if (thisValue == null) {
                                return thatValue == null;
                            }
                            if (thisValue.equals(thatValue)) {
                                return true;
                            }
                        }
                        return isFound;
                    }
                });
            }
        });
    }

    @Override
    public IndexedSeq<T> distinct() {
        return this.foldLeft(IndexedSeq.apply(new Object[0]), new FoldLeftF2<IndexedSeq<T>, T>(){

            @Override
            public IndexedSeq<T> apply(IndexedSeq<T> distinct, T element) {
                if (!distinct.contains(element)) {
                    return distinct.append(new Object[]{element});
                }
                return distinct;
            }
        });
    }

    @Override
    public IndexedSeq<T> drop(int n) {
        return this.slice(n, this.size());
    }

    @Override
    public Seq<T> dropNull() {
        return this.filter((Function1)new PredicateF1<T>(){

            @Override
            public Boolean apply(T element) {
                return element != null;
            }
        });
    }

    @Override
    public IndexedSeq<T> dropRight(int n) {
        return ((IndexedSeq)((IndexedSeq)this.reverse()).drop(n)).reverse();
    }

    @Override
    public IndexedSeq<T> dropWhile(Function1<T, Boolean> predicate) {
        if (this.isEmpty()) {
            return IndexedSeq.apply(new Object[0]);
        }
        return (IndexedSeq)this.span(predicate)._2();
    }

    @Override
    public boolean endsWith(Seq<T> that) {
        return ((IndexedSeq)this.reverse()).startsWith(that.reverse());
    }

    @Override
    public boolean exists(Function1<T, Boolean> predicate) {
        return ((IndexedSeq)this.filter((Function1)predicate)).size() > 0;
    }

    @Override
    public IndexedSeq<T> filter(final Function1<T, Boolean> isOk) {
        return this.foldLeft(IndexedSeq.apply(new Object[0]), new FoldLeftF2<IndexedSeq<T>, T>(){

            @Override
            public IndexedSeq<T> apply(IndexedSeq<T> filtered, T element) throws Exception {
                if (((Boolean)isOk.apply(element)).booleanValue()) {
                    return filtered.append(new Object[]{element});
                }
                return filtered;
            }
        });
    }

    @Override
    public IndexedSeq<T> filterNot(final Function1<T, Boolean> isOk) {
        return this.foldLeft(IndexedSeq.apply(new Object[0]), new FoldLeftF2<IndexedSeq<T>, T>(){

            @Override
            public IndexedSeq<T> apply(IndexedSeq<T> filtered, T element) throws Exception {
                if (!((Boolean)isOk.apply(element)).booleanValue()) {
                    return filtered.append(new Object[]{element});
                }
                return filtered;
            }
        });
    }

    @Override
    public Option<T> find(final Function1<T, Boolean> predicate) {
        return this.foldLeft(Option.none(), new FoldLeftF2<Option<T>, T>(){

            @Override
            public Option<T> apply(Option<T> found, T element) throws Exception {
                if (!found.isDefined() && ((Boolean)predicate.apply(element)).booleanValue()) {
                    return Option.apply(element);
                }
                return found;
            }
        });
    }

    @Override
    public <U> IndexedSeq<U> flatMap(final Function1<T, CollectionLike<U>> f) {
        return this.foldLeft(IndexedSeq.apply(new Object[0]), new FoldLeftF2<IndexedSeq<U>, T>(){

            @Override
            public IndexedSeq<U> apply(IndexedSeq<U> seq, T element) throws Exception {
                CollectionLike col = (CollectionLike)f.apply(element);
                return seq.union((Seq)IndexedSeq.apply(col.toList()));
            }
        });
    }

    @Override
    public <U> U foldLeft(U z, Function2<U, T, U> operator) {
        try {
            for (T element : this.list) {
                z = operator.apply(z, element);
            }
            return z;
        }
        catch (Throwable e) {
            throw new ScalaFlavor4JException(e);
        }
    }

    @Override
    public <U> Function1<Function2<U, T, U>, U> foldLeft(final U z) {
        return new F1<Function2<U, T, U>, U>(){

            @Override
            public U apply(Function2<U, T, U> operator) {
                try {
                    Object result = z;
                    for (Object element : IndexedSeq.this.list) {
                        result = operator.apply(result, element);
                    }
                    return result;
                }
                catch (Throwable e) {
                    throw new ScalaFlavor4JException(e);
                }
            }
        };
    }

    @Override
    public <U> U foldRight(U z, Function2<T, U, U> operator) {
        if (this.isEmpty()) {
            return this.NIL.foldRight(z, operator);
        }
        try {
            int lastIndex;
            for (int i = lastIndex = this.list.size() - 1; i >= 0; --i) {
                z = operator.apply(this.list.get(i), z);
            }
            return z;
        }
        catch (Throwable e) {
            throw new ScalaFlavor4JException(e);
        }
    }

    @Override
    public <U> Function1<Function2<T, U, U>, U> foldRight(final U z) {
        return new F1<Function2<T, U, U>, U>(){

            @Override
            public U apply(Function2<T, U, U> operator) {
                try {
                    int lastIndex;
                    Object result = z;
                    for (int i = lastIndex = IndexedSeq.this.list.size() - 1; i >= 0; --i) {
                        result = operator.apply(IndexedSeq.this.list.get(i), result);
                    }
                    return result;
                }
                catch (Throwable e) {
                    throw new ScalaFlavor4JException(e);
                }
            }
        };
    }

    @Override
    public boolean forall(Function1<T, Boolean> predicate) {
        return this.span(predicate)._2().size() == 0;
    }

    @Override
    public void foreach(VoidFunction1<T> f) {
        try {
            for (T element : this.list) {
                f.apply(element);
            }
        }
        catch (Throwable e) {
            throw new ScalaFlavor4JException(e);
        }
    }

    @Override
    public <U> SMap<U, Seq<T>> groupBy(final Function1<T, U> getGroupName) {
        if (this.isEmpty()) {
            return this.NIL.groupBy(getGroupName);
        }
        return this.foldLeft(SMap.apply(), new FoldLeftF2<SMap<U, Seq<T>>, T>(){

            @Override
            public SMap<U, Seq<T>> apply(SMap<U, Seq<T>> map, T element) throws Exception {
                Object groupName = getGroupName.apply(element);
                Seq<Object> groupMembers = map.getOrElse(groupName, Seq.apply(new Object[0]));
                return map.updated(groupName, groupMembers.append((Object[])new Object[]{element}));
            }
        });
    }

    @Override
    public T head() {
        if (this.isEmpty()) {
            return this.NIL.head();
        }
        return this.list.get(0);
    }

    @Override
    public Option<T> headOption() {
        return Option.apply(this.head());
    }

    @Override
    public int indexOf(final T elem) {
        if (this.isEmpty()) {
            return this.NIL.indexOf(elem);
        }
        int DEFAULT = -1;
        return SInt.apply(0).until(this.size()).foldLeft(-1, new FoldLeftF2<Integer, Integer>(){

            @Override
            public Integer apply(Integer found, Integer i) {
                Object element;
                if (found == -1 && (element = IndexedSeq.this.list.get(i)) != null && element.equals(elem)) {
                    return i;
                }
                return found;
            }
        });
    }

    @Override
    public Seq<Integer> indices() {
        return SInt.apply(0).until(this.size());
    }

    @Override
    public Seq<T> init() {
        if (this.isEmpty()) {
            return this.NIL.init();
        }
        return this.slice(0, this.size() - 1);
    }

    @Override
    public IndexedSeq<T> intersect(final Seq<T> that) {
        return this.flatMap((Function1)new FlatMapF1<T, T>(){

            @Override
            public CollectionLike<T> apply(T thisElement) {
                if (that.contains(thisElement)) {
                    return Option.apply(thisElement);
                }
                return Option.none();
            }
        });
    }

    @Override
    public boolean isDefinedAt(int idx) {
        if (this.isEmpty()) {
            return this.NIL.isDefinedAt(idx);
        }
        try {
            return this.list.get(idx) != null;
        }
        catch (IndexOutOfBoundsException e) {
            return false;
        }
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public T last() {
        if (this.isEmpty()) {
            return this.NIL.last();
        }
        return this.list.get(this.list.size() - 1);
    }

    @Override
    public Option<T> lastOption() {
        return Option.apply(this.last());
    }

    @Override
    public <U> IndexedSeq<U> map(final Function1<T, U> f) {
        return this.foldLeft(IndexedSeq.apply(new Object[0]), new FoldLeftF2<IndexedSeq<U>, T>(){

            @Override
            public IndexedSeq<U> apply(IndexedSeq<U> mapped, T element) throws Exception {
                return mapped.append(new Object[]{f.apply(element)});
            }
        });
    }

    @Override
    public SNum max() {
        if (this.isEmpty()) {
            return this.NIL.max();
        }
        try {
            return this.dropNull().foldLeft(SNum.apply(0), new FoldLeftF2<SNum, T>(){

                @Override
                public SNum apply(SNum max, T element) {
                    BigDecimal bd = new BigDecimal(element.toString());
                    if (max.toBigDecimal().compareTo(bd) == 1) {
                        return max;
                    }
                    return SNum.apply(bd);
                }
            });
        }
        catch (NumberFormatException e) {
            throw new UnsupportedOperationException("This operation is not supported.");
        }
    }

    @Override
    public SNum min() {
        if (this.isEmpty()) {
            return this.NIL.min();
        }
        try {
            return this.dropNull().foldLeft(SNum.apply(Integer.MAX_VALUE), new FoldLeftF2<SNum, T>(){

                @Override
                public SNum apply(SNum min, T v) {
                    BigDecimal bd = new BigDecimal(v.toString());
                    if (min.toBigDecimal().compareTo(bd) == -1) {
                        return min;
                    }
                    return SNum.apply(bd);
                }
            });
        }
        catch (NumberFormatException e) {
            throw new UnsupportedOperationException("This operation is not supported.");
        }
    }

    @Override
    public String mkString() {
        return this.mkString("", "", "");
    }

    @Override
    public String mkString(String sep) {
        return this.mkString("", sep, "");
    }

    @Override
    public String mkString(String start, final String sep, String end) {
        if (this.isEmpty()) {
            return this.NIL.mkString(start, sep, end);
        }
        final StringBuilder sb = new StringBuilder();
        sb.append(start);
        int lastIndex = this.list.size() - 1;
        SInt.apply(0).until(lastIndex).foreach((VoidFunction1<Integer>)new VoidF1<Integer>(){

            @Override
            public void apply(Integer i) {
                sb.append(IndexedSeq.this.list.get(i));
                sb.append(sep);
            }
        });
        sb.append(this.list.get(lastIndex));
        sb.append(end);
        return sb.toString();
    }

    @Override
    public IndexedSeq<T> padTo(int len, final T elem) {
        return this.union(SInt.apply(this.size()).until(len).map((Function1)new F1<Integer, T>(){

            @Override
            public T apply(Integer i) {
                return elem;
            }
        }));
    }

    @Override
    public ParSeq<T> par() {
        return ParSeq.apply(this.list);
    }

    @Override
    public Tuple2<Seq<T>, Seq<T>> partition(final Function1<T, Boolean> predicate) {
        return this.foldLeft(new PartitionZ(), new FoldLeftF2<PartitionZ, T>(){

            @Override
            public PartitionZ apply(PartitionZ z, T element) throws Exception {
                if (((Boolean)predicate.apply(element)).booleanValue()) {
                    return new PartitionZ(z.matched.append(element), z.unmatched);
                }
                return new PartitionZ(z.matched, z.unmatched.append(element));
            }
        }).toResult();
    }

    @Override
    public IndexedSeq<T> patch(int from, Seq<T> patch, int replaced) {
        Seq prefix = this.slice(0, from);
        Seq suffix = this.drop(from + replaced);
        return ((IndexedSeq)((IndexedSeq)prefix).union((Seq)patch)).union(suffix);
    }

    @Override
    public <U> U reduceLeft(final Function2<U, T, U> operator) {
        return this.foldLeft(null, new FoldLeftF2<U, T>(){

            @Override
            public U apply(U z, T element) throws Exception {
                return operator.apply(z, element);
            }
        });
    }

    @Override
    public <U> Option<U> reduceLeftOption(Function2<U, T, U> operator) {
        return Option.apply(this.reduceLeft(operator));
    }

    @Override
    public <U> U reduceRight(final Function2<T, U, U> operator) {
        return this.foldRight(null, new FoldRightF2<T, U>(){

            @Override
            public U apply(T element, U z) throws Exception {
                return operator.apply(element, z);
            }
        });
    }

    @Override
    public <U> Option<U> reduceRightOption(Function2<T, U, U> operator) {
        return Option.apply(this.reduceRight(operator));
    }

    @Override
    public IndexedSeq<T> reverse() {
        return this.foldRight(IndexedSeq.apply(new Object[0]), new FoldRightF2<T, IndexedSeq<T>>(){

            @Override
            public IndexedSeq<T> apply(T element, IndexedSeq<T> reversed) {
                return reversed.append(new Object[]{element});
            }
        });
    }

    @Override
    public <U> IndexedSeq<U> reverseMap(Function1<T, U> f) {
        return ((IndexedSeq)this.reverse()).map((Function1)f);
    }

    @Override
    public boolean sameElements(Seq<T> that) {
        if (this.isEmpty()) {
            return this.NIL.sameElements(that);
        }
        if (this.size() != that.size()) {
            return false;
        }
        return ((IndexedSeq)this.zip(that)).foldLeft(true, new FoldLeftF2<Boolean, Tuple2<T, T>>(){

            @Override
            public Boolean apply(Boolean sameElements, Tuple2<T, T> thisAndThat) {
                if (sameElements.booleanValue()) {
                    Object thisOne = thisAndThat._1();
                    Object thatOne = thisAndThat._2();
                    if (thisOne == null && thatOne == null) {
                        return true;
                    }
                    if (!thisOne.equals(thatOne)) {
                        return false;
                    }
                }
                return sameElements;
            }
        });
    }

    @Override
    public <U> IndexedSeq<U> scanLeft(U z, final Function2<U, T, U> operator) {
        return this.foldLeft(IndexedSeq.apply(z), new FoldLeftF2<IndexedSeq<U>, T>(){

            @Override
            public IndexedSeq<U> apply(IndexedSeq<U> scanResult, T element) throws Exception {
                Object result = operator.apply(scanResult.last(), element);
                return scanResult.append(new Object[]{result});
            }
        });
    }

    @Override
    public <U> Function1<Function2<U, T, U>, Seq<U>> scanLeft(final U z) {
        return new F1<Function2<U, T, U>, Seq<U>>(){

            @Override
            public Seq<U> apply(final Function2<U, T, U> operator) throws Exception {
                return IndexedSeq.this.foldLeft(IndexedSeq.apply(z), new FoldLeftF2<IndexedSeq<U>, T>(){

                    @Override
                    public IndexedSeq<U> apply(IndexedSeq<U> scanResult, T element) throws Exception {
                        Object result = operator.apply(scanResult.last(), element);
                        return scanResult.append(new Object[]{result});
                    }
                });
            }
        };
    }

    @Override
    public <U> IndexedSeq<U> scanRight(U z, final Function2<T, U, U> operator) {
        return this.foldRight(IndexedSeq.apply(z), new FoldRightF2<T, IndexedSeq<U>>(){

            @Override
            public IndexedSeq<U> apply(T element, IndexedSeq<U> scanResult) throws Exception {
                Object result = operator.apply(element, scanResult.last());
                return scanResult.append(new Object[]{result});
            }
        }).reverse();
    }

    @Override
    public <U> Function1<Function2<T, U, U>, Seq<U>> scanRight(final U z) {
        return new F1<Function2<T, U, U>, Seq<U>>(){

            @Override
            public Seq<U> apply(final Function2<T, U, U> operator) throws Exception {
                return IndexedSeq.this.foldRight(IndexedSeq.apply(z), new FoldRightF2<T, IndexedSeq<U>>(){

                    @Override
                    public IndexedSeq<U> apply(T element, IndexedSeq<U> scanResult) throws Exception {
                        Object result = operator.apply(element, scanResult.last());
                        return scanResult.append(new Object[]{result});
                    }
                }).reverse();
            }
        };
    }

    @Override
    public int size() {
        if (this.list.size() == 1 && this.list.get(0) instanceof Seq) {
            Seq head = (Seq)this.list.get(0);
            return head.isEmpty() ? 0 : 1;
        }
        return this.list.size();
    }

    @Override
    public IndexedSeq<T> slice(int from, int until) {
        if (from >= this.size()) {
            return IndexedSeq.apply(new Object[0]);
        }
        if (until > this.size()) {
            until = this.size();
        }
        return SInt.apply(from).until(until).foldLeft(IndexedSeq.apply(new Object[0]), new FoldLeftF2<IndexedSeq<T>, Integer>(){

            @Override
            public IndexedSeq<T> apply(IndexedSeq<T> sliced, Integer i) {
                return sliced.append(new Object[]{IndexedSeq.this.list.get(i)});
            }
        });
    }

    @Override
    public IndexedSeq<Seq<T>> sliding(int size) {
        return this.sliding(size, 1);
    }

    @Override
    public IndexedSeq<Seq<T>> sliding(final int blockSize, int step) {
        if (this.isEmpty()) {
            return IndexedSeq.apply(new Seq[0]);
        }
        final int thisAllSize = this.size();
        int finalStartIdx = thisAllSize - 1;
        if (blockSize >= thisAllSize) {
            finalStartIdx = 0;
        } else if (step == 1 || thisAllSize % blockSize == step) {
            finalStartIdx = thisAllSize - blockSize;
        }
        IndexedSeq<Integer> blockStartIndices = SInt.apply(0).to(finalStartIdx, step);
        return (IndexedSeq)((Seq)blockStartIndices).map(new F1<Integer, Seq<T>>(){

            @Override
            public Seq<T> apply(Integer startIdx) {
                int lastIdx = startIdx + blockSize - 1;
                Seq indicesInBlock = SInt.apply(startIdx).to(lastIdx).filter(new PredicateF1<Integer>(){

                    @Override
                    public Boolean apply(Integer idx) {
                        return idx < thisAllSize;
                    }
                });
                return indicesInBlock.foldLeft(IndexedSeq.apply(new Object[0]), new FoldLeftF2<IndexedSeq<T>, Integer>(){

                    @Override
                    public IndexedSeq<T> apply(IndexedSeq<T> seq, Integer idx) {
                        return seq.append(new Object[]{IndexedSeq.this.list.get(idx)});
                    }
                });
            }
        });
    }

    @Override
    public IndexedSeq<T> sortWith(final Function2<T, T, Boolean> lessThan) {
        List copied = this.foldLeft(new ArrayList(), new FoldLeftF2<List<T>, T>(){

            @Override
            public List<T> apply(List<T> copied, T element) {
                copied.add(element);
                return copied;
            }
        });
        Collections.sort(copied, new Comparator<T>(){

            @Override
            public int compare(T o1, T o2) {
                try {
                    if (((Boolean)lessThan.apply(o1, o2)).booleanValue()) {
                        return -1;
                    }
                    if (((Boolean)lessThan.apply(o2, o1)).booleanValue()) {
                        return 1;
                    }
                    return 0;
                }
                catch (Throwable e) {
                    throw new ScalaFlavor4JException(e);
                }
            }
        });
        return IndexedSeq.apply(copied);
    }

    @Override
    public Tuple2<Seq<T>, Seq<T>> span(final Function1<T, Boolean> predicate) {
        return this.foldLeft(new SpanZ(), new FoldLeftF2<SpanZ, T>(){

            @Override
            public SpanZ apply(SpanZ z, T element) throws Exception {
                if (z.unmatchFound.booleanValue()) {
                    return new SpanZ(z.unmatchFound, z.stillMatched, z.others.append(element));
                }
                if (!((Boolean)predicate.apply(element)).booleanValue()) {
                    return new SpanZ(true, z.stillMatched, z.others.append(element));
                }
                return new SpanZ(z.unmatchFound, z.stillMatched.append(element), z.others);
            }
        }).toResult();
    }

    @Override
    public Tuple2<Seq<T>, Seq<T>> splitAt(int n) {
        return Tuple.apply(this.take(n), this.drop(n));
    }

    @Override
    public boolean startsWith(Seq<T> that) {
        return this.startsWith(that, 0);
    }

    @Override
    public boolean startsWith(final Seq<T> that, final int offset) {
        if (this.isEmpty()) {
            return this.NIL.startsWith(that, offset);
        }
        int max = offset + that.size();
        if (max > this.size()) {
            return false;
        }
        return SInt.apply(offset).until(max).foldLeft(true, new FoldLeftF2<Boolean, Integer>(){

            @Override
            public Boolean apply(Boolean stillSame, Integer i) {
                if (stillSame.booleanValue()) {
                    Object thisOne = IndexedSeq.this.list.get(i);
                    Object thatOne = that.toList().get(i - offset);
                    if (thisOne == null) {
                        return thatOne == null;
                    }
                    return thisOne.equals(thatOne);
                }
                return false;
            }
        });
    }

    @Override
    public SNum sum() {
        if (this.isEmpty()) {
            return this.NIL.sum();
        }
        try {
            return this.dropNull().foldLeft(SNum.apply(0), new FoldLeftF2<SNum, T>(){

                @Override
                public SNum apply(SNum sum, T element) {
                    BigDecimal added = sum.toBigDecimal().add(new BigDecimal(element.toString()));
                    return SNum.apply(added);
                }
            });
        }
        catch (NumberFormatException e) {
            throw new UnsupportedOperationException("This operation is not supported.");
        }
    }

    @Override
    public IndexedSeq<T> tail() {
        return this.slice(1, this.size());
    }

    @Override
    public IndexedSeq<T> take(int n) {
        return this.slice(0, n);
    }

    @Override
    public IndexedSeq<T> takeRight(int n) {
        return ((IndexedSeq)((IndexedSeq)this.reverse()).take(n)).reverse();
    }

    @Override
    public IndexedSeq<T> takeWhile(Function1<T, Boolean> predicate) {
        if (this.isEmpty()) {
            return IndexedSeq.apply(new Object[0]);
        }
        return (IndexedSeq)this.span(predicate)._1();
    }

    @Override
    public List<T> toList() {
        return this.list;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Seq(");
        sb.append(this.mkString(","));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public IndexedSeq<T> union(Seq<T> that) {
        List<T> list = this.toList();
        list.addAll(that.toList());
        return IndexedSeq.apply(list);
    }

    @Override
    public Seq<T> updated(int index, T elem) {
        if (this.isEmpty()) {
            return this.NIL.updated(index, elem);
        }
        Seq prefix = this.slice(0, index);
        Seq suffix = this.drop(index + 1);
        return prefix.append(elem).union(suffix);
    }

    @Override
    public <U> IndexedSeq<Tuple2<T, U>> zip(final Seq<U> that) {
        IndexedSeq<Integer> indices;
        int len = this.size();
        if (this.size() > that.size()) {
            len = that.size();
        }
        if ((indices = SInt.apply(0).until(len)).isEmpty()) {
            return IndexedSeq.apply(new Object[0]);
        }
        return (IndexedSeq)((Seq)indices).map(new F1<Integer, Tuple2<T, U>>(){

            @Override
            public Tuple2<T, U> apply(Integer i) {
                return Tuple.apply(IndexedSeq.this.toList().get(i), that.toList().get(i));
            }
        });
    }

    @Override
    public IndexedSeq<Tuple2<T, Integer>> zipWithIndex() {
        return this.zip(this.indices());
    }

    @Override
    public Seq<T> transpose() {
        IndexedSeq xss = this;
        int headSize = ((Seq)((Seq)xss).head()).size();
        ArrayList matrix = new ArrayList();
        for (int i = 0; i < headSize; ++i) {
            ArrayList row = new ArrayList();
            for (Seq seq : xss.toList()) {
                row.add(seq.toList().get(i));
            }
            matrix.add(row);
        }
        return Seq.apply(matrix).map(new F1<List<?>, Seq<?>>(){

            @Override
            public Seq<?> apply(List<?> row) throws Exception {
                return Seq.apply(row);
            }
        });
    }

    private class SpanZ {
        Boolean unmatchFound;
        Seq<T> stillMatched;
        Seq<T> others;

        public SpanZ() {
            this.unmatchFound = false;
            this.stillMatched = IndexedSeq.apply(new Object[0]);
            this.others = IndexedSeq.apply(new Object[0]);
        }

        public SpanZ(Boolean unmatchFound, Seq<T> stillMatched, Seq<T> others) {
            this.unmatchFound = unmatchFound;
            this.stillMatched = stillMatched;
            this.others = others;
        }

        public Pair<Seq<T>, Seq<T>> toResult() {
            return Pair.apply(this.stillMatched, this.others);
        }
    }

    private class PartitionZ {
        Seq<T> matched;
        Seq<T> unmatched;

        public PartitionZ() {
            this.matched = IndexedSeq.apply(new Object[0]);
            this.unmatched = IndexedSeq.apply(new Object[0]);
        }

        public PartitionZ(Seq<T> matched, Seq<T> unmatched) {
            this.matched = matched;
            this.unmatched = unmatched;
        }

        public Tuple2<Seq<T>, Seq<T>> toResult() {
            return Tuple.apply(this.matched, this.unmatched);
        }
    }
}

