/*
 * Decompiled with CFR 0.152.
 */
package com.m3.scalaflavor4j;

import com.m3.scalaflavor4j.Either;
import com.m3.scalaflavor4j.Function1;
import com.m3.scalaflavor4j.Left;
import com.m3.scalaflavor4j.Option;
import com.m3.scalaflavor4j.ScalaFlavor4JException;

public class Right<L, R>
extends Either<L, R> {
    private Option<R> value;

    public static <L, R> Either<L, R> apply(R value) {
        return new Right<L, R>(value);
    }

    public static <L, R> Either<L, R> apply(Option<R> value) {
        return new Right<L, R>(value);
    }

    public Right(R value) {
        this.value = Option.apply(value);
    }

    public Right(Option<R> value) {
        this.value = value;
    }

    @Override
    public boolean isLeft() {
        return false;
    }

    @Override
    public boolean isRight() {
        return true;
    }

    @Override
    public Option<L> left() {
        return Option.none();
    }

    @Override
    public Option<R> right() {
        return this.value;
    }

    @Override
    public Either<R, L> swap() {
        return new Left(this.value);
    }

    public String toString() {
        return "Right(" + this.value.getOrNull() + ")";
    }

    @Override
    public L mergeToLeft(Function1<R, L> rightToLeft) {
        try {
            return rightToLeft.apply(this.value.getOrNull());
        }
        catch (Throwable t) {
            throw new ScalaFlavor4JException(t);
        }
    }

    @Override
    public R mergeToRight(Function1<L, R> leftToRight) {
        return this.value.getOrNull();
    }
}

