/*
 * Decompiled with CFR 0.152.
 */
package com.m3.scalaflavor4j;

import com.m3.scalaflavor4j.F1;
import com.m3.scalaflavor4j.F2;
import com.m3.scalaflavor4j.Function1;
import com.m3.scalaflavor4j.PredicateF1;
import com.m3.scalaflavor4j.Seq;
import com.m3.scalaflavor4j.Tuple;
import com.m3.scalaflavor4j.Tuple2;
import com.m3.scalaflavor4j.VoidF1;
import com.m3.scalaflavor4j.VoidFunction1;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class SMap<K, V> {
    private final Map<K, V> map;

    private SMap() {
        this.map = new ConcurrentHashMap();
    }

    private SMap(Map<K, V> map) {
        this.map = map;
    }

    public static <K, V> SMap<K, V> apply() {
        return new SMap<K, V>();
    }

    public static <K, V> SMap<K, V> apply(Map<K, V> map) {
        return new SMap<K, V>(map);
    }

    public static <K, V> SMap<K, V> apply(Seq<Tuple2<K, V>> tuples) {
        Map map = tuples.foldLeft(new ConcurrentHashMap(), new F2<Map<K, V>, Tuple2<K, V>, Map<K, V>>(){

            @Override
            public Map<K, V> apply(Map<K, V> map, Tuple2<K, V> tuple) {
                map.put(tuple._1(), tuple._2());
                return map;
            }
        });
        return SMap.apply(map);
    }

    public V apply(K key) {
        return this.map.get(key);
    }

    public Map<K, V> toMap() {
        return this.map;
    }

    public List<Tuple2<K, V>> toList() {
        ArrayList<Tuple2<K, V>> list = new ArrayList<Tuple2<K, V>>();
        Set<K> keys = this.map.keySet();
        for (K key : keys) {
            list.add(Tuple.apply(key, this.map.get(key)));
        }
        return list;
    }

    public SMap<K, V> copy() {
        return this.map(new F1<Tuple2<K, V>, Tuple2<K, V>>(){

            @Override
            public Tuple2<K, V> apply(Tuple2<K, V> e) {
                return e;
            }
        });
    }

    public Seq<Tuple2<K, V>> toSeq() {
        return Seq.apply(this.toList());
    }

    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    public Iterator<Tuple2<K, V>> iterator() {
        return this.toList().iterator();
    }

    public V getOrElse(K key, V defaultValue) {
        if (key == null) {
            return defaultValue;
        }
        V value = this.map.get(key);
        if (value == null) {
            return defaultValue;
        }
        return value;
    }

    public SMap<K, V> filter(final Function1<Tuple2<K, V>, Boolean> f) {
        Map map = this.toSeq().foldLeft(new ConcurrentHashMap(), new F2<Map<K, V>, Tuple2<K, V>, Map<K, V>>(){

            @Override
            public Map<K, V> apply(Map<K, V> map, Tuple2<K, V> tuple) throws Exception {
                if (((Boolean)f.apply(tuple)).booleanValue()) {
                    map.put(tuple._1(), tuple._2());
                }
                return map;
            }
        });
        return SMap.apply(map);
    }

    public void foreach(VoidFunction1<Tuple2<K, V>> f) {
        this.toSeq().foreach(f);
    }

    public <L, M> SMap<L, M> map(final Function1<Tuple2<K, V>, Tuple2<L, M>> f) {
        Map map = this.toSeq().foldLeft(new ConcurrentHashMap(), new F2<Map<L, M>, Tuple2<K, V>, Map<L, M>>(){

            @Override
            public Map<L, M> apply(Map<L, M> map, Tuple2<K, V> tuple) throws Exception {
                Tuple2 mapped = (Tuple2)f.apply(tuple);
                map.put(mapped._1(), mapped._2());
                return map;
            }
        });
        return SMap.apply(map);
    }

    public SMap<K, V> minus(K ... keys) {
        final SMap<K, V> copied = this.copy();
        Seq.apply(keys).dropNull().foreach(new VoidF1<K>(){

            @Override
            public void apply(K key) {
                copied.toMap().remove(key);
            }
        });
        return copied;
    }

    public SMap<K, V> plus(Tuple2<K, V> ... elems) {
        final SMap<K, V> copied = this.copy();
        Seq.apply(elems).dropNull().filter(new PredicateF1<Tuple2<K, V>>(){

            @Override
            public Boolean apply(Tuple2<K, V> elem) {
                return elem._1() != null && elem._2() != null;
            }
        }).foreach(new VoidF1<Tuple2<K, V>>(){

            @Override
            public void apply(Tuple2<K, V> elem) {
                copied.toMap().put(elem._1(), elem._2());
            }
        });
        return copied;
    }

    public SMap<K, V> updated(K key, V value) {
        SMap<K, V> copied = this.copy();
        if (key != null && value != null) {
            copied.toMap().put(key, value);
        }
        return copied;
    }

    public Tuple2<Seq<K>, Seq<V>> unzip() {
        final ArrayList ks = new ArrayList();
        final ArrayList vs = new ArrayList();
        this.toSeq().foreach(new VoidF1<Tuple2<K, V>>(){

            @Override
            public void apply(Tuple2<K, V> tuple) {
                ks.add(tuple._1());
                vs.add(tuple._2());
            }
        });
        return Tuple.apply(Seq.apply(ks), Seq.apply(vs));
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("SMap(");
        sb.append(this.toSeq().map(new F1<Tuple2<K, V>, String>(){

            @Override
            public String apply(Tuple2<K, V> e) {
                return e._1() + " -> " + e._2();
            }
        }).mkString(", "));
        sb.append(")");
        return sb.toString();
    }
}

