/*
 * Decompiled with CFR 0.152.
 */
package com.m3.scalaflavor4j;

import com.m3.scalaflavor4j.CollectionLike;
import com.m3.scalaflavor4j.Function1;
import com.m3.scalaflavor4j.Function2;
import com.m3.scalaflavor4j.IndexedSeq;
import com.m3.scalaflavor4j.Nil;
import com.m3.scalaflavor4j.Option;
import com.m3.scalaflavor4j.ParSeq;
import com.m3.scalaflavor4j.SMap;
import com.m3.scalaflavor4j.SNum;
import com.m3.scalaflavor4j.Tuple2;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;

public abstract class Seq<T>
implements CollectionLike<T> {
    private static final long serialVersionUID = 1L;

    public static <T> Seq<T> apply(T ... values) {
        ArrayList<T> list = new ArrayList<T>();
        if (values != null) {
            for (T value : values) {
                list.add(value);
            }
        }
        return Seq.applyCollection(list);
    }

    public static <T> Seq<T> apply(Enumeration<T> e) {
        if (e == null) {
            return Nil.apply();
        }
        ArrayList<T> col = new ArrayList<T>();
        while (e.hasMoreElements()) {
            col.add(e.nextElement());
        }
        return Seq.applyCollection(col);
    }

    public static <T> Seq<T> apply(Iterator<T> iter) {
        if (iter == null) {
            return Nil.apply();
        }
        ArrayList<T> col = new ArrayList<T>();
        while (iter.hasNext()) {
            col.add(iter.next());
        }
        return Seq.applyCollection(col);
    }

    public static <T> Seq<T> apply(Iterable<T> iterable) {
        if (iterable == null) {
            return Nil.apply();
        }
        return Seq.apply(iterable.iterator());
    }

    protected static <T> Seq<T> applyCollection(Collection<T> col) {
        if (col == null || col.size() == 0) {
            return Nil.apply();
        }
        return IndexedSeq.apply(new ArrayList<T>(col));
    }

    public abstract Seq<T> append(T ... var1);

    public abstract boolean contains(T var1);

    public abstract <U> boolean corresponds(Seq<U> var1, Function2<T, U, Boolean> var2);

    public abstract <U> Function1<Function2<T, U, Boolean>, Boolean> corresponds(Seq<U> var1);

    public abstract int count(Function1<T, Boolean> var1);

    public abstract Seq<T> diff(Seq<T> var1);

    public abstract Seq<T> distinct();

    public abstract Seq<T> drop(int var1);

    public abstract Seq<T> dropNull();

    public abstract Seq<T> dropRight(int var1);

    public abstract Seq<T> dropWhile(Function1<T, Boolean> var1);

    public abstract boolean endsWith(Seq<T> var1);

    public abstract boolean exists(Function1<T, Boolean> var1);

    public abstract Seq<T> filter(Function1<T, Boolean> var1);

    public abstract Seq<T> filterNot(Function1<T, Boolean> var1);

    public abstract Option<T> find(Function1<T, Boolean> var1);

    public abstract <U> Seq<U> flatMap(Function1<T, CollectionLike<U>> var1);

    public abstract <U> U foldLeft(U var1, Function2<U, T, U> var2);

    public abstract <U> Function1<Function2<U, T, U>, U> foldLeft(U var1);

    public abstract <U> U foldRight(U var1, Function2<T, U, U> var2);

    public abstract <U> Function1<Function2<T, U, U>, U> foldRight(U var1);

    public abstract boolean forall(Function1<T, Boolean> var1);

    public abstract <U> SMap<U, Seq<T>> groupBy(Function1<T, U> var1);

    public abstract T head();

    public abstract Option<T> headOption();

    public abstract int indexOf(T var1);

    public abstract Seq<Integer> indices();

    public abstract Seq<T> init();

    public abstract Seq<T> intersect(Seq<T> var1);

    public abstract boolean isDefinedAt(int var1);

    public abstract T last();

    public abstract Option<T> lastOption();

    public abstract <U> Seq<U> map(Function1<T, U> var1);

    public abstract SNum max();

    public abstract SNum min();

    public abstract String mkString();

    public abstract String mkString(String var1);

    public abstract String mkString(String var1, String var2, String var3);

    public abstract Seq<T> padTo(int var1, T var2);

    public abstract ParSeq<T> par();

    public abstract Tuple2<Seq<T>, Seq<T>> partition(Function1<T, Boolean> var1);

    public abstract Seq<T> patch(int var1, Seq<T> var2, int var3);

    public abstract <U> U reduceLeft(Function2<U, T, U> var1);

    public abstract <U> Option<U> reduceLeftOption(Function2<U, T, U> var1);

    public abstract <U> U reduceRight(Function2<T, U, U> var1);

    public abstract <U> Option<U> reduceRightOption(Function2<T, U, U> var1);

    public abstract Seq<T> reverse();

    public abstract <U> Seq<U> reverseMap(Function1<T, U> var1);

    public abstract boolean sameElements(Seq<T> var1);

    public abstract <U> Seq<U> scanLeft(U var1, Function2<U, T, U> var2);

    public abstract <U> Function1<Function2<U, T, U>, Seq<U>> scanLeft(U var1);

    public abstract <U> Seq<U> scanRight(U var1, Function2<T, U, U> var2);

    public abstract <U> Function1<Function2<T, U, U>, Seq<U>> scanRight(U var1);

    public abstract int size();

    public abstract Seq<T> slice(int var1, int var2);

    public abstract Seq<Seq<T>> sliding(int var1);

    public abstract Seq<Seq<T>> sliding(int var1, int var2);

    public abstract Seq<T> sortWith(Function2<T, T, Boolean> var1);

    public abstract Tuple2<Seq<T>, Seq<T>> span(Function1<T, Boolean> var1);

    public abstract Tuple2<Seq<T>, Seq<T>> splitAt(int var1);

    public abstract boolean startsWith(Seq<T> var1);

    public abstract boolean startsWith(Seq<T> var1, int var2);

    public abstract SNum sum();

    public abstract Seq<T> tail();

    public abstract Seq<T> take(int var1);

    public abstract Seq<T> takeRight(int var1);

    public abstract Seq<T> takeWhile(Function1<T, Boolean> var1);

    public abstract Seq<T> transpose();

    public abstract Seq<T> union(Seq<T> var1);

    public abstract Seq<T> updated(int var1, T var2);

    public abstract <U> Seq<Tuple2<T, U>> zip(Seq<U> var1);

    public abstract Seq<Tuple2<T, Integer>> zipWithIndex();
}

