/*
 * Decompiled with CFR 0.152.
 */
package com.m3.scalaflavor4j;

import com.m3.scalaflavor4j.F1;
import com.m3.scalaflavor4j.Function1;
import com.m3.scalaflavor4j.Option;
import com.m3.scalaflavor4j.ScalaFlavor4JException;
import com.m3.scalaflavor4j.VoidFunction1;
import java.util.ArrayList;
import java.util.List;

public class Some<T>
extends Option<T> {
    private static final long serialVersionUID = 1L;
    private final T value;

    public Some(T value) {
        this.value = value;
    }

    @Override
    public List<T> toList() {
        ArrayList<T> list = new ArrayList<T>();
        list.add(this.value);
        return list;
    }

    @Override
    public T getOrNull() {
        return this.value;
    }

    @Override
    public T getOrElse(T defaultValue) {
        return this.value;
    }

    @Override
    public boolean isDefined() {
        return this.value != null;
    }

    @Override
    public boolean isEmpty() {
        return !this.isDefined();
    }

    public boolean equals(Object obj) {
        if (obj instanceof Option) {
            Option opt = (Option)obj;
            return opt.isDefined() && opt.getOrNull().equals(this.value);
        }
        return false;
    }

    public String toString() {
        return "Some(" + this.value + ")";
    }

    public int hashCode() {
        if (this.value != null) {
            return this.value.hashCode();
        }
        return 0;
    }

    @Override
    public <U> Option<U> map(Function1<T, U> f) {
        try {
            return Option.apply(f.apply(this.value));
        }
        catch (Throwable e) {
            throw new ScalaFlavor4JException(e);
        }
    }

    @Override
    public void foreach(VoidFunction1<T> f) {
        try {
            f.apply(this.value);
        }
        catch (Throwable e) {
            throw new ScalaFlavor4JException(e);
        }
    }

    @Override
    public Option<T> filter(Function1<T, Boolean> f) {
        try {
            if (f.apply(this.value).booleanValue()) {
                return this;
            }
            return Option.none();
        }
        catch (Throwable e) {
            throw new ScalaFlavor4JException(e);
        }
    }

    @Override
    public <U> Option<U> flatMap(Function1<T, Option<U>> f) {
        try {
            if (this.isDefined()) {
                return f.apply(this.value);
            }
            return Option.none();
        }
        catch (Throwable e) {
            throw new ScalaFlavor4JException(e);
        }
    }

    @Override
    public <U> U fold(U ifEmpty, Function1<T, U> f) {
        try {
            if (this.isEmpty()) {
                return ifEmpty;
            }
            return f.apply(this.getOrNull());
        }
        catch (Throwable e) {
            throw new ScalaFlavor4JException(e);
        }
    }

    @Override
    public <U> Function1<Function1<T, U>, U> fold(final U ifEmpty) {
        return new F1<Function1<T, U>, U>(){

            @Override
            public U apply(Function1<T, U> f) throws Exception {
                if (Some.this.isEmpty()) {
                    return ifEmpty;
                }
                return f.apply(Some.this.getOrNull());
            }
        };
    }
}

