/*
 * Decompiled with CFR 0.152.
 */
package com.m3.scalaflavor4j.arm;

import com.m3.scalaflavor4j.CollectionLike;
import com.m3.scalaflavor4j.Function1;
import com.m3.scalaflavor4j.ScalaFlavor4JException;
import com.m3.scalaflavor4j.VoidFunction1;
import com.m3.scalaflavor4j.arm.Resource;
import java.util.Arrays;
import java.util.List;

public class ManagedResource<R>
implements CollectionLike<R> {
    private static final long serialVersionUID = 1L;
    private final Resource resource;

    public ManagedResource(Resource resource) {
        this.resource = resource;
    }

    public <B> B map(Function1<R, B> f) {
        try {
            B b = f.apply(this.resource.getResource());
            return b;
        }
        catch (Throwable e) {
            throw new ScalaFlavor4JException(e);
        }
        finally {
            this.resource.close();
        }
    }

    @Override
    public void foreach(VoidFunction1<R> f) {
        try {
            f.apply(this.resource.getResource());
        }
        catch (Throwable e) {
            throw new ScalaFlavor4JException(e);
        }
        finally {
            this.resource.close();
        }
    }

    @Override
    public List<R> toList() {
        return Arrays.asList(this.resource.getResource());
    }

    @Override
    public boolean isEmpty() {
        return this.resource == null || this.resource.getResource() == null;
    }
}

