/*
 * Decompiled with CFR 0.152.
 */
package com.m3.scalaflavor4j.arm;

import com.m3.scalaflavor4j.ExceptionControl;
import com.m3.scalaflavor4j.F0;
import com.m3.scalaflavor4j.F1;
import com.m3.scalaflavor4j.Function0;
import com.m3.scalaflavor4j.ScalaFlavor4JException;
import com.m3.scalaflavor4j.arm.ManagedResource;
import java.io.IOException;
import java.lang.reflect.Method;

public class Resource {
    private Object closable;

    public Resource(Object closable) {
        this.closable = closable;
    }

    public Object getResource() {
        return this.closable;
    }

    public void close() {
        try {
            Method close = null;
            for (Class<?> clazz = this.closable.getClass(); clazz != Object.class; clazz = clazz.getSuperclass()) {
                try {
                    close = clazz.getDeclaredMethod("close", null);
                    break;
                }
                catch (Throwable throwable) {
                    continue;
                }
            }
            if (close != null) {
                close.setAccessible(true);
                close.invoke(this.closable, (Object[])null);
            }
        }
        catch (Throwable e) {
            throw new ScalaFlavor4JException(e);
        }
    }

    static void ensureClosable(final Object closable) throws IOException {
        try {
            ExceptionControl.catching(SecurityException.class, NoSuchMethodException.class).withApply(new F1<Throwable, Object>(){

                @Override
                public Object apply(Throwable t) throws Exception {
                    throw new IllegalArgumentException(closable.getClass().getCanonicalName() + " does not have close method.");
                }
            }).apply((Function0<Object>)new F0<Object>(){

                @Override
                public Object apply() throws SecurityException, NoSuchMethodException {
                    boolean isCloseMethodFound = false;
                    for (Class<?> clazz = closable.getClass(); clazz != Object.class; clazz = clazz.getSuperclass()) {
                        try {
                            clazz.getDeclaredMethod("close", null);
                            isCloseMethodFound = true;
                            break;
                        }
                        catch (Throwable throwable) {
                            continue;
                        }
                    }
                    if (isCloseMethodFound) {
                        return closable;
                    }
                    throw new IllegalArgumentException();
                }
            });
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    public static <R> ManagedResource<R> managed(R closable) throws IOException {
        Resource.ensureClosable(closable);
        return new ManagedResource(new Resource(closable));
    }
}

