/*
 * Decompiled with CFR 0.152.
 */
package com.macasaet.fernet;

import com.macasaet.fernet.Constants;
import com.macasaet.fernet.IllegalTokenException;
import com.macasaet.fernet.Key;
import com.macasaet.fernet.TokenExpiredException;
import com.macasaet.fernet.TokenValidationException;
import com.macasaet.fernet.Validator;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.SecureRandom;
import java.time.Instant;
import java.util.Base64;
import java.util.Collection;
import javax.crypto.spec.IvParameterSpec;

public class Token {
    private final byte version;
    private final Instant timestamp;
    private final IvParameterSpec initializationVector;
    private final byte[] cipherText;
    private final byte[] hmac;

    protected Token(byte version, Instant timestamp, IvParameterSpec initializationVector, byte[] cipherText, byte[] hmac) {
        if (version != -128) {
            throw new IllegalTokenException("Unsupported version: " + version);
        }
        if (timestamp == null) {
            throw new IllegalTokenException("timestamp cannot be null");
        }
        if (initializationVector == null || initializationVector.getIV().length != 16) {
            throw new IllegalTokenException("Initialization Vector must be 128 bits");
        }
        if (cipherText == null || cipherText.length % 16 != 0) {
            throw new IllegalTokenException("Ciphertext must be a multiple of 128 bits");
        }
        if (hmac == null || hmac.length != 32) {
            throw new IllegalTokenException("hmac must be 256 bits");
        }
        this.version = version;
        this.timestamp = timestamp;
        this.initializationVector = initializationVector;
        this.cipherText = cipherText;
        this.hmac = hmac;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static Token fromBytes(byte[] bytes) {
        if (bytes.length < 73) {
            throw new IllegalTokenException("Not enough bits to generate a Token");
        }
        try (ByteArrayInputStream inputStream = new ByteArrayInputStream(bytes);){
            Token token;
            try (DataInputStream dataStream = new DataInputStream(inputStream);){
                byte version = dataStream.readByte();
                long timestampSeconds = dataStream.readLong();
                byte[] initializationVector = Token.read(dataStream, 16);
                byte[] cipherText = Token.read(dataStream, bytes.length - 57);
                byte[] hmac = Token.read(dataStream, 32);
                if (dataStream.read() != -1) {
                    throw new IllegalTokenException("more bits found");
                }
                token = new Token(version, Instant.ofEpochSecond(timestampSeconds), new IvParameterSpec(initializationVector), cipherText, hmac);
            }
            return token;
        }
        catch (IOException ioe) {
            throw new IllegalStateException(ioe.getMessage(), ioe);
        }
    }

    protected static byte[] read(DataInputStream stream, int numBytes) throws IOException {
        byte[] retval = new byte[numBytes];
        int bytesRead = stream.read(retval);
        if (bytesRead < numBytes) {
            throw new IllegalTokenException("Not enough bits to generate a Token");
        }
        return retval;
    }

    public static Token fromString(String string) {
        return Token.fromBytes(Constants.decoder.decode(string));
    }

    public static Token generate(Key key, String plainText) {
        return Token.generate(new SecureRandom(), key, plainText);
    }

    public static Token generate(SecureRandom random, Key key, String plainText) {
        return Token.generate(random, key, plainText.getBytes(Constants.charset));
    }

    public static Token generate(Key key, byte[] payload) {
        return Token.generate(new SecureRandom(), key, payload);
    }

    public static Token generate(SecureRandom random, Key key, byte[] payload) {
        IvParameterSpec initializationVector = Token.generateInitializationVector(random);
        byte[] cipherText = key.encrypt(payload, initializationVector);
        Instant timestamp = Instant.now();
        byte[] hmac = key.sign((byte)-128, timestamp, initializationVector, cipherText);
        return new Token(-128, timestamp, initializationVector, cipherText, hmac);
    }

    public <T> T validateAndDecrypt(Key key, Validator<T> validator) {
        return validator.validateAndDecrypt(key, this);
    }

    public <T> T validateAndDecrypt(Collection<? extends Key> keys, Validator<T> validator) {
        return validator.validateAndDecrypt(keys, this);
    }

    protected byte[] validateAndDecrypt(Key key, Instant earliestValidInstant, Instant latestValidInstant) {
        if (this.getVersion() != -128) {
            throw new TokenValidationException("Invalid version");
        }
        if (!this.getTimestamp().isAfter(earliestValidInstant)) {
            throw new TokenExpiredException("Token is expired");
        }
        if (!this.getTimestamp().isBefore(latestValidInstant)) {
            throw new TokenValidationException("Token timestamp is in the future (clock skew).");
        }
        if (!this.isValidSignature(key)) {
            throw new TokenValidationException("Signature does not match.");
        }
        return key.decrypt(this.getCipherText(), this.getInitializationVector());
    }

    public String serialise() {
        String string;
        ByteArrayOutputStream byteStream = new ByteArrayOutputStream(57 + this.getCipherText().length);
        try {
            this.writeTo(byteStream);
            string = this.getEncoder().encodeToString(byteStream.toByteArray());
        }
        catch (Throwable throwable) {
            try {
                try {
                    byteStream.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new IllegalStateException(e.getMessage(), e);
            }
        }
        byteStream.close();
        return string;
    }

    public void writeTo(OutputStream outputStream) throws IOException {
        try (DataOutputStream dataStream = new DataOutputStream(outputStream);){
            dataStream.writeByte(this.getVersion());
            dataStream.writeLong(this.getTimestamp().getEpochSecond());
            dataStream.write(this.getInitializationVector().getIV());
            dataStream.write(this.getCipherText());
            dataStream.write(this.getHmac());
        }
    }

    public byte getVersion() {
        return this.version;
    }

    public Instant getTimestamp() {
        return this.timestamp;
    }

    public IvParameterSpec getInitializationVector() {
        return this.initializationVector;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder(107);
        builder.append("Token [version=").append(String.format("0x%x", new BigInteger(1, new byte[]{this.getVersion()}))).append(", timestamp=").append(this.getTimestamp()).append(", hmac=").append(Constants.encoder.encodeToString(this.getHmac())).append(']');
        return builder.toString();
    }

    protected static IvParameterSpec generateInitializationVector(SecureRandom random) {
        return new IvParameterSpec(Token.generateInitializationVectorBytes(random));
    }

    protected static byte[] generateInitializationVectorBytes(SecureRandom random) {
        byte[] retval = new byte[16];
        random.nextBytes(retval);
        return retval;
    }

    public boolean isValidSignature(Key key) {
        byte[] computedHmac = key.sign(this.getVersion(), this.getTimestamp(), this.getInitializationVector(), this.getCipherText());
        return MessageDigest.isEqual(this.getHmac(), computedHmac);
    }

    protected Base64.Encoder getEncoder() {
        return Constants.encoder;
    }

    protected byte[] getCipherText() {
        return this.cipherText;
    }

    protected byte[] getHmac() {
        return this.hmac;
    }
}

