/*
 * Decompiled with CFR 0.152.
 */
package com.machbase.jdbc;

import com.machbase.jdbc.InfoResultSetMetaData;
import com.machbase.jdbc.MachException;
import java.io.ByteArrayInputStream;
import java.io.CharArrayReader;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Map;
import java.util.Vector;

public class InfoResultSet
implements ResultSet {
    private int updateCount = -1;
    private Vector<Object> rowSets = null;
    private InfoResultSetMetaData iMeta = null;
    private int curRow = -1;
    private int columnCount = 0;
    private boolean is_holdable = false;

    InfoResultSet(String cat, String table) throws SQLException {
        this.iMeta = new InfoResultSetMetaData(cat, table);
        this.rowSets = new Vector();
    }

    public void setColumnCount(int col) {
        this.columnCount = col;
        this.iMeta.setColumnCount(col);
    }

    private void boundCheck(int col) throws SQLException {
        if (col > this.columnCount || col < 1) {
            throw new SQLException("out of index");
        }
    }

    public void addMeta(String colName, int colType) {
        try {
            this.iMeta.addMeta(colName, colType);
            this.setColumnCount(this.iMeta.getColumnCount());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void addRow(Vector ob) {
        this.rowSets.addElement(ob);
    }

    public int getRowSize() {
        return this.rowSets.size();
    }

    public void cleanRowSet() {
        this.curRow = -1;
        this.rowSets.removeAllElements();
    }

    public int getUpdateCount() {
        return this.updateCount;
    }

    @Override
    public void clearWarnings() throws SQLException {
    }

    @Override
    public void close() throws SQLException {
        this.cleanRowSet();
    }

    @Override
    public boolean next() throws SQLException {
        boolean ret = false;
        if (this.curRow < this.rowSets.size() - 1) {
            ++this.curRow;
            ret = true;
        } else {
            ret = false;
        }
        return ret;
    }

    private void checkIsOpen() throws SQLException {
    }

    private int getColumnType(int col) throws SQLException {
        return this.iMeta.getColumnType(col);
    }

    private String getColumnName(int col) throws SQLException {
        String name = this.iMeta.getColumnName(col);
        return name;
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        return this.iMeta;
    }

    @Override
    public String getString(int columnIndex) throws SQLException {
        this.boundCheck(columnIndex);
        Vector row = (Vector)this.rowSets.elementAt(this.curRow);
        return row.elementAt(columnIndex - 1).toString();
    }

    @Override
    public byte getByte(int columnIndex) throws SQLException {
        String tmp = this.getString(columnIndex);
        return tmp.getBytes()[0];
    }

    @Override
    public byte[] getBytes(int columnIndex) throws SQLException {
        String tmp = this.getString(columnIndex);
        return tmp.getBytes();
    }

    @Override
    public InputStream getAsciiStream(int columnIndex) throws SQLException {
        byte[] tmp = this.getString(columnIndex).getBytes();
        return new ByteArrayInputStream(tmp);
    }

    @Override
    public boolean getBoolean(int columnIndex) throws SQLException {
        short b = this.getShort(columnIndex);
        return b == 1;
    }

    @Override
    public InputStream getAsciiStream(String cname) throws SQLException {
        return this.getAsciiStream(this.findColumn(cname));
    }

    @Override
    public BigDecimal getBigDecimal(String cname) throws SQLException {
        return this.getBigDecimal(this.findColumn(cname));
    }

    @Override
    public BigDecimal getBigDecimal(int column) throws SQLException {
        String tmp = this.getString(column);
        return new BigDecimal(tmp);
    }

    @Override
    public BigDecimal getBigDecimal(String cname, int scale) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public BigDecimal getBigDecimal(int column, int scale) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public InputStream getBinaryStream(String cname) throws SQLException {
        return this.getBinaryStream(this.findColumn(cname));
    }

    @Override
    public boolean getBoolean(String cname) throws SQLException {
        return this.getBoolean(this.findColumn(cname));
    }

    @Override
    public byte getByte(String cname) throws SQLException {
        return this.getByte(this.findColumn(cname));
    }

    @Override
    public byte[] getBytes(String cname) throws SQLException {
        return this.getBytes(this.findColumn(cname));
    }

    @Override
    public Reader getCharacterStream(String cname) throws SQLException {
        return this.getCharacterStream(this.findColumn(cname));
    }

    @Override
    public Reader getCharacterStream(int column) throws SQLException {
        return new CharArrayReader(this.getString(column).toCharArray());
    }

    @Override
    public synchronized InputStream getUnicodeStream(String cname) throws SQLException {
        return this.getUnicodeStream(this.findColumn(cname));
    }

    @Override
    public synchronized InputStream getUnicodeStream(int column) throws SQLException {
        throw new SQLException("this method not supported.");
    }

    @Override
    public String getCursorName() throws SQLException {
        throw new SQLException("this method not supported.");
    }

    @Override
    public Date getDate(String cname) throws SQLException {
        return this.getDate(this.findColumn(cname));
    }

    @Override
    public Date getDate(int column) throws SQLException {
        throw new SQLException("data type not supported.");
    }

    @Override
    public Date getDate(String cname, Calendar cal) throws SQLException {
        return this.getDate(this.findColumn(cname), cal);
    }

    @Override
    public Date getDate(int column, Calendar cal) throws SQLException {
        throw new SQLException("data type not supported.");
    }

    @Override
    public double getDouble(String cname) throws SQLException {
        return this.getDouble(this.findColumn(cname));
    }

    @Override
    public double getDouble(int column) throws SQLException {
        String tmp = this.getString(column);
        return Double.parseDouble(tmp);
    }

    @Override
    public float getFloat(String cname) throws SQLException {
        return this.getFloat(this.findColumn(cname));
    }

    @Override
    public float getFloat(int column) throws SQLException {
        String tmp = this.getString(column);
        return Float.parseFloat(tmp);
    }

    @Override
    public int getInt(String cname) throws SQLException {
        return this.getInt(this.findColumn(cname));
    }

    @Override
    public int getInt(int column) throws SQLException {
        String tmp = this.getString(column);
        return Integer.parseInt(tmp);
    }

    @Override
    public long getLong(String cname) throws SQLException {
        return this.getLong(this.findColumn(cname));
    }

    @Override
    public long getLong(int column) throws SQLException {
        String tmp = this.getString(column);
        return Long.parseLong(tmp);
    }

    @Override
    public Object getObject(String cname) throws SQLException {
        return this.getObject(this.findColumn(cname));
    }

    @Override
    public Object getObject(int column) throws SQLException {
        this.boundCheck(column);
        Vector row = (Vector)this.rowSets.elementAt(this.curRow);
        return row.elementAt(column - 1);
    }

    @Override
    public int getRow() throws SQLException {
        if (this.curRow > this.rowSets.size() - 1) {
            return 0;
        }
        return this.curRow + 1;
    }

    @Override
    public short getShort(String cname) throws SQLException {
        return this.getShort(this.findColumn(cname));
    }

    @Override
    public short getShort(int column) throws SQLException {
        String tmp = this.getString(column);
        return Short.parseShort(tmp);
    }

    @Override
    public Statement getStatement() throws SQLException {
        return null;
    }

    @Override
    public String getString(String cname) throws SQLException {
        return this.getString(this.findColumn(cname));
    }

    @Override
    public Time getTime(String cname) throws SQLException {
        return this.getTime(this.findColumn(cname));
    }

    @Override
    public Time getTime(int column) throws SQLException {
        throw new SQLException("unsupported SQLTYPE");
    }

    @Override
    public Time getTime(String cname, Calendar cal) throws SQLException {
        return this.getTime(this.findColumn(cname), cal);
    }

    @Override
    public Time getTime(int column, Calendar cal) throws SQLException {
        throw new SQLException("unsupported SQLTYPE");
    }

    @Override
    public Timestamp getTimestamp(String cname) throws SQLException {
        return this.getTimestamp(this.findColumn(cname));
    }

    @Override
    public Timestamp getTimestamp(int column) throws SQLException {
        throw new SQLException("unsupported SQLTYPE");
    }

    @Override
    public Timestamp getTimestamp(String cname, Calendar cal) throws SQLException {
        return this.getTimestamp(this.findColumn(cname), cal);
    }

    @Override
    public Timestamp getTimestamp(int column, Calendar cal) throws SQLException {
        throw new SQLException("unsupported SQLTYPE");
    }

    @Override
    public InputStream getBinaryStream(int columnIndex) throws SQLException {
        byte[] tmp = this.getString(columnIndex).getBytes();
        return new ByteArrayInputStream(tmp);
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        return null;
    }

    @Override
    public boolean isAfterLast() throws SQLException {
        return this.getRow() == -2;
    }

    @Override
    public boolean isBeforeFirst() throws SQLException {
        return this.getRow() == 0;
    }

    @Override
    public int findColumn(String columnName) throws SQLException {
        int idx = this.iMeta.findColumn(columnName);
        if (idx == -1) {
            throw new MachException("Column " + columnName + " not exist");
        }
        return idx;
    }

    @Override
    public void moveToInsertRow() throws SQLException {
    }

    @Override
    public void updateBytes(int columnIndex, byte[] x) throws SQLException {
        throw new MachException("Machbase does not support updateXXX method");
    }

    @Override
    public void updateBytes(String columnName, byte[] x) throws SQLException {
        throw new MachException("Machbase does not support updateXXX method");
    }

    @Override
    public boolean previous() throws SQLException {
        return false;
    }

    @Override
    public void afterLast() throws SQLException {
    }

    @Override
    public void beforeFirst() throws SQLException {
    }

    @Override
    public void updateByte(int columnIndex, byte x) throws SQLException {
        throw new MachException("Machbase does not support updateXXX method");
    }

    @Override
    public void updateByte(String columnName, byte x) throws SQLException {
        throw new MachException("Machbase does not support updateXXX method");
    }

    @Override
    public boolean isFirst() throws SQLException {
        return false;
    }

    @Override
    public void updateObject(int columnIndex, Object x) throws SQLException {
        throw new MachException("Machbase does not support updateXXX method");
    }

    @Override
    public void updateObject(int columnIndex, Object x, int scale) throws SQLException {
        throw new MachException("Machbase does not support updateXXX method");
    }

    @Override
    public void updateObject(String columnName, Object x) throws SQLException {
        throw new MachException("Machbase does not support updateXXX method");
    }

    @Override
    public void updateObject(String columnName, Object x, int scale) throws SQLException {
        throw new MachException("Machbase does not support updateXXX method");
    }

    @Override
    public int getType() throws SQLException {
        return 1003;
    }

    @Override
    public void updateBigDecimal(int columnIndex, BigDecimal x) throws SQLException {
        throw new MachException("Machbase does not support updateXXX method");
    }

    @Override
    public void updateBigDecimal(String columnName, BigDecimal x) throws SQLException {
        throw new MachException("Machbase does not support updateXXX method");
    }

    @Override
    public void updateRow() throws SQLException {
        throw new MachException("Machbase does not support updateXXX method");
    }

    @Override
    public void updateCharacterStream(int columnIndex, Reader x, int length) throws SQLException {
        throw new MachException("Machbase does not support updateXXX method");
    }

    @Override
    public void updateCharacterStream(String columnName, Reader x, int length) throws SQLException {
        throw new MachException("Machbase does not support updateXXX method");
    }

    @Override
    public void insertRow() throws SQLException {
    }

    @Override
    public void updateTimestamp(int columnIndex, Timestamp x) throws SQLException {
        throw new MachException("Machbase does not support updateXXX method");
    }

    @Override
    public void updateTimestamp(String columnName, Timestamp x) throws SQLException {
        throw new MachException("Machbase does not support updateXXX method");
    }

    @Override
    public void updateBoolean(int columnIndex, boolean x) throws SQLException {
        throw new MachException("Machbase does not support updateXXX method");
    }

    @Override
    public void updateBoolean(String columnName, boolean x) throws SQLException {
        throw new MachException("Machbase does not support updateXXX method");
    }

    @Override
    public void updateString(int columnIndex, String x) throws SQLException {
        throw new MachException("Machbase does not support updateXXX method");
    }

    @Override
    public void updateString(String columnName, String x) throws SQLException {
        throw new MachException("Machbase does not support updateXXX method");
    }

    @Override
    public void updateFloat(int columnIndex, float x) throws SQLException {
        throw new MachException("Machbase does not support updateXXX method");
    }

    @Override
    public void updateFloat(String columnName, float x) throws SQLException {
        throw new MachException("Machbase does not support updateXXX method");
    }

    @Override
    public void setFetchDirection(int direction) throws SQLException {
    }

    @Override
    public void setFetchSize(int size) throws SQLException {
    }

    public void upateBinaryStream(int columnIndex, InputStream x, int length) throws SQLException {
        throw new MachException("Machbase does not support updateXXX method");
    }

    @Override
    public void updateBinaryStream(String columnName, InputStream x, int length) throws SQLException {
        throw new MachException("Machbase does not support updateXXX method");
    }

    @Override
    public boolean first() throws SQLException {
        return false;
    }

    @Override
    public void updateDouble(int columnIndex, double x) throws SQLException {
        throw new MachException("Machbase does not support updateXXX method");
    }

    @Override
    public void updateDouble(String columnName, double x) throws SQLException {
        throw new MachException("Machbase does not support updateXXX method");
    }

    @Override
    public boolean wasNull() throws SQLException {
        return false;
    }

    @Override
    public boolean relative(int rows) throws SQLException {
        return false;
    }

    @Override
    public void updateShort(int columnIndex, short x) throws SQLException {
        throw new MachException("Machbase does not support updateXXX method");
    }

    @Override
    public void updateShort(String columnName, short x) throws SQLException {
        throw new MachException("Machbase does not support updateXXX method");
    }

    @Override
    public void cancelRowUpdates() throws SQLException {
    }

    @Override
    public void updateNull(int columnIndex) throws SQLException {
        throw new MachException("Machbase does not support updateXXX method");
    }

    @Override
    public void updateNull(String columnName) throws SQLException {
        throw new MachException("Machbase does not support updateXXX method");
    }

    @Override
    public boolean last() throws SQLException {
        return false;
    }

    @Override
    public Ref getRef(int columnIndex) throws SQLException {
        return null;
    }

    @Override
    public Ref getRef(String columnName) throws SQLException {
        return null;
    }

    @Override
    public void moveToCurrentRow() throws SQLException {
    }

    @Override
    public boolean absolute(int row) throws SQLException {
        return false;
    }

    @Override
    public int getFetchSize() throws SQLException {
        return 0;
    }

    @Override
    public void updateLong(int columnIndex, long x) throws SQLException {
        throw new MachException("Machbase does not support updateXXX method");
    }

    @Override
    public void updateLong(String columnName, long x) throws SQLException {
        throw new MachException("Machbase does not support updateXXX method");
    }

    @Override
    public void updateAsciiStream(int columnIndex, InputStream x, int length) throws SQLException {
        throw new MachException("Machbase does not support updateXXX method");
    }

    @Override
    public void updateAsciiStream(String columnName, InputStream x, int length) throws SQLException {
        throw new MachException("Machbase does not support updateXXX method");
    }

    @Override
    public boolean isLast() throws SQLException {
        return false;
    }

    @Override
    public int getFetchDirection() throws SQLException {
        return 0;
    }

    @Override
    public void updateBinaryStream(int columnIndex, InputStream x, int length) throws SQLException {
        throw new MachException("Machbase does not support updateXXX method");
    }

    public Object getObject(int columnIndex, Map map) throws SQLException {
        throw new MachException("Unsupported  method");
    }

    public Object getObject(String columnName, Map map) throws SQLException {
        throw new MachException("Unsupported  method");
    }

    @Override
    public void updateTime(int columnIndex, Time x) throws SQLException {
        throw new MachException("Machbase does not support updateXXX method");
    }

    @Override
    public void updateTime(String columnName, Time x) throws SQLException {
        throw new MachException("Machbase does not support updateXXX method");
    }

    @Override
    public void updateInt(int columnIndex, int x) throws SQLException {
        throw new MachException("Machbase does not support updateXXX method");
    }

    @Override
    public void updateInt(String columnName, int x) throws SQLException {
        throw new MachException("Machbase does not support updateXXX method");
    }

    @Override
    public void updateDate(int columnIndex, Date x) throws SQLException {
        throw new MachException("Machbase does not support updateXXX method");
    }

    @Override
    public void updateDate(String columnName, Date x) throws SQLException {
        throw new MachException("Machbase does not support updateXXX method");
    }

    @Override
    public boolean rowInserted() throws SQLException {
        throw new MachException("Unsupported  method");
    }

    @Override
    public boolean rowUpdated() throws SQLException {
        throw new MachException("Unsupported  method");
    }

    @Override
    public boolean rowDeleted() throws SQLException {
        throw new MachException("Unsupported  method");
    }

    @Override
    public void deleteRow() throws SQLException {
        throw new MachException("Unsupported  method");
    }

    @Override
    public void refreshRow() throws SQLException {
        throw new MachException("Unsupported  method");
    }

    @Override
    public Array getArray(int columnIndex) throws SQLException {
        throw new MachException("Unsupported  method");
    }

    @Override
    public Array getArray(String columnName) throws SQLException {
        throw new MachException("Unsupported  method");
    }

    @Override
    public Blob getBlob(int columnIndex) throws SQLException {
        throw new MachException("Machbase does not support getBlob");
    }

    @Override
    public Blob getBlob(String columnName) throws SQLException {
        throw new MachException("Machbase does not support getBlob");
    }

    @Override
    public Clob getClob(int columnIndex) throws SQLException {
        throw new MachException("Machbase does not support getClob");
    }

    @Override
    public Clob getClob(String columnName) throws SQLException {
        throw new MachException("Machbase does not support getClob");
    }

    @Override
    public int getConcurrency() throws SQLException {
        return 0;
    }

    @Override
    public int getHoldability() throws SQLException {
        this.checkIsOpen();
        return this.is_holdable ? 1 : 2;
    }

    @Override
    public Reader getNCharacterStream(int columnIndex) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Reader getNCharacterStream(String columnLabel) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public NClob getNClob(int columnIndex) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public NClob getNClob(String columnLabel) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getNString(int columnIndex) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getNString(String columnLabel) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public RowId getRowId(int columnIndex) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public RowId getRowId(String columnLabel) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public SQLXML getSQLXML(int columnIndex) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public SQLXML getSQLXML(String columnLabel) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isClosed() throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateAsciiStream(int columnIndex, InputStream x) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateAsciiStream(String columnLabel, InputStream x) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateAsciiStream(int columnIndex, InputStream x, long length) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateAsciiStream(String columnLabel, InputStream x, long length) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateBinaryStream(int columnIndex, InputStream x) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateBinaryStream(String columnLabel, InputStream x) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateBinaryStream(int columnIndex, InputStream x, long length) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateBinaryStream(String columnLabel, InputStream x, long length) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateBlob(int columnIndex, InputStream inputStream) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateBlob(String columnLabel, InputStream inputStream) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateBlob(int columnIndex, InputStream inputStream, long length) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateBlob(String columnLabel, InputStream inputStream, long length) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateCharacterStream(int columnIndex, Reader x) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateCharacterStream(String columnLabel, Reader reader) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateCharacterStream(int columnIndex, Reader x, long length) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateCharacterStream(String columnLabel, Reader reader, long length) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateClob(int columnIndex, Reader reader) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateClob(String columnLabel, Reader reader) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateClob(int columnIndex, Reader reader, long length) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateClob(String columnLabel, Reader reader, long length) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateNCharacterStream(int columnIndex, Reader x) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateNCharacterStream(String columnLabel, Reader reader) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateNCharacterStream(int columnIndex, Reader x, long length) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateNCharacterStream(String columnLabel, Reader reader, long length) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateNClob(int columnIndex, NClob clob) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateNClob(String columnLabel, NClob clob) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateNClob(int columnIndex, Reader reader) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateNClob(String columnLabel, Reader reader) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateNClob(int columnIndex, Reader reader, long length) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateNClob(String columnLabel, Reader reader, long length) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateNString(int columnIndex, String string) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateNString(String columnLabel, String string) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateRowId(int columnIndex, RowId x) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateRowId(String columnLabel, RowId x) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateSQLXML(int columnIndex, SQLXML xmlObject) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateSQLXML(String columnLabel, SQLXML xmlObject) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public <T> T getObject(int columnIndex, Class<T> type) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public <T> T getObject(String columnLabel, Class<T> type) throws SQLException {
        throw new UnsupportedOperationException();
    }

    private void updateValue(int columnIndex, Object value) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public synchronized URL getURL(int columnIndex) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public synchronized URL getURL(String columnName) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public synchronized void updateArray(int columnIndex, Array x) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public synchronized void updateArray(String columnName, Array x) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public synchronized void updateBlob(int columnIndex, Blob x) throws SQLException {
        this.updateValue(columnIndex, x);
    }

    @Override
    public synchronized void updateBlob(String columnName, Blob x) throws SQLException {
        this.updateValue(this.findColumn(columnName), x);
    }

    @Override
    public synchronized void updateClob(int columnIndex, Clob x) throws SQLException {
        this.updateValue(columnIndex, x);
    }

    @Override
    public synchronized void updateClob(String columnName, Clob x) throws SQLException {
        this.updateValue(this.findColumn(columnName), x);
    }

    @Override
    public synchronized void updateRef(int columnIndex, Ref x) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public synchronized void updateRef(String columnName, Ref x) throws SQLException {
        throw new UnsupportedOperationException();
    }
}

