/*
 * Decompiled with CFR 0.152.
 */
package com.machbase.jdbc;

import com.machbase.jdbc.MachTypes;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.Vector;

public class InfoResultSetMetaData
implements ResultSetMetaData {
    private String catalog = null;
    private int columnCount = 0;
    private String tableName = null;
    private Vector<Object> columnNameList = new Vector();
    private Vector<Object> columnTypeList = new Vector();

    InfoResultSetMetaData(String cat, String table) throws SQLException {
        this.catalog = cat;
        this.tableName = table;
    }

    public void setColumnCount(int col) {
        this.columnCount = col;
    }

    public void addMeta(String colName, int colType) {
        this.columnNameList.addElement(colName);
        this.columnTypeList.addElement(new Integer(colType));
        ++this.columnCount;
    }

    @Override
    public String getCatalogName(int column) throws SQLException {
        return this.catalog;
    }

    @Override
    public String getColumnClassName(int column) throws SQLException {
        return null;
    }

    @Override
    public int getColumnCount() throws SQLException {
        return this.columnCount;
    }

    @Override
    public int getColumnDisplaySize(int column) throws SQLException {
        return 40;
    }

    @Override
    public String getColumnLabel(int column) throws SQLException {
        return this.tableName + "." + this.getColumnName(column);
    }

    @Override
    public String getColumnName(int column) throws SQLException {
        if (column > this.columnCount || column < 1) {
            throw new SQLException("out of index");
        }
        return this.columnNameList.get(column - 1).toString();
    }

    @Override
    public int getColumnType(int column) throws SQLException {
        if (column > this.columnCount || column < 1) {
            throw new SQLException("out of index");
        }
        return (Integer)this.columnTypeList.get(column - 1);
    }

    @Override
    public String getColumnTypeName(int column) throws SQLException {
        int t = this.getColumnType(column);
        return MachTypes.getSQLTypeNameForSQL(t);
    }

    @Override
    public int getPrecision(int column) throws SQLException {
        int t = this.getColumnType(column);
        int prec = 0;
        if (t == 1) {
            prec = 1000;
        } else if (t == 12) {
            prec = Short.MAX_VALUE;
        } else if (t == -7) {
            prec = 20000;
        } else if (t == 2) {
            prec = 20;
        } else if (t == 91) {
            prec = 10;
        }
        return prec;
    }

    @Override
    public int getScale(int column) throws SQLException {
        if (column > this.columnCount || column < 1) {
            throw new SQLException("out of index");
        }
        return 0;
    }

    @Override
    public String getSchemaName(int column) throws SQLException {
        return "";
    }

    @Override
    public String getTableName(int column) throws SQLException {
        return this.tableName;
    }

    @Override
    public boolean isAutoIncrement(int column) throws SQLException {
        return false;
    }

    @Override
    public boolean isCaseSensitive(int column) throws SQLException {
        return true;
    }

    @Override
    public boolean isCurrency(int column) throws SQLException {
        return false;
    }

    @Override
    public boolean isDefinitelyWritable(int column) throws SQLException {
        return true;
    }

    @Override
    public int isNullable(int column) throws SQLException {
        return 1;
    }

    @Override
    public boolean isReadOnly(int column) throws SQLException {
        return false;
    }

    @Override
    public boolean isSearchable(int column) throws SQLException {
        int t = this.getColumnType(column);
        return t != -7;
    }

    @Override
    public boolean isSigned(int column) throws SQLException {
        int t = this.getColumnType(column);
        return t == 2;
    }

    @Override
    public boolean isWritable(int column) throws SQLException {
        return true;
    }

    public int findColumn(String name) {
        int index = this.columnNameList.indexOf(name.toUpperCase());
        if (index == -1) {
            return index;
        }
        return index + 1;
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        throw new UnsupportedOperationException();
    }
}

