/*
 * Decompiled with CFR 0.152.
 */
package com.machbase.jdbc;

import com.machbase.jdbc.MachByteFunc;
import com.machbase.jdbc.MachPacket;
import com.machbase.jdbc.MachResult;
import java.math.BigInteger;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.sql.SQLException;
import java.util.StringTokenizer;

public class MachBuffer {
    private byte[] mBuf;
    private int mBufLength = 0;
    private int mCurrPos = 0;
    private int mNullBitPos = 0;
    private int mSendLength = 0;
    private long mProtocol = 0L;
    private int mInitBufSize = 0;
    private int mExtendBufSize = 0;
    private int mLastPacketFlag = -1;
    final int PACKET_HEADER_SIZE = 16;
    MachPacket pac = new MachPacket();

    public MachBuffer() {
        this.mBufLength = 0;
        this.mCurrPos = 0;
        this.mNullBitPos = 0;
        this.mInitBufSize = 0;
        this.mExtendBufSize = 0;
    }

    public MachBuffer(byte[] b) {
        this.mBuf = b;
        this.mBufLength = b.length;
        this.mCurrPos = 0;
        this.mNullBitPos = 0;
        this.mInitBufSize = this.mBufLength;
        this.mExtendBufSize = this.mBufLength;
    }

    public MachBuffer(int aSize) {
        this.mBuf = new byte[aSize];
        this.mBufLength = aSize;
        this.mCurrPos = 0;
        this.mNullBitPos = 0;
        this.mInitBufSize = aSize;
        this.mExtendBufSize = aSize;
    }

    public void setBuffer(byte[] b) {
        this.mBuf = b;
        this.mBufLength = b == null ? 0 : b.length;
        this.mLastPacketFlag = 0;
    }

    public void setBuffer(int aSize) {
        byte[] sOld = this.mBuf;
        this.mBuf = new byte[aSize];
        System.arraycopy(sOld, 0, this.mBuf, 0, sOld.length);
        this.mBufLength = this.mBuf.length;
    }

    public void setBuffer(int aFlag, byte[] aNew) {
        if (this.mBuf != null) {
            byte[] sOld = this.mBuf;
            this.mBuf = new byte[this.mBuf.length + aNew.length];
            System.arraycopy(sOld, 0, this.mBuf, 0, sOld.length);
            System.arraycopy(aNew, 0, this.mBuf, sOld.length, aNew.length);
        } else {
            this.mBuf = aNew;
        }
        this.mBufLength = this.mBuf.length;
        this.mLastPacketFlag = aFlag;
    }

    public void extendBuffer(int aSize) {
        int sExtendSize = 0;
        if (this.mCurrPos + aSize > this.mBuf.length) {
            sExtendSize = aSize > this.mExtendBufSize ? aSize : this.mExtendBufSize;
            this.setBuffer(this.mCurrPos + sExtendSize);
        }
    }

    public void clear() {
        if (this.mBuf != null && this.mBuf.length > this.mInitBufSize) {
            this.mBuf = new byte[this.mInitBufSize];
            this.mBufLength = this.mBuf.length;
        }
        this.mLastPacketFlag = -1;
        this.mCurrPos = 0;
    }

    public byte[] getBuf() {
        return this.mBuf;
    }

    public int getCurrPos() {
        return this.mCurrPos;
    }

    public int getBufLength() {
        return this.mBufLength;
    }

    public int getLastPacketFlag() {
        return this.mLastPacketFlag;
    }

    final void setProtocol(long p) {
        this.mProtocol = p;
    }

    final long getProtocol() {
        return this.mProtocol;
    }

    final void setBytes(byte[] b) {
        this.mSendLength = this.mBufLength;
        System.arraycopy(b, 0, this.mBuf, 0, this.mBufLength);
    }

    final long readUIntNoCnt() {
        long val = 0L;
        for (int i = 3; i >= 0; --i) {
            if (i > 0) {
                long tmp = MachByteFunc.uLong(this.mBuf[this.mCurrPos++]) << i * 8;
                val += tmp;
                continue;
            }
            val += MachByteFunc.uLong(this.mBuf[this.mCurrPos++]);
        }
        return val;
    }

    final void writeResult(MachResult result) {
        this.writeUIntNoCnt(result.getResult());
        this.writeUIntNoCnt(result.getErrorNo());
    }

    final long readProtocol() {
        if (this.mCurrPos >= this.mBuf.length) {
            return 0L;
        }
        return this.readUIntNoCnt();
    }

    final long readType() {
        return this.readUIntNoCnt();
    }

    final int readLength() {
        for (int i = 0; i < 4; ++i) {
            ++this.mCurrPos;
        }
        return (int)this.readUIntNoCnt();
    }

    final byte[] readBytesbyLen() {
        int len = this.readLength();
        return this.readBytes(len);
    }

    final byte[] readBytes(int len) {
        byte[] b = new byte[len];
        System.arraycopy(this.mBuf, this.mCurrPos, b, 0, len);
        this.mCurrPos += len;
        if (len % 8 != 0) {
            int tmp = (len / 8 + 1) * 8 - len;
            this.mCurrPos += tmp;
        }
        return b;
    }

    final byte[] readBytesNoCnt(int len) {
        byte[] b = new byte[len];
        System.arraycopy(this.mBuf, this.mCurrPos, b, 0, len);
        this.mCurrPos += len;
        return b;
    }

    final void writeByte(byte b) {
        this.mBuf[this.mCurrPos++] = b;
        this.mCurrPos += 7;
    }

    final void writeShort(byte[] b) {
        this.mBuf[this.mCurrPos++] = b[0];
        this.mBuf[this.mCurrPos++] = b[1];
        this.mCurrPos += 6;
    }

    final void writeShort(short val) {
        int tmpValue = 0;
        tmpValue = val >>> 8;
        this.mBuf[this.mCurrPos++] = (byte)tmpValue;
        this.mBuf[this.mCurrPos++] = (byte)val;
        this.mCurrPos += 6;
    }

    public short swap(short x) {
        return (short)(x << 8 | x >> 8 & 0xFF);
    }

    public int swap(int x) {
        return this.swap((short)x) << 16 | this.swap((short)(x >> 16)) & 0xFFFF;
    }

    public long swap(long x) {
        return (long)this.swap((int)x) << 32 | (long)this.swap((int)(x >> 32)) & 0xFFFFFFFFL;
    }

    public float swap(float x) {
        return Float.intBitsToFloat(this.swap(Float.floatToRawIntBits(x)));
    }

    public double swap(double x) {
        return Double.longBitsToDouble(this.swap(Double.doubleToRawLongBits(x)));
    }

    final void writeInt(byte[] b) {
        this.extendBuffer(4);
        this.mBuf[this.mCurrPos++] = b[0];
        this.mBuf[this.mCurrPos++] = b[1];
        this.mBuf[this.mCurrPos++] = b[2];
        this.mBuf[this.mCurrPos++] = b[3];
        this.mCurrPos += 4;
    }

    final void writeInt(int val) {
        this.extendBuffer(4);
        int tmpValue = 0;
        for (int i = 3; i >= 0; --i) {
            tmpValue = val >>> i * 8;
            this.mBuf[this.mCurrPos++] = (byte)tmpValue;
        }
        this.mCurrPos += 4;
    }

    final void writeLong(byte[] b) {
        this.extendBuffer(8);
        for (int i = 0; i < 8; ++i) {
            this.mBuf[this.mCurrPos++] = b[i];
        }
    }

    final void writeLong(long val) {
        this.extendBuffer(8);
        long tmpValue = 0L;
        for (int i = 7; i >= 0; --i) {
            tmpValue = val >>> i * 8;
            this.mBuf[this.mCurrPos++] = (byte)tmpValue;
        }
    }

    final void writeFloat(float val) {
        this.extendBuffer(4);
        int tmpValue = 0;
        int intVal = Float.floatToRawIntBits(val);
        for (int i = 3; i >= 0; --i) {
            tmpValue = intVal >>> i * 8;
            this.mBuf[this.mCurrPos++] = (byte)tmpValue;
        }
        this.mCurrPos += 4;
    }

    final void writeDouble(double val) {
        this.extendBuffer(8);
        long tmpValue = 0L;
        long longVal = Double.doubleToRawLongBits(val);
        for (int i = 7; i >= 0; --i) {
            tmpValue = longVal >>> i * 8;
            this.mBuf[this.mCurrPos++] = (byte)tmpValue;
        }
    }

    final void writeDate(long val) {
        this.extendBuffer(8);
        long tmpValue = 0L;
        for (int i = 7; i >= 0; --i) {
            tmpValue = val >>> i * 8;
            this.mBuf[this.mCurrPos++] = (byte)tmpValue;
        }
    }

    final void writeIpv4(String val) {
        this.extendBuffer(5);
        if (val != null && val.length() > 0) {
            this.mBuf[this.mCurrPos++] = 4;
            StringTokenizer st = new StringTokenizer(val, ".");
            while (st.hasMoreTokens()) {
                this.mBuf[this.mCurrPos++] = (byte)Integer.parseInt(st.nextToken());
            }
        } else {
            for (int i = 0; i < 5; ++i) {
                this.mBuf[this.mCurrPos++] = 0;
            }
        }
    }

    final void writeIpv6(String val) {
        this.extendBuffer(17);
        if (val != null && val.length() > 0) {
            try {
                InetAddress sAddr = InetAddress.getByName(val);
                byte[] sBuf = sAddr.getAddress();
                this.mBuf[this.mCurrPos++] = 6;
                if (sBuf.length == 4) {
                    int i;
                    for (i = 0; i < 12; ++i) {
                        this.mBuf[this.mCurrPos++] = 0;
                    }
                    for (i = 0; i < sBuf.length; ++i) {
                        this.mBuf[this.mCurrPos++] = sBuf[i];
                    }
                }
                for (int i = 0; i < sBuf.length; ++i) {
                    this.mBuf[this.mCurrPos++] = sBuf[i];
                }
            }
            catch (UnknownHostException e) {
                for (int i = 0; i < 17; ++i) {
                    this.mBuf[this.mCurrPos++] = 0;
                }
            }
        } else {
            for (int i = 0; i < 17; ++i) {
                this.mBuf[this.mCurrPos++] = 0;
            }
        }
    }

    final void writeUInt(long val) {
        this.extendBuffer(4);
        long tmpValue = 0L;
        for (int i = 3; i >= 0; --i) {
            tmpValue = val >>> i * 8;
            this.mBuf[this.mCurrPos++] = (byte)tmpValue;
        }
        this.mCurrPos += 4;
    }

    final void writeUIntNoCnt(long val) {
        this.extendBuffer(4);
        long tmpValue = 0L;
        for (int i = 3; i >= 0; --i) {
            tmpValue = val >>> i * 8;
            this.mBuf[this.mCurrPos++] = (byte)tmpValue;
        }
    }

    final void writeProtocol(long val) {
        this.writeUIntNoCnt(val);
    }

    final void writeType(long type) {
        this.writeUIntNoCnt(type);
    }

    final void writeDataType(long type) {
        this.writeLong(type);
    }

    final void writeProtocol(String val) {
        byte[] b = val.getBytes();
        int len = b.length;
        this.extendBuffer(len);
        System.arraycopy(b, 0, this.mBuf, this.mCurrPos, len);
        this.mCurrPos += len;
    }

    final void writeType(String val) {
        byte[] b = val.getBytes();
        int len = b.length;
        this.extendBuffer(len);
        System.arraycopy(b, 0, this.mBuf, this.mCurrPos, len);
        this.mCurrPos += len;
    }

    final void writeULong(String val) {
        byte[] b = val.getBytes();
        this.extendBuffer(b.length);
        System.arraycopy(b, 0, this.mBuf, this.mCurrPos, b.length);
        this.mCurrPos += 8;
    }

    final void writeString(String val) {
        byte[] b = val.getBytes();
        this.writeBytes(b);
    }

    final void writeString(String val, String enc) {
        byte[] b = val.getBytes();
        this.writeBytes(b);
    }

    final void writeStringWithLen(String val, String enc) throws SQLException {
        byte[] b = val.getBytes();
        this.writeLength(b.length);
        this.writeBytes(b);
    }

    final void writeBytesWithLen(byte[] b) {
        this.writeLength(b.length);
        this.writeBytes(b);
    }

    final void writeBytes(byte[] b, int len) {
        this.writeLength(len);
        this.extendBuffer(len);
        System.arraycopy(b, 0, this.mBuf, this.mCurrPos, len);
        this.mCurrPos += len;
        if (len % 8 != 0) {
            int tmp = (len / 8 + 1) * 8 - len;
            this.extendBuffer(tmp);
            this.mCurrPos += tmp;
        }
    }

    final void writeBytes(byte[] b) {
        int len = b.length;
        this.extendBuffer(len);
        System.arraycopy(b, 0, this.mBuf, this.mCurrPos, len);
        this.mCurrPos += len;
        if (len % 8 != 0) {
            int tmp = (len / 8 + 1) * 8 - len;
            this.extendBuffer(tmp);
            for (int i = 0; i < tmp; ++i) {
                this.mBuf[this.mCurrPos++] = 0;
            }
        }
    }

    final void writeBytes2(byte[] b) {
        int len = b.length;
        this.extendBuffer(len);
        System.arraycopy(b, 0, this.mBuf, this.mCurrPos, len);
        this.mCurrPos += len;
        if (len % 2 == 1) {
            this.extendBuffer(1);
            this.mBuf[this.mCurrPos] = 0;
            ++this.mCurrPos;
        }
    }

    final void writeBytesOrgSize(byte[] b) {
        int len = b.length;
        this.extendBuffer(len);
        System.arraycopy(b, 0, this.mBuf, this.mCurrPos, len);
        this.mCurrPos += len;
    }

    final void writeLength(int size) {
        int i;
        this.extendBuffer(8);
        int size_t = 0;
        for (i = 0; i < 4; ++i) {
            this.mBuf[this.mCurrPos++] = 0;
        }
        for (i = 3; i >= 0; --i) {
            size_t = size >>> i * 8;
            this.mBuf[this.mCurrPos++] = (byte)size_t;
        }
    }

    final void writeParamLength(int pos, int size) {
        int i;
        this.extendBuffer(8);
        int size_t = 0;
        for (i = 0; i < 4; ++i) {
            this.mBuf[pos++] = 0;
        }
        for (i = 3; i >= 0; --i) {
            size_t = size >>> i * 8;
            this.mBuf[pos++] = (byte)size_t;
        }
        if (size % 8 != 0) {
            int tmp = (size / 8 + 1) * 8 - size;
            this.extendBuffer(tmp);
            this.mCurrPos += tmp;
        }
    }

    final void writeParamCnt(int pos, int size) {
        this.extendBuffer(2);
        this.mBuf[pos++] = (byte)(size >>> 8);
        this.mBuf[pos++] = (byte)size;
    }

    final void assignNullBitArray(int cnt, int size) {
        this.mNullBitPos = this.mCurrPos;
        this.extendBuffer(size);
        for (int i = 0; i < size; ++i) {
            this.mBuf[this.mCurrPos++] = 0;
        }
    }

    final void setNullBitArray(int position) {
        int bytePos = position / 8;
        int bitPos = position % 8;
        this.mBuf[this.mNullBitPos + bytePos] = (byte)(this.mBuf[this.mNullBitPos + bytePos] | 1 << 7 - bitPos);
    }

    final void skip(int size) {
        this.mCurrPos += size;
    }

    final int align8(int aValue) {
        return aValue + 7 & 0xFFFFFFF8;
    }

    final void writeTotalLength() {
        int i;
        int size_t = 0;
        int size = this.mCurrPos - 16;
        int cnt = 8;
        for (i = 0; i < 4; ++i) {
            this.mBuf[cnt++] = 0;
        }
        for (i = 3; i >= 0; --i) {
            size_t = size >>> i * 8;
            this.mBuf[cnt++] = (byte)size_t;
        }
    }

    final void dump() {
        System.out.println("send mBuffer dump ==>");
        for (int i = 0; i < this.mCurrPos; ++i) {
            if (i % 16 == 0) {
                System.out.println();
            }
            System.out.format("%02X ", this.mBuf[i]);
        }
        System.out.println();
    }

    final void dump2() {
        System.out.println("send mBuffer dump2 ==>");
        for (int i = 0; i < this.mBufLength; ++i) {
            if (i % 16 == 0) {
                System.out.println();
            }
            System.out.format("%02X ", this.mBuf[i]);
        }
        System.out.println();
    }

    final MachPacket readNext() {
        if (this.mCurrPos >= this.mBufLength) {
            this.clear();
            return null;
        }
        long sProtocol = this.readProtocol();
        long sType = this.readType();
        if (sType == 2L || sType == 3L || sType == 13L) {
            this.pac.set(sProtocol, sType, this.readBytesbyLen());
        } else if (sType == 4L || sType == 5L) {
            this.pac.set(sProtocol, sType, this.readBytesNoCnt(1));
            this.mCurrPos += 7;
        } else if (sType == 6L || sType == 7L) {
            this.pac.set(sProtocol, sType, this.readBytesNoCnt(2));
            this.mCurrPos += 6;
        } else if (sType == 8L || sType == 9L) {
            this.pac.set(sProtocol, sType, this.readBytesNoCnt(4));
            this.mCurrPos += 4;
        } else if (sType == 10L || sType == 11L) {
            this.pac.set(sProtocol, sType, this.readBytesNoCnt(8));
        } else {
            this.pac.set(sProtocol, sType, null);
        }
        return this.pac;
    }

    final void appendByte(byte val) {
        this.extendBuffer(1);
        this.mBuf[this.mCurrPos++] = val;
    }

    final void appendShort(short val) {
        this.extendBuffer(2);
        int tmpValue = 0;
        tmpValue = val >>> 8;
        this.mBuf[this.mCurrPos++] = (byte)tmpValue;
        this.mBuf[this.mCurrPos++] = (byte)val;
    }

    final void appendUShort(short aVal) {
        this.appendShort(aVal);
    }

    final void appendInt(int val) {
        this.extendBuffer(4);
        int tmpValue = 0;
        for (int i = 3; i >= 0; --i) {
            tmpValue = val >>> i * 8;
            this.mBuf[this.mCurrPos++] = (byte)tmpValue;
        }
    }

    final void appendUInt(int aVal) {
        this.appendInt(aVal);
    }

    final void appendLong(long val) {
        this.extendBuffer(8);
        long tmpValue = 0L;
        for (int i = 7; i >= 0; --i) {
            tmpValue = val >>> i * 8;
            this.mBuf[this.mCurrPos++] = (byte)tmpValue;
        }
    }

    final void appendULong(BigInteger aVal, boolean aSwap) {
        this.extendBuffer(8);
        byte[] b = aVal.toByteArray();
        if (b.length <= 8) {
            int i = 0;
            int sBlank = 8 - b.length;
            if (aSwap) {
                for (i = b.length; i > 0; --i) {
                    this.mBuf[this.mCurrPos++] = b[i - 1];
                }
                for (i = sBlank; i > 0; --i) {
                    this.mBuf[this.mCurrPos++] = 0;
                }
            } else {
                for (i = 0; i < sBlank; ++i) {
                    this.mBuf[this.mCurrPos++] = 0;
                }
                for (i = sBlank; i < b.length; ++i) {
                    this.mBuf[this.mCurrPos++] = b[i];
                }
            }
        } else {
            int i = 0;
            int sStartIndex = b.length - 8;
            if (aSwap) {
                for (i = b.length; i > sStartIndex; --i) {
                    this.mBuf[this.mCurrPos++] = b[i - 1];
                }
            } else {
                for (i = sStartIndex; i < b.length; ++i) {
                    this.mBuf[this.mCurrPos++] = b[i];
                }
            }
        }
    }

    final void appendFloat(float val) {
        this.extendBuffer(4);
        int tmpValue = 0;
        int intVal = Float.floatToRawIntBits(val);
        for (int i = 3; i >= 0; --i) {
            tmpValue = intVal >>> i * 8;
            this.mBuf[this.mCurrPos++] = (byte)tmpValue;
        }
    }

    final void writePacketHeader(long aProtocolID, int aFlag, int aStmtId) {
        long sTmpValue = 0L;
        int sPacketLength = this.mCurrPos - 16;
        long sPacketHeader = (long)aStmtId << 48 | aProtocolID << 32 | (long)(aFlag << 30) | (long)sPacketLength;
        long sPacketHeaderExtended = (long)aStmtId << 32;
        int i = 7;
        int k = 0;
        while (i >= 0) {
            this.mBuf[k] = (byte)(sPacketHeader >>> i * 8 & 0xFFL);
            --i;
            ++k;
        }
        i = 7;
        k = 8;
        while (i >= 0) {
            this.mBuf[k] = (byte)(sPacketHeaderExtended >>> i * 8 & 0xFFL);
            --i;
            ++k;
        }
    }

    final long getPacketHeader() {
        int k = 0;
        long sVal = 0L;
        for (int i = 7; i >= 0; --i) {
            if (i > 0) {
                long sTmp = MachByteFunc.uLong(this.mBuf[k++]) << i * 8;
                sVal += sTmp;
                continue;
            }
            sVal += MachByteFunc.uLong(this.mBuf[k++]);
        }
        return sVal;
    }

    final long readPacketProtocol() {
        if (this.mCurrPos >= this.mBuf.length) {
            return 0L;
        }
        long sPacketHeader = this.getPacketHeader();
        return (sPacketHeader & 0xFF00000000L) >> 32;
    }

    final int readPacketFlag() {
        long sPacketHeader = this.getPacketHeader();
        return (int)((sPacketHeader & 0xC0000000L) >> 30);
    }

    final int readPacketLength() {
        long sPacketHeader = this.getPacketHeader();
        return (int)(sPacketHeader & 0x3FFFFFFFL);
    }
}

