/*
 * Decompiled with CFR 0.152.
 */
package com.machbase.jdbc;

import com.machbase.jdbc.MachByteFunc;
import com.machbase.jdbc.MachProtocol;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.TimeZone;

class MachColumnData {
    private byte[] data;
    private int type;
    private int index;
    private byte inoutType = 1;
    static final byte SQL_PARAM_INPUT = 1;
    static final byte SQL_PARAM_INPUT_OUTPUT = 2;
    static final byte SQL_PARAM_OUTPUT = 4;

    MachColumnData(int i, int t, byte[] b) {
        this.type = t;
        this.data = b;
        this.index = i;
    }

    MachColumnData(byte[] b) {
        this.type = 0;
        this.data = b;
    }

    MachColumnData(int t, byte[] b) {
        this.type = t;
        this.data = b;
    }

    public void setInOutType(byte t) {
        this.inoutType = t;
    }

    public byte[] getData() {
        return this.data;
    }

    public int getType() {
        return this.type;
    }

    public int getIndex() {
        return this.index;
    }

    public void dump() {
        if (this.data == null) {
            return;
        }
        for (int i = 0; i < this.data.length; ++i) {
            System.out.format("data[%d] = %02X\n", i, this.data[i]);
        }
    }

    private static boolean isV4Mapped(byte[] bytes) {
        if (bytes != null && bytes.length == 16) {
            int i;
            for (i = 0; i < 10; ++i) {
                if (bytes[i] == 0) continue;
                return false;
            }
            for (i = 10; i < 12; ++i) {
                if (bytes[i] == -1) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private static boolean isV4Compat(byte[] aIp) {
        Inet6Address sAddr = null;
        try {
            sAddr = Inet6Address.getByAddress(null, aIp, 0);
        }
        catch (UnknownHostException e) {
            return false;
        }
        if (!sAddr.isIPv4CompatibleAddress()) {
            return false;
        }
        byte[] bytes = sAddr.getAddress();
        return bytes[12] != 0 || bytes[13] != 0 || bytes[14] != 0 || bytes[15] != 0 && bytes[15] != 1;
    }

    private int getAllocSize(int len) {
        int alloc_size = len;
        switch (this.type) {
            case 24: {
                alloc_size = 0;
                break;
            }
            case 4: 
            case 40: 
            case 104: {
                alloc_size = 2;
                break;
            }
            case 8: 
            case 16: 
            case 108: {
                alloc_size = 4;
                break;
            }
            case 12: 
            case 20: 
            case 112: {
                alloc_size = 8;
                break;
            }
            case 5: 
            case 49: 
            case 61: 
            case 97: {
                alloc_size = 256;
                if (len <= alloc_size) break;
                alloc_size = len;
                break;
            }
            case 6: {
                alloc_size = 8;
                break;
            }
            case 32: {
                alloc_size = 5;
                break;
            }
            case 36: {
                alloc_size = 17;
            }
        }
        return alloc_size;
    }

    public byte[] getBindValue() {
        if (this.data == null) {
            int len;
            int alloc_size = len = 0;
            byte[] b = new byte[]{(byte)this.index, this.inoutType, (byte)this.type, (byte)(alloc_size >>> 24), (byte)(alloc_size >>> 16), (byte)(alloc_size >>> 8), (byte)alloc_size, (byte)(len >>> 24), (byte)(len >>> 16), (byte)(len >>> 8), (byte)len};
            return b;
        }
        int len = this.data.length;
        int alloc_size = this.getAllocSize(len);
        byte[] b = new byte[11 + len];
        b[0] = (byte)this.index;
        b[1] = this.inoutType;
        b[2] = (byte)this.type;
        b[3] = (byte)(alloc_size >>> 24);
        b[4] = (byte)(alloc_size >>> 16);
        b[5] = (byte)(alloc_size >>> 8);
        b[6] = (byte)alloc_size;
        b[7] = (byte)(len >>> 24);
        b[8] = (byte)(len >>> 16);
        b[9] = (byte)(len >>> 8);
        b[10] = (byte)len;
        System.arraycopy(this.data, 0, b, 11, len);
        return b;
    }

    public static String changeCharset(byte[] source, String toCharset) throws SQLException {
        CharBuffer sBuf = CharBuffer.wrap(new String(source).toCharArray());
        Charset charset = Charset.forName(toCharset);
        return new String(charset.encode(sBuf).array());
    }

    public String getChar() throws SQLException {
        return this.getChar(null);
    }

    public String getChar(String charset) throws SQLException {
        if (this.data == null) {
            return null;
        }
        if (charset == null) {
            return new String(this.data).trim();
        }
        return MachColumnData.changeCharset(this.data, charset).trim();
    }

    public String getString() throws SQLException {
        return this.getString(null, false, 0L);
    }

    public String getString(boolean aUseTimezone, long aTimezoneSec) throws SQLException {
        return this.getString(null, aUseTimezone, aTimezoneSec);
    }

    public String getString(String charset) throws SQLException {
        return this.getString(charset, false, 0L);
    }

    public String getString(String charset, boolean aUseTimezone, long aTimezoneSec) throws SQLException {
        switch (this.type) {
            case 5: 
            case 49: 
            case 61: 
            case 97: {
                return this.getChar(charset);
            }
            case 4: 
            case 40: {
                short value = this.getShortValue();
                if (value == Short.MIN_VALUE) {
                    return "NULL";
                }
                return Short.toString(value);
            }
            case 104: {
                int sVal = this.getUShortValue();
                return sVal == 65535 ? "NULL" : Integer.toString(sVal);
            }
            case 8: {
                int value = this.getIntValue();
                if (value == Integer.MIN_VALUE) {
                    return "NULL";
                }
                return Integer.toString(value);
            }
            case 108: {
                long sVal = this.getUIntValue();
                return sVal == 0xFFFFFFFFL ? "NULL" : Long.toString(sVal);
            }
            case 12: {
                long value = this.getLongValue();
                if (value == Long.MIN_VALUE) {
                    return "NULL";
                }
                return Long.toString(value);
            }
            case 112: {
                BigInteger sVal = this.getULongValue();
                return sVal.compareTo(new BigInteger(1, MachProtocol.MCB_ULONG_NULL_BYTE)) == 0 ? "NULL" : sVal.toString();
            }
            case 16: {
                float value = this.getFloatValue();
                if (value == Float.MAX_VALUE) {
                    return "NULL";
                }
                return Float.toString(value);
            }
            case 20: {
                double value = this.getDoubleValue();
                if (value == Double.MAX_VALUE) {
                    return "NULL";
                }
                return Double.toString(value);
            }
            case 6: {
                long value = this.getLongValue();
                if (value == -1L) {
                    return "NULL";
                }
                return this.getDatetoString(aUseTimezone, aTimezoneSec);
            }
            case 32: {
                return this.getIpv4();
            }
            case 36: {
                return this.getIpv6();
            }
        }
        throw new SQLException("unknown SQL type : " + String.valueOf(this.type));
    }

    public Object getObject() throws SQLException {
        switch (this.type) {
            case 5: 
            case 49: 
            case 61: 
            case 97: {
                return this.getChar();
            }
            case 4: 
            case 40: {
                return new Short(this.getShort());
            }
            case 8: {
                return new Integer(this.getInt());
            }
            case 12: {
                return new Long(this.getLong());
            }
            case 16: {
                return new Float(this.getFloat());
            }
            case 20: {
                return new Double(this.getDouble());
            }
            case 6: {
                return this.getTimestamp();
            }
            case 32: {
                return this.getIpv4();
            }
            case 36: {
                return this.getIpv6();
            }
        }
        throw new SQLException("unknown SQL type : " + String.valueOf(this.type));
    }

    public Date getDate() throws SQLException {
        this.checkDate();
        long time_t = this.getLongValue();
        if (time_t == -1L) {
            return null;
        }
        long milliTime = time_t / 1000000L;
        return new Date(milliTime);
    }

    public Time getTime() throws SQLException {
        this.checkDate();
        long time_t = this.getLongValue();
        if (time_t == -1L) {
            return null;
        }
        long milliTime = time_t / 1000000L;
        return new Time(milliTime);
    }

    public Timestamp getTimestamp() throws SQLException {
        this.checkDate();
        long time_t = this.getLongValue();
        if (time_t == -1L) {
            return null;
        }
        long milliTime = time_t / 1000000L;
        return new Timestamp(milliTime);
    }

    public String getDatetoString() throws SQLException {
        return this.getDatetoString(false, 0L);
    }

    public String getDatetoString(boolean aUseTimezone, long aTimezoneSec) throws SQLException {
        this.checkDate();
        long time_t = this.getLongValue();
        if (time_t == -1L) {
            return null;
        }
        long milliTime = time_t / 1000000L;
        long microSeconds = time_t / 1000L % 1000L;
        long nanoSeconds = time_t % 1000L;
        SimpleDateFormat sSdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss SSS");
        if (aUseTimezone) {
            TimeZone tmpTimezone = TimeZone.getDefault();
            tmpTimezone.setRawOffset((int)aTimezoneSec * 1000);
            sSdf.setTimeZone(tmpTimezone);
        }
        Date date = new Date(milliTime);
        String timeString = sSdf.format(date).toString();
        return String.format("%s:%03d:%03d", timeString, microSeconds, nanoSeconds);
    }

    public String getTimetoString() throws SQLException {
        this.checkDate();
        long time_t = this.getLongValue();
        if (time_t == -1L) {
            return null;
        }
        long milliTime = time_t / 1000000L;
        long microSeconds = time_t / 1000L % 1000L;
        long nanoSeconds = time_t % 1000L;
        Date date = new Date(milliTime);
        String timeString = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss SSS").format(date).toString();
        return String.format("%s:%03d:%03d", timeString, microSeconds, nanoSeconds);
    }

    public String getTimestamptoString() throws SQLException {
        this.checkDate();
        long time_t = this.getLongValue();
        if (time_t == -1L) {
            return null;
        }
        long milliTime = time_t / 1000000L;
        long microSeconds = time_t / 1000L % 1000L;
        long nanoSeconds = time_t % 1000L;
        Date date = new Date(milliTime);
        String timeString = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss SSS").format(date).toString();
        return String.format("%s:%03d:%03d", timeString, microSeconds, nanoSeconds);
    }

    public short getShortValue() throws SQLException {
        int val = 0;
        switch (this.type) {
            case 8: {
                int x = this.getIntValue();
                val = (short)(x == Integer.MIN_VALUE ? Short.MIN_VALUE : (short)x);
                break;
            }
            case 12: {
                long l = this.getLongValue();
                val = (short)(l == Long.MIN_VALUE ? Short.MIN_VALUE : (short)l);
                break;
            }
            case 16: {
                float f = this.getFloatValue();
                val = (short)(f == Float.MAX_VALUE ? Short.MIN_VALUE : (short)f);
                break;
            }
            case 20: {
                double d = this.getDoubleValue();
                val = (short)(d == Double.MAX_VALUE ? Short.MIN_VALUE : (short)d);
                break;
            }
            default: {
                int cnt = 0;
                for (int i = 1; i >= 0; --i) {
                    if (i > 0) {
                        short tmp = (short)(MachByteFunc.uInt(this.data[cnt++]) << i * 8);
                        val = (short)(val + tmp);
                        continue;
                    }
                    val = (short)(val + MachByteFunc.uInt(this.data[cnt++]));
                }
            }
        }
        return (short)val;
    }

    public int getUShortValue() throws SQLException {
        int val = 0;
        switch (this.type) {
            case 108: {
                long x = this.getUIntValue();
                val = x == 0xFFFFFFFFL ? 65535 : (int)x;
                break;
            }
            case 112: {
                BigInteger b = this.getULongValue();
                val = b.compareTo(new BigInteger(1, MachProtocol.MCB_ULONG_NULL_BYTE)) == 0 ? 65535 : b.intValue();
                break;
            }
            case 16: {
                float f = this.getFloatValue();
                val = f == Float.MAX_VALUE ? 65535 : (int)f;
                break;
            }
            case 20: {
                double d = this.getDoubleValue();
                val = d == Double.MAX_VALUE ? 65535 : (int)d;
                break;
            }
            default: {
                int cnt = 0;
                for (int i = 1; i >= 0; --i) {
                    if (i > 0) {
                        int tmp = MachByteFunc.uInt(this.data[cnt++]) << i * 8;
                        val += tmp;
                        continue;
                    }
                    val += MachByteFunc.uInt(this.data[cnt++]);
                }
            }
        }
        return val;
    }

    public int getIntValue() throws SQLException {
        int val = 0;
        switch (this.type) {
            case 4: 
            case 40: {
                short s = this.getShortValue();
                val = s == Short.MIN_VALUE ? Integer.MIN_VALUE : (int)s;
                break;
            }
            case 12: {
                long l = this.getLongValue();
                val = l == Long.MIN_VALUE ? Integer.MIN_VALUE : (int)l;
                break;
            }
            case 16: {
                float f = this.getFloatValue();
                val = f == Float.MAX_VALUE ? Integer.MIN_VALUE : (int)f;
                break;
            }
            case 20: {
                double d = this.getDoubleValue();
                val = d == Double.MAX_VALUE ? Integer.MIN_VALUE : (int)d;
                break;
            }
            case 104: 
            case 108: 
            case 112: {
                long sTmp = this.getUIntValue();
                val = sTmp == 0xFFFFFFFFL ? Integer.MIN_VALUE : (int)sTmp;
                break;
            }
            default: {
                int cnt = 0;
                for (int i = 3; i >= 0; --i) {
                    if (i > 0) {
                        int tmp = MachByteFunc.uInt(this.data[cnt++]) << i * 8;
                        val += tmp;
                        continue;
                    }
                    val += MachByteFunc.uInt(this.data[cnt++]);
                }
            }
        }
        return val;
    }

    public long getUIntValue() throws SQLException {
        long val = 0L;
        switch (this.type) {
            case 104: {
                int s = this.getUShortValue();
                val = s == 65535 ? 0xFFFFFFFFL : (long)s;
                break;
            }
            case 112: {
                BigInteger b = this.getULongValue();
                val = b.compareTo(new BigInteger(1, MachProtocol.MCB_ULONG_NULL_BYTE)) == 0 ? 0xFFFFFFFFL : b.longValue();
                break;
            }
            case 16: {
                float f = this.getFloatValue();
                val = f == Float.MAX_VALUE ? 0xFFFFFFFFL : (long)f;
                break;
            }
            case 20: {
                double d = this.getDoubleValue();
                val = d == Double.MAX_VALUE ? 0xFFFFFFFFL : (long)d;
                break;
            }
            default: {
                int cnt = 0;
                for (int i = 3; i >= 0; --i) {
                    if (i > 0) {
                        long tmp = MachByteFunc.uLong(this.data[cnt++]) << i * 8;
                        val += tmp;
                        continue;
                    }
                    val += MachByteFunc.uLong(this.data[cnt++]);
                }
            }
        }
        return val;
    }

    public long getLongValue() throws SQLException {
        long val = 0L;
        switch (this.type) {
            case 4: 
            case 40: {
                short s = this.getShortValue();
                val = s == Short.MIN_VALUE ? Long.MIN_VALUE : (long)s;
                break;
            }
            case 8: {
                int x = this.getIntValue();
                val = x == Integer.MIN_VALUE ? Long.MIN_VALUE : (long)x;
                break;
            }
            case 16: {
                float f = this.getFloatValue();
                val = f == Float.MAX_VALUE ? Long.MIN_VALUE : (long)f;
                break;
            }
            case 20: {
                double d = this.getDoubleValue();
                val = d == Double.MAX_VALUE ? Long.MIN_VALUE : (long)d;
                break;
            }
            case 104: 
            case 108: 
            case 112: {
                BigInteger sTmp = this.getULongValue();
                val = sTmp.compareTo(new BigInteger(1, MachProtocol.MCB_ULONG_NULL_BYTE)) == 0 ? Long.MIN_VALUE : this.getULongValue().longValue();
                break;
            }
            default: {
                int cnt = 0;
                for (int i = 7; i >= 0; --i) {
                    if (i > 0) {
                        long tmp = MachByteFunc.uLong(this.data[cnt++]) << i * 8;
                        val += tmp;
                        continue;
                    }
                    val += MachByteFunc.uLong(this.data[cnt++]);
                }
            }
        }
        return val;
    }

    public BigInteger getULongValue() throws SQLException {
        BigInteger sBig = null;
        switch (this.type) {
            case 104: {
                int s = this.getUShortValue();
                if (s == 65535) {
                    sBig = new BigInteger(1, MachProtocol.MCB_ULONG_NULL_BYTE);
                    break;
                }
                sBig = BigInteger.valueOf(s);
                break;
            }
            case 108: {
                long x = this.getUIntValue();
                if (x == 0xFFFFFFFFL) {
                    sBig = new BigInteger(1, MachProtocol.MCB_ULONG_NULL_BYTE);
                    break;
                }
                sBig = BigInteger.valueOf(x);
                break;
            }
            case 16: {
                float f = this.getFloatValue();
                if (f == Float.MAX_VALUE) {
                    sBig = new BigInteger(1, MachProtocol.MCB_ULONG_NULL_BYTE);
                    break;
                }
                sBig = BigInteger.valueOf((long)f);
                break;
            }
            case 20: {
                double d = this.getDoubleValue();
                if (d == Double.MAX_VALUE) {
                    sBig = new BigInteger(1, MachProtocol.MCB_ULONG_NULL_BYTE);
                    break;
                }
                sBig = BigInteger.valueOf((long)d);
                break;
            }
            default: {
                sBig = new BigInteger(1, this.data);
            }
        }
        return sBig;
    }

    public String getIpv4() throws SQLException {
        String ipv4 = null;
        int length = MachByteFunc.uInt(this.data[0]);
        ipv4 = length == 0 ? null : String.format("%d.%d.%d.%d", MachByteFunc.uInt(this.data[1]), MachByteFunc.uInt(this.data[2]), MachByteFunc.uInt(this.data[3]), MachByteFunc.uInt(this.data[4]));
        return ipv4;
    }

    public String getIpv6() throws SQLException {
        String ipv6 = null;
        int length = MachByteFunc.uInt(this.data[0]);
        if (length == 0) {
            ipv6 = null;
        } else {
            try {
                boolean sV4Mapped = false;
                boolean sV4Compat = false;
                byte[] sTmp = new byte[16];
                System.arraycopy(this.data, 1, sTmp, 0, 16);
                sV4Mapped = MachColumnData.isV4Mapped(sTmp);
                sV4Compat = MachColumnData.isV4Compat(sTmp);
                if (sV4Mapped || sV4Compat) {
                    ipv6 = String.format("::%s%d.%d.%d.%d", sV4Mapped ? "ffff:" : "", MachByteFunc.uInt(sTmp[12]), MachByteFunc.uInt(sTmp[13]), MachByteFunc.uInt(sTmp[14]), MachByteFunc.uInt(sTmp[15]));
                } else {
                    InetAddress sAddr = InetAddress.getByAddress(sTmp);
                    ipv6 = sAddr.toString().substring(1);
                    ipv6 = ipv6.replaceAll("((?::0\\b){2,}):?(?!\\S*\\b\\1:0\\b)(\\S*)", "::$2");
                }
            }
            catch (UnknownHostException e) {
                ipv6 = null;
            }
        }
        return ipv6;
    }

    public float getFloatValue() throws SQLException {
        float val = 0.0f;
        switch (this.type) {
            case 4: 
            case 40: {
                short s = this.getShortValue();
                val = s == Short.MIN_VALUE ? Float.MAX_VALUE : (float)s;
                break;
            }
            case 8: {
                int x = this.getIntValue();
                val = x == Integer.MIN_VALUE ? Float.MAX_VALUE : (float)x;
                break;
            }
            case 12: {
                long l = this.getLongValue();
                val = l == Long.MIN_VALUE ? Float.MAX_VALUE : (float)l;
                break;
            }
            case 20: {
                double d = this.getDoubleValue();
                val = d == Double.MAX_VALUE ? Float.MAX_VALUE : (float)d;
                break;
            }
            default: {
                val = ByteBuffer.wrap(this.data).getFloat();
            }
        }
        return val;
    }

    public double getDoubleValue() throws SQLException {
        double val = 0.0;
        switch (this.type) {
            case 4: 
            case 40: {
                short s = this.getShortValue();
                val = s == Short.MIN_VALUE ? Double.MAX_VALUE : (double)s;
                break;
            }
            case 8: {
                int x = this.getIntValue();
                val = x == Integer.MIN_VALUE ? Double.MAX_VALUE : (double)x;
                break;
            }
            case 12: {
                long l = this.getLongValue();
                val = l == Long.MIN_VALUE ? Double.MAX_VALUE : (double)l;
                break;
            }
            case 16: {
                float f = this.getFloatValue();
                val = f == Float.MAX_VALUE ? Double.MAX_VALUE : (double)f;
                break;
            }
            default: {
                val = ByteBuffer.wrap(this.data).getDouble();
            }
        }
        return val;
    }

    public short getShort() throws SQLException {
        boolean f = this.checkNumeric();
        if (f) {
            String d = this.getNumeric();
            return Short.parseShort(d);
        }
        return this.getShortValue();
    }

    public int getUShort() throws SQLException {
        return this.getUShortValue();
    }

    public int getInt() throws SQLException {
        boolean f = this.checkNumeric();
        if (f) {
            String d = this.getNumeric();
            return Integer.parseInt(d);
        }
        return this.getIntValue();
    }

    public long getUInt() throws SQLException {
        return this.getUIntValue();
    }

    public long getLong() throws SQLException {
        boolean f = this.checkNumeric();
        if (f) {
            String d = this.getNumeric();
            return Long.parseLong(d);
        }
        return this.getLongValue();
    }

    public BigInteger getULong() throws SQLException {
        return this.getULongValue();
    }

    public float getFloat() throws SQLException {
        boolean f = this.checkNumeric();
        String d = "";
        d = f ? this.getNumeric() : Float.toString(this.getFloatValue());
        return Float.parseFloat(d);
    }

    public double getDouble() throws SQLException {
        boolean f = this.checkNumeric();
        String d = "";
        d = f ? this.getNumeric() : Double.toString(this.getDoubleValue());
        return Double.parseDouble(d);
    }

    public BigDecimal getBigDecimal() throws SQLException {
        boolean f = this.checkNumeric();
        String d = "";
        d = f ? this.getNumeric() : Integer.toString(this.getIntValue());
        return new BigDecimal(d);
    }

    public String getNumeric() throws SQLException {
        return null;
    }

    private boolean checkNumeric() throws SQLException {
        if (this.type == 68 || this.type == 72) {
            return true;
        }
        if (this.type == 40 || this.type == 4 || this.type == 104 || this.type == 8 || this.type == 108 || this.type == 12 || this.type == 112 || this.type == 16 || this.type == 20) {
            return false;
        }
        throw new SQLException("mismatched data type.");
    }

    private void checkDate() throws SQLException {
        if (this.type != 6) {
            throw new SQLException("mismatched data type.");
        }
    }
}

