/*
 * Decompiled with CFR 0.152.
 */
package com.machbase.jdbc;

import com.machbase.jdbc.HostInfo;
import com.machbase.jdbc.MachCallableStatement;
import com.machbase.jdbc.MachDatabaseMetaData;
import com.machbase.jdbc.MachPooledConnection;
import com.machbase.jdbc.MachPreparedStatement;
import com.machbase.jdbc.MachProtocol;
import com.machbase.jdbc.MachSql;
import com.machbase.jdbc.MachStatement;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.SQLClientInfoException;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Struct;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class MachConnection
implements Connection {
    protected String database = null;
    private int STMT_MAX_NUM = 1024;
    private long TIMEOUT_MAX = 3600000L;
    private String encoding = "US7ASCII";
    private String charset = null;
    private Hashtable<Statement, Statement> statementHash = new Hashtable();
    private Hashtable<Integer, Statement> statementIndex = new Hashtable();
    private boolean autocommit = true;
    private int[] stmtId = new int[this.STMT_MAX_NUM + 1];
    private int connectionTimeout = 30000;
    private int socketTimeout = 1800000;
    private long timezoneSec = 0L;
    private String timezoneString = "";
    public MachProtocol machProt = null;
    public String url = null;
    public String user = null;
    public String password = null;
    public int version = 0;
    public int showHiddenCols = 0;
    public int useMachbaseType = 0;
    public String versionString = null;
    public long serverEndian = -1L;
    public long sessionId = -1L;
    private MachSql machSql;
    private MachPooledConnection pooledConn = null;
    public ArrayList<HostInfo> hostList = new ArrayList();
    public Properties connProp = null;
    private FileWriter logFileWriter = null;
    private Boolean logFlag = false;
    private Object lockObj = new Object();
    public ScheduledExecutorService scheduler = Executors.newSingleThreadScheduledExecutor();
    public ScheduledFuture<?> timeHandle = null;

    private void initLog() {
        String machhome = System.getenv("MACHBASE_HOME");
        String home = System.getenv("HOME");
        String userprofile = System.getenv("USERPROFILE");
        String path = "";
        path = machhome != null && machhome.length() > 0 ? machhome + "/trc" : (home != null && home.length() > 0 ? home + "/machbase_trc" : (userprofile != null && userprofile.length() > 0 ? userprofile + "/machbase_trc" : "/machbase_trc"));
        File logDir = new File(path);
        if (!logDir.exists()) {
            try {
                logDir.mkdirs();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        try {
            this.logFileWriter = new FileWriter(path + "/jdbc.log", true);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void writeLog(String log) {
        if (this.logFileWriter == null) {
            this.initLog();
        }
        try {
            this.logFileWriter.write(log + "\n");
            this.logFileWriter.flush();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void writeLogWithDate(String log) {
        Date today = new Date();
        SimpleDateFormat dateformat = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss");
        if (this.getLogFlag().booleanValue()) {
            this.writeLog("[" + dateformat.format(today) + "] " + log);
        }
    }

    public void writeLogWithDate(String log, int id) {
        Date today = new Date();
        SimpleDateFormat dateformat = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss");
        if (this.getLogFlag().booleanValue()) {
            this.writeLog("[" + dateformat.format(today) + " sid:" + id + "] " + log);
        }
    }

    private void setLogFlag(Boolean flag) {
        this.logFlag = flag;
    }

    public Boolean getLogFlag() {
        return this.logFlag;
    }

    public Object getLock() {
        return this.lockObj;
    }

    public MachConnection(String u, String host, int port, String db, Properties p) throws SQLException {
        int sMaxNum;
        int qIdx;
        String sMaxStmt = "";
        boolean sRandomHost = false;
        this.url = u;
        this.user = p.getProperty("user", "sys").toUpperCase();
        this.password = p.getProperty("password", "manager").toUpperCase();
        this.charset = p.getProperty("characterEncoding", this.charset);
        sMaxStmt = p.getProperty("maxStatements", sMaxStmt);
        this.connectionTimeout = (int)(Float.parseFloat(p.getProperty("CONNECTION_TIMEOUT", String.valueOf(this.connectionTimeout / 1000))) * 1000.0f);
        this.timezoneString = p.getProperty("TIMEZONE", "");
        if (!this.timezoneString.isEmpty() && this.checkTimeZone(this.timezoneString)) {
            this.timezoneSec = this.convertTimeZone(this.timezoneString);
        }
        sRandomHost = p.getProperty("randomHost", "") == "true";
        this.hostList.add(new HostInfo(host, port));
        this.connProp = p;
        Pattern sPattern = Pattern.compile("([0-9a-zA-Z.-]+)[:]([0-9]+)");
        Matcher sMatcher = sPattern.matcher(u);
        while (sMatcher.find()) {
            if (sMatcher.group(1).equals(host) && Integer.parseInt(sMatcher.group(2)) == port) continue;
            this.hostList.add(new HostInfo(sMatcher.group(1), Integer.parseInt(sMatcher.group(2))));
        }
        if (sRandomHost) {
            HostInfo first = this.hostList.get(0);
            int idx = (int)(Math.random() * (double)this.hostList.size());
            this.hostList.set(0, this.hostList.get(idx));
            this.hostList.set(idx, first);
        }
        if (p.getProperty("showHost", "") == "true") {
            System.out.println("MachConnection init host : " + this.hostList.get(0).getHost() + ", port : " + this.hostList.get(0).getPort());
        }
        if ((qIdx = this.url.indexOf(63)) > 0) {
            int i;
            String param = this.url.substring(qIdx + 1);
            do {
                String sKey;
                String sVal;
                if ((i = param.indexOf(38)) < 0) {
                    sVal = param.substring(0);
                } else {
                    sVal = param.substring(0, i);
                    param = param.substring(i + 1);
                }
                int sDeli = sVal.indexOf(61);
                if (sDeli == -1) {
                    sKey = sVal.trim();
                    sVal = "";
                } else {
                    sKey = sVal.substring(0, sDeli).trim();
                    sVal = sVal.substring(1 + sDeli).trim();
                }
                if (sKey.equalsIgnoreCase("SHOW_HIDDEN_COLS") && sVal.equals("1")) {
                    this.showHiddenCols = 1;
                }
                if (sKey.equalsIgnoreCase("USE_MACHBASE_TYPE") && sVal.equals("1")) {
                    this.useMachbaseType = 1;
                }
                if (sKey.equalsIgnoreCase("LOGSQL") && sVal.equalsIgnoreCase("TRUE")) {
                    this.setLogFlag(true);
                }
                if (sKey.equalsIgnoreCase("characterEncoding")) {
                    this.charset = sVal;
                }
                if (sKey.equalsIgnoreCase("maxStatements")) {
                    sMaxStmt = sVal;
                }
                if (sKey.equalsIgnoreCase("CONNECTION_TIMEOUT")) {
                    this.connectionTimeout = (int)(Float.parseFloat(sVal) * 1000.0f);
                    if (this.connectionTimeout < 0) {
                        throw new IllegalArgumentException("timeout value must be greater than 0.");
                    }
                    if (this.connectionTimeout == 0) {
                        this.connectionTimeout = Integer.MAX_VALUE;
                    }
                }
                if (sKey.equalsIgnoreCase("SOCKET_TIMEOUT")) {
                    this.socketTimeout = (int)(Float.parseFloat(sVal) * 1000.0f);
                    if (this.socketTimeout == 0) {
                        this.socketTimeout = Integer.MAX_VALUE;
                    }
                }
                if (!sKey.equalsIgnoreCase("TIMEZONE")) continue;
                this.timezoneString = sVal;
                if (this.timezoneString.isEmpty() || !this.checkTimeZone(this.timezoneString)) continue;
                this.timezoneSec = this.convertTimeZone(this.timezoneString);
            } while (i > 0);
        }
        if (sMaxStmt != "" && (sMaxNum = Integer.parseInt(sMaxStmt) * 2 + 1) > 1024) {
            this.STMT_MAX_NUM = sMaxNum;
            this.stmtId = new int[this.STMT_MAX_NUM + 1];
        }
        try {
            this.setCatalog(db);
            this.machProt = new MachProtocol(this);
        }
        catch (SQLException e) {
            throw new SQLException(String.format("cannot connect to server on %s\n%s\n", this.getHostListString(), e.getMessage()));
        }
        for (int k = 0; k < this.STMT_MAX_NUM; ++k) {
            this.stmtId[k] = 0;
        }
        this.machProt.init();
        this.machProt.connect(this.user, this.password);
        this.machSql = new MachSql();
        if (this.STMT_MAX_NUM > 1024) {
            Statement sStmt = this.createStatement();
            sStmt.execute("alter session set max_stmt_count=" + String.valueOf(this.STMT_MAX_NUM + 1));
            sStmt.close();
        }
    }

    public String getHostListString() {
        String sHostListString = "";
        for (HostInfo sHostInfo : this.hostList) {
            sHostListString = sHostListString + sHostInfo.getHost() + ":" + sHostInfo.getPort() + "\n";
        }
        sHostListString = sHostListString.substring(0, sHostListString.length() - 1);
        return sHostListString;
    }

    public String parseSql(String sql) {
        return this.machSql.parse(sql);
    }

    synchronized void setPooledConnection(MachPooledConnection aPooledConn) {
        this.pooledConn = aPooledConn;
    }

    public int getConnectionTimeout() {
        return this.connectionTimeout;
    }

    public int getSocketTimeout() {
        return this.socketTimeout;
    }

    private boolean checkTimeZone(String aTimeZone) {
        return aTimeZone.matches("^[+-][0-2][0-3][0-5][0-9]$");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Statement createStatement() throws SQLException {
        Object object = this.lockObj;
        synchronized (object) {
            MachStatement stmt = new MachStatement(this);
            this.addStatement(stmt);
            return stmt;
        }
    }

    @Override
    public synchronized PreparedStatement prepareStatement(String sql) throws SQLException {
        MachPreparedStatement stmt = new MachPreparedStatement(this, sql);
        return stmt;
    }

    @Override
    public synchronized CallableStatement prepareCall(String sql) throws SQLException {
        MachCallableStatement stmt = new MachCallableStatement(this, sql);
        this.addStatement(stmt);
        return stmt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
        Object object = this.lockObj;
        synchronized (object) {
            if (resultSetType == 1005 || resultSetConcurrency == 1008) {
                throw new SQLException("this method not supported.");
            }
            MachStatement stmt = new MachStatement(this, resultSetType, resultSetConcurrency);
            this.addStatement(stmt);
            return stmt;
        }
    }

    @Override
    public synchronized Statement createStatement(int type, int concur, int holdable) throws SQLException {
        if (holdable == 1 && (type == 1005 || concur == 1008)) {
            throw new UnsupportedOperationException();
        }
        throw new SQLException("this method not supported.");
    }

    @Override
    public synchronized PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        if (resultSetType == 1005 || resultSetConcurrency == 1008) {
            throw new SQLException("this method not supported.");
        }
        MachPreparedStatement stmt = new MachPreparedStatement(this, sql, resultSetType, resultSetConcurrency);
        this.addStatement(stmt);
        return stmt;
    }

    @Override
    public synchronized PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
        return this.prepareStatement(sql);
    }

    @Override
    public synchronized PreparedStatement prepareStatement(String sql, int[] indexes) throws SQLException {
        return this.prepareStatement(sql);
    }

    @Override
    public synchronized PreparedStatement prepareStatement(String sql, String[] colName) throws SQLException {
        return this.prepareStatement(sql);
    }

    @Override
    public synchronized PreparedStatement prepareStatement(String sql, int type, int concur, int holdable) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public synchronized CallableStatement prepareCall(String unused, int resultSetType, int resultSetConcurrency) throws SQLException {
        throw new SQLException("stored procedures not supported.");
    }

    @Override
    public synchronized CallableStatement prepareCall(String sql, int type, int concur, int holdable) throws SQLException {
        throw new SQLException("stored procedures not supported.");
    }

    @Override
    public synchronized void releaseSavepoint(Savepoint savepoint) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public synchronized void rollback(Savepoint savepoint) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public synchronized Savepoint setSavepoint() throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public synchronized Savepoint setSavepoint(String name) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public synchronized void setHoldability(int holdable) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public synchronized int getHoldability() throws SQLException {
        return 2;
    }

    @Override
    public void setAutoCommit(boolean b) throws SQLException {
    }

    @Override
    public boolean getAutoCommit() throws SQLException {
        return this.autocommit;
    }

    @Override
    public void commit() throws SQLException {
        String sql = "commit";
        this.machProt.execDirect(sql);
    }

    @Override
    public void rollback() throws SQLException {
        String sql = "rollback";
        this.machProt.execDirect(sql);
    }

    @Override
    public synchronized void close() throws SQLException {
        this.machProt.disconnect();
    }

    @Override
    public synchronized boolean isClosed() throws SQLException {
        return this.machProt.getSocket() == null;
    }

    public long getTimezoneSec() {
        return this.timezoneSec;
    }

    public void setTimezoneSec(long aSec) {
        this.timezoneSec = aSec;
    }

    public String getTimezoneStr() {
        return this.timezoneString;
    }

    public void setTimezoneStr(String aZone) {
        this.timezoneString = aZone;
    }

    public long convertTimeZone(String aTimeZone) {
        long sTimeZone = 0L;
        String sSign = aTimeZone.substring(0, 1);
        int sHour = Integer.parseInt(aTimeZone.substring(1, 3));
        int sMin = Integer.parseInt(aTimeZone.substring(3, 5));
        sTimeZone = sHour * 3600 + sMin * 60;
        if (sSign.equals("-")) {
            sTimeZone *= -1L;
        }
        return sTimeZone;
    }

    @Override
    public DatabaseMetaData getMetaData() throws SQLException {
        return new MachDatabaseMetaData(this);
    }

    @Override
    public void setReadOnly(boolean b) throws SQLException {
    }

    @Override
    public boolean isReadOnly() throws SQLException {
        return false;
    }

    @Override
    public synchronized void setCatalog(String db) {
        this.database = db;
    }

    @Override
    public String getCatalog() {
        return this.database;
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        return null;
    }

    @Override
    public void clearWarnings() throws SQLException {
    }

    public void setTypeMap(Map map) throws SQLException {
        throw new SQLException("this method not supported.");
    }

    @Override
    public Map<String, Class<?>> getTypeMap() throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setTransactionIsolation(int unused) throws SQLException {
    }

    @Override
    public int getTransactionIsolation() throws SQLException {
        return 0;
    }

    @Override
    public String nativeSQL(String sql) throws SQLException {
        throw new SQLException("this method not supported.");
    }

    synchronized void addStatement(Statement s) {
        this.statementHash.put(s, s);
        this.statementIndex.put(((MachStatement)s).getStatementId(), s);
    }

    synchronized void removeStatement(Statement s) {
        this.statementHash.remove(s);
        this.statementIndex.remove(((MachStatement)s).getStatementId());
    }

    synchronized Statement getStatement(int stmtId) throws SQLException {
        Statement stmt = this.statementIndex.get(stmtId);
        if (stmt == null) {
            Date today = new Date();
            SimpleDateFormat dateformat = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss");
            throw new SQLException(String.format("[" + dateformat.format(today) + "] " + "There is no Statement with id : %d.", stmtId));
        }
        return stmt;
    }

    synchronized boolean isAvailableStmtId(int stmtId) {
        return this.statementIndex.get(stmtId) == null;
    }

    public void setVersion(String v) {
        this.versionString = v;
    }

    public MachProtocol getProtocol() {
        return this.machProt;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public String getCharset() {
        return this.charset;
    }

    public void setEndian(long aEndian) {
        this.serverEndian = aEndian;
    }

    public long getEndian() {
        return this.serverEndian;
    }

    public void setSessionId(long aSessionId) {
        this.sessionId = aSessionId;
    }

    public synchronized long getSessionId() throws SQLException {
        return this.sessionId;
    }

    public synchronized String getUser() throws SQLException {
        return this.user;
    }

    public void setUser(String u) {
        this.user = u;
    }

    public void setShowHiddenColumns(int aFlag) {
        this.showHiddenCols = aFlag;
    }

    public synchronized int getShowHiddenColumns() {
        return this.showHiddenCols;
    }

    public synchronized int getUseMachbaseType() {
        return this.useMachbaseType;
    }

    public synchronized String getPassword() throws SQLException {
        return this.password;
    }

    public synchronized int getStatementId() throws SQLException {
        for (int i = 0; i < this.STMT_MAX_NUM; ++i) {
            if (this.stmtId[i] != 0) continue;
            this.stmtId[i] = 1;
            return i;
        }
        throw new SQLException("exceeding maximum statement number.");
    }

    public synchronized void returnStatementId(int id) {
        this.stmtId[id] = 0;
    }

    @Override
    public Blob createBlob() throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Clob createClob() throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public NClob createNClob() throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Array createArrayOf(String arg0, Object[] arg1) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public SQLXML createSQLXML() throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Struct createStruct(String arg0, Object[] arg1) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Properties getClientInfo() throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getClientInfo(String arg0) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isValid(int aTimeout) throws SQLException, IllegalArgumentException {
        MachStatement sMcbStmt = (MachStatement)this.createStatement();
        try {
            if (aTimeout > 0) {
                this.timeHandle = this.scheduler.schedule(new ConnectionTimeout(this, sMcbStmt), (long)aTimeout, TimeUnit.SECONDS);
            } else if (aTimeout == 0) {
                this.timeHandle = this.scheduler.schedule(new ConnectionTimeout(this, sMcbStmt), this.TIMEOUT_MAX, TimeUnit.SECONDS);
            } else {
                if (sMcbStmt != null) {
                    sMcbStmt.close();
                }
                throw new IllegalArgumentException("timeout value must be greater than 0.");
            }
            sMcbStmt.execute("select count(*) from v$version");
            if (sMcbStmt != null) {
                sMcbStmt.close();
            }
            if (aTimeout >= 0 && this.timeHandle != null) {
                this.timeHandle.cancel(false);
                this.scheduler.shutdown();
                this.timeHandle = null;
                this.scheduler = Executors.newSingleThreadScheduledExecutor();
            }
        }
        catch (SQLException e) {
            throw new SQLException("connetion is not valid");
        }
        return true;
    }

    @Override
    public void setClientInfo(Properties arg0) throws SQLClientInfoException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setClientInfo(String arg0, String arg1) throws SQLClientInfoException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isWrapperFor(Class<?> arg0) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public <T> T unwrap(Class<T> arg0) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setSchema(String schema) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getSchema() throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void abort(Executor executor) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setNetworkTimeout(Executor executor, int milliseconds) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getNetworkTimeout() throws SQLException {
        throw new UnsupportedOperationException();
    }

    public int getStmtMaxNum() {
        return this.STMT_MAX_NUM;
    }

    public class ConnectionTimeout
    implements Runnable {
        MachConnection _mcbConn = null;
        MachStatement _stmtId = null;

        public ConnectionTimeout(MachConnection conn, MachStatement stmt) {
            this._mcbConn = conn;
            this._stmtId = stmt;
        }

        @Override
        public void run() {
            MachConnection.this.scheduler.shutdown();
            MachConnection.this.timeHandle = null;
            MachConnection.this.scheduler = Executors.newSingleThreadScheduledExecutor();
            throw new RuntimeException("connection timeout.");
        }
    }
}

