/*
 * Decompiled with CFR 0.152.
 */
package com.machbase.jdbc;

import com.machbase.jdbc.MachConnection;
import com.machbase.jdbc.MachDriver;
import com.machbase.jdbc.MachPoolDataSourceBase;
import com.machbase.jdbc.MachPooledConnection;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Properties;
import java.util.logging.Logger;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.Referenceable;
import javax.sql.ConnectionPoolDataSource;
import javax.sql.PooledConnection;

public class MachConnectionPoolDataSource
extends MachPoolDataSourceBase
implements Serializable,
ConnectionPoolDataSource,
Referenceable {
    public MachConnectionPoolDataSource() {
    }

    public MachConnectionPoolDataSource(Reference ref) {
        this.setProperties(ref);
    }

    public synchronized Connection getConnection() throws SQLException {
        PooledConnection sPoolConn = this.getPooledConnection(null, null);
        return sPoolConn.getConnection();
    }

    @Override
    public synchronized PooledConnection getPooledConnection() throws SQLException {
        return this.getPooledConnection(null, null);
    }

    @Override
    public synchronized PooledConnection getPooledConnection(String username, String passwd) throws SQLException {
        int sMax;
        MachPooledConnection pc = null;
        MachDriver driver = new MachDriver();
        Properties props = new Properties();
        if (username != null) {
            props.setProperty("user", username);
        } else {
            props.setProperty("user", this.getUser());
        }
        if (passwd != null) {
            props.setProperty("password", passwd);
        } else {
            props.setProperty("password", this.getPassword());
        }
        String sCharset = this.getCharset();
        if (sCharset != null) {
            props.setProperty("characterEncoding", sCharset);
        }
        if ((sMax = this.getMaxStatements()) > 0) {
            props.setProperty("maxStatements", String.valueOf(sMax));
        }
        MachConnection conn = (MachConnection)driver.connect(this.getUrl(), props);
        pc = new MachPooledConnection(conn);
        return pc;
    }

    @Override
    public synchronized Reference getReference() throws NamingException {
        Reference ref = new Reference(this.getClass().getName(), "com.machbase.jdbc.MachDataSourceObjectFactory", null);
        ref = this.getProperties(ref);
        return ref;
    }

    @Override
    public Logger getParentLogger() {
        throw new UnsupportedOperationException();
    }
}

