/*
 * Decompiled with CFR 0.152.
 */
package com.machbase.jdbc;

import com.machbase.jdbc.MachDataSourceBase;
import com.machbase.jdbc.MachDriver;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Properties;
import java.util.logging.Logger;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.Referenceable;
import javax.sql.DataSource;

public class MachDataSource
extends MachDataSourceBase
implements DataSource,
Referenceable,
Serializable {
    private String mDataSourceName = null;
    private Properties mProperties = null;
    private Properties prop = null;

    public MachDataSource() {
    }

    protected MachDataSource(Reference ref) {
        this.setProperties(ref);
    }

    protected MachDataSource(String aDataSourceName) {
        this.mDataSourceName = aDataSourceName;
        this.mProperties = new Properties();
        this.prop = new Properties();
    }

    Properties getProperties() {
        return this.mProperties;
    }

    Properties getProperties(Properties aProp) {
        Properties sProp = new Properties(this.mProperties);
        Enumeration<?> sEnum = aProp.propertyNames();
        while (sEnum.hasMoreElements()) {
            String sKey = (String)sEnum.nextElement();
            sProp.setProperty(sKey, aProp.getProperty(sKey));
        }
        return sProp;
    }

    @Override
    public Connection getConnection() throws SQLException {
        return this.getConnection(null, null);
    }

    @Override
    public Connection getConnection(String username, String password) throws SQLException {
        Connection con = null;
        MachDriver driver = new MachDriver();
        Properties props = new Properties();
        if (username != null) {
            props.setProperty("user", username);
        }
        if (password != null) {
            props.setProperty("password", password);
        }
        con = driver.connect(this.getUrl(), props);
        return con;
    }

    @Override
    public synchronized Reference getReference() throws NamingException {
        Reference ref = new Reference(this.getClass().getName(), "com.machbase.jdbc.DataSourceObjectFactory", null);
        ref = this.getProperties(ref);
        return ref;
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Logger getParentLogger() {
        throw new UnsupportedOperationException();
    }
}

