/*
 * Decompiled with CFR 0.152.
 */
package com.machbase.jdbc;

import com.machbase.jdbc.InfoResultSet;
import com.machbase.jdbc.MachConnection;
import com.machbase.jdbc.MachResultSet;
import com.machbase.jdbc.MachStatement;
import com.machbase.jdbc.MachTableMetaData;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.RowIdLifetime;
import java.sql.SQLException;
import java.util.Vector;

public class MachDatabaseMetaData
implements DatabaseMetaData {
    private MachConnection conn = null;
    private MachStatement stmt = null;

    MachDatabaseMetaData(MachConnection conn) {
        this.conn = conn;
    }

    @Override
    public boolean allProceduresAreCallable() throws SQLException {
        return false;
    }

    @Override
    public boolean allTablesAreSelectable() throws SQLException {
        return true;
    }

    @Override
    public String getURL() throws SQLException {
        return this.conn.url;
    }

    @Override
    public String getUserName() throws SQLException {
        return this.conn.user;
    }

    @Override
    public boolean isReadOnly() throws SQLException {
        return false;
    }

    @Override
    public boolean nullsAreSortedHigh() throws SQLException {
        return false;
    }

    @Override
    public boolean nullsAreSortedLow() throws SQLException {
        return true;
    }

    @Override
    public boolean nullsAreSortedAtStart() throws SQLException {
        return false;
    }

    @Override
    public boolean nullsAreSortedAtEnd() throws SQLException {
        return false;
    }

    @Override
    public String getDatabaseProductName() throws SQLException {
        return "Machbase";
    }

    @Override
    public String getDatabaseProductVersion() {
        String v = "3.0.1";
        String sql = "select binary_signature as v from v$version";
        try {
            MachStatement stmt = (MachStatement)this.conn.createStatement();
            MachResultSet rslt = (MachResultSet)stmt.executeQuery(sql);
            if (rslt != null) {
                rslt.next();
                v = rslt.getString(1);
                rslt.close();
            }
            if (stmt != null) {
                stmt.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return v;
    }

    @Override
    public String getDriverName() throws SQLException {
        return "Machbase JDBC Driver";
    }

    @Override
    public String getDriverVersion() throws SQLException {
        return "2.0.1";
    }

    @Override
    public int getDriverMajorVersion() {
        return 2;
    }

    @Override
    public int getDriverMinorVersion() {
        return 0;
    }

    @Override
    public boolean usesLocalFiles() throws SQLException {
        return false;
    }

    @Override
    public boolean usesLocalFilePerTable() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsMixedCaseIdentifiers() throws SQLException {
        return false;
    }

    @Override
    public boolean storesUpperCaseIdentifiers() throws SQLException {
        return true;
    }

    @Override
    public boolean storesLowerCaseIdentifiers() throws SQLException {
        return false;
    }

    @Override
    public boolean storesMixedCaseIdentifiers() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsMixedCaseQuotedIdentifiers() throws SQLException {
        return true;
    }

    @Override
    public boolean storesUpperCaseQuotedIdentifiers() throws SQLException {
        return false;
    }

    @Override
    public boolean storesLowerCaseQuotedIdentifiers() throws SQLException {
        return false;
    }

    @Override
    public boolean storesMixedCaseQuotedIdentifiers() throws SQLException {
        return true;
    }

    @Override
    public String getIdentifierQuoteString() throws SQLException {
        return "\"";
    }

    @Override
    public String getSQLKeywords() throws SQLException {
        return "ALIAS,DURATION,INDEX";
    }

    @Override
    public String getNumericFunctions() throws SQLException {
        return "ABS,AVG,COUNT,MAX,MIN,SUM";
    }

    @Override
    public String getStringFunctions() throws SQLException {
        return "LENGTH,LOWER,UPPER,TO_CHAR,TO_DATE,TO_HEX,SUBSTR";
    }

    @Override
    public String getSystemFunctions() throws SQLException {
        return "NVL,DECODE";
    }

    @Override
    public String getTimeDateFunctions() throws SQLException {
        return "ADD_TIME,SYSDATE,TO_DATE";
    }

    @Override
    public String getSearchStringEscape() throws SQLException {
        return "//";
    }

    @Override
    public String getExtraNameCharacters() throws SQLException {
        return "";
    }

    @Override
    public String getSchemaTerm() throws SQLException {
        return "schema";
    }

    @Override
    public String getProcedureTerm() throws SQLException {
        return "procedure";
    }

    @Override
    public String getCatalogTerm() throws SQLException {
        return "";
    }

    @Override
    public boolean isCatalogAtStart() throws SQLException {
        return true;
    }

    @Override
    public String getCatalogSeparator() throws SQLException {
        return "";
    }

    @Override
    public int getDefaultTransactionIsolation() throws SQLException {
        return 0;
    }

    @Override
    public synchronized ResultSet getAttributes(String catalog, String schemaPattern, String typeNamePattern, String attributeNamePattern) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public synchronized int getDatabaseMajorVersion() throws SQLException {
        return 1;
    }

    @Override
    public synchronized int getDatabaseMinorVersion() throws SQLException {
        return 0;
    }

    @Override
    public synchronized int getJDBCMajorVersion() throws SQLException {
        return 3;
    }

    @Override
    public synchronized int getJDBCMinorVersion() throws SQLException {
        return 0;
    }

    @Override
    public synchronized int getResultSetHoldability() throws SQLException {
        return 0;
    }

    @Override
    public synchronized int getSQLStateType() throws SQLException {
        return 2;
    }

    @Override
    public synchronized boolean locatorsUpdateCopy() throws SQLException {
        return false;
    }

    @Override
    public synchronized boolean supportsGetGeneratedKeys() throws SQLException {
        return false;
    }

    @Override
    public synchronized boolean supportsMultipleOpenResults() throws SQLException {
        return true;
    }

    @Override
    public synchronized boolean supportsNamedParameters() throws SQLException {
        return false;
    }

    @Override
    public synchronized boolean supportsResultSetHoldability(int holdability) throws SQLException {
        return holdability == 2 || holdability == 1;
    }

    @Override
    public synchronized boolean supportsSavepoints() throws SQLException {
        return true;
    }

    @Override
    public synchronized boolean supportsStatementPooling() throws SQLException {
        return false;
    }

    @Override
    public synchronized ResultSet getSuperTables(String catalog, String schemaPattern, String tableNamePattern) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public synchronized ResultSet getSuperTypes(String catalog, String schemaPattern, String typeNamePattern) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean supportsAlterTableWithAddColumn() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsAlterTableWithDropColumn() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsColumnAliasing() throws SQLException {
        return true;
    }

    @Override
    public boolean nullPlusNonNullIsNull() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsConvert() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsConvert(int fromType, int toType) throws SQLException {
        return false;
    }

    @Override
    public boolean supportsTableCorrelationNames() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsDifferentTableCorrelationNames() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsExpressionsInOrderBy() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsOrderByUnrelated() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsGroupBy() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsGroupByUnrelated() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsGroupByBeyondSelect() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsLikeEscapeClause() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsMultipleResultSets() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsMultipleTransactions() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsNonNullableColumns() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsMinimumSQLGrammar() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsCoreSQLGrammar() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsExtendedSQLGrammar() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsANSI92EntryLevelSQL() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsANSI92IntermediateSQL() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsANSI92FullSQL() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsIntegrityEnhancementFacility() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsOuterJoins() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsFullOuterJoins() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsLimitedOuterJoins() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsSchemasInDataManipulation() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsSchemasInProcedureCalls() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsSchemasInTableDefinitions() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsSchemasInIndexDefinitions() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsSchemasInPrivilegeDefinitions() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsCatalogsInDataManipulation() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsCatalogsInProcedureCalls() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsCatalogsInTableDefinitions() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsCatalogsInIndexDefinitions() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsCatalogsInPrivilegeDefinitions() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsPositionedDelete() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsPositionedUpdate() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsSelectForUpdate() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsStoredProcedures() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsSubqueriesInComparisons() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsSubqueriesInExists() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsSubqueriesInIns() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsSubqueriesInQuantifieds() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsCorrelatedSubqueries() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsUnion() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsUnionAll() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsOpenCursorsAcrossCommit() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsOpenCursorsAcrossRollback() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsOpenStatementsAcrossCommit() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsOpenStatementsAcrossRollback() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsTransactions() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsTransactionIsolationLevel(int level) throws SQLException {
        return level == 0;
    }

    @Override
    public int getMaxBinaryLiteralLength() throws SQLException {
        return 1000;
    }

    @Override
    public int getMaxCharLiteralLength() throws SQLException {
        return 2000;
    }

    @Override
    public int getMaxColumnNameLength() throws SQLException {
        return 30;
    }

    @Override
    public int getMaxColumnsInGroupBy() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxColumnsInIndex() throws SQLException {
        return 4;
    }

    @Override
    public int getMaxColumnsInOrderBy() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxColumnsInSelect() throws SQLException {
        return 4096;
    }

    @Override
    public int getMaxColumnsInTable() throws SQLException {
        return 200;
    }

    @Override
    public int getMaxConnections() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxCursorNameLength() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxIndexLength() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxSchemaNameLength() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxProcedureNameLength() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxCatalogNameLength() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxRowSize() throws SQLException {
        return 0;
    }

    @Override
    public boolean doesMaxRowSizeIncludeBlobs() throws SQLException {
        return true;
    }

    @Override
    public int getMaxStatementLength() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxStatements() throws SQLException {
        return 8;
    }

    @Override
    public int getMaxTableNameLength() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxTablesInSelect() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxUserNameLength() throws SQLException {
        return 8;
    }

    @Override
    public boolean supportsDataDefinitionAndDataManipulationTransactions() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsDataManipulationTransactionsOnly() throws SQLException {
        return false;
    }

    @Override
    public boolean dataDefinitionCausesTransactionCommit() throws SQLException {
        return true;
    }

    @Override
    public boolean dataDefinitionIgnoredInTransactions() throws SQLException {
        return false;
    }

    @Override
    public ResultSet getProcedures(String catalog, String schemaPattern, String procedureNamePattern) throws SQLException {
        String sSql = "SELECT '' as PROCEDURE_CAT, '' as PROCEDURE_SCHEM, '' as PROCEDURE_NAME, '' as REMARKS, 0 as PROCEDURE_TYPE FROM M$SYS_USERS WHERE USER_ID=-1";
        MachStatement stmt = (MachStatement)this.conn.createStatement();
        MachResultSet rslt = (MachResultSet)stmt.executeQuery(sSql);
        if (rslt != null) {
            rslt.closeStmt = true;
        }
        return rslt;
    }

    @Override
    public ResultSet getProcedureColumns(String catalog, String schemaPattern, String procedureNamePattern, String columnNamePattern) throws SQLException {
        throw new SQLException("stored procedures not supported.");
    }

    @Override
    public synchronized ResultSet getTables(String catalog, String schemaPattern, String table, String[] type) throws SQLException {
        String sql = "select '' as TABLE_CAT, u.NAME as TABLE_SCHEM, t.NAME as TABLE_NAME, 'TABLE' as TABLE_TYPE, decode(t.TYPE, 0, 'LOG TABLE', 1, 'META/VIRTUAL TABLE', 2, 'LOOKUP TABLE', 3, 'VOLATILE TABLE', 4, 'LOOKUP TABLE', 5, 'KV TABLE', 6, 'TAG TABLE', 'UNKNOWN') as REMARKS from M$SYS_TABLES as t, M$SYS_USERS as u WHERE t.USER_ID = u.USER_ID ";
        if (table != null) {
            if (table.indexOf("%") > -1) {
                sql = sql + "and t.NAME LIKE '" + table + "' ";
            } else if (table.compareTo("") != 0) {
                sql = sql + "and t.NAME=upper('" + table + "') ";
            }
        }
        if (schemaPattern != null) {
            if (schemaPattern.indexOf("%") > -1) {
                sql = sql + "and u.NAME LIKE '" + schemaPattern + "' ";
            } else if (schemaPattern.compareTo("") != 0) {
                sql = sql + "and u.NAME='" + schemaPattern + "' ";
            }
        }
        sql = sql + "order by t.NAME ";
        MachStatement stmt = (MachStatement)this.conn.createStatement();
        MachResultSet rslt = (MachResultSet)stmt.executeQuery(sql);
        if (rslt != null) {
            rslt.closeStmt = true;
        }
        return rslt;
    }

    @Override
    public synchronized ResultSet getSchemas() throws SQLException {
        String sql = "select NAME as TABLE_SCHEM, '' as TABLE_CATALOG from m$sys_users";
        MachStatement stmt = (MachStatement)this.conn.createStatement();
        MachResultSet rslt = (MachResultSet)stmt.executeQuery(sql);
        if (rslt != null) {
            rslt.closeStmt = true;
        }
        return rslt;
    }

    @Override
    public synchronized ResultSet getCatalogs() throws SQLException {
        String sql = "select '' as TABLE_CAT, 'NULL' as TABLE_QUALIFIER from m$sys_users limit 1";
        MachStatement stmt = (MachStatement)this.conn.createStatement();
        MachResultSet rslt = (MachResultSet)stmt.executeQuery(sql);
        if (rslt != null) {
            rslt.closeStmt = true;
        }
        return rslt;
    }

    @Override
    public ResultSet getTableTypes() throws SQLException {
        String sql = "select 'TABLE' as TABLE_TYPE from m$sys_users limit 1";
        MachStatement stmt = (MachStatement)this.conn.createStatement();
        MachResultSet rslt = (MachResultSet)stmt.executeQuery(sql);
        if (rslt != null) {
            rslt.closeStmt = true;
        }
        return rslt;
    }

    @Override
    public synchronized ResultSet getColumns(String catalog, String schema, String table, String column) throws SQLException {
        String sqlTable = "select t.ID as ID, t.NAME as NAME, u.NAME as UNAME from M$SYS_TABLES as t, M$SYS_USERS as u where t.USER_ID = u.USER_ID ";
        if (table != null) {
            if (table.indexOf("%") > -1) {
                sqlTable = sqlTable + "and t.NAME LIKE '" + table + "'";
            } else if (table.compareTo("") != 0) {
                sqlTable = sqlTable + "and t.NAME = upper('" + table + "')";
            }
        }
        if (schema != null) {
            if (schema.indexOf("%") > -1) {
                sqlTable = sqlTable + "and u.NAME LIKE '" + schema + "'";
            } else if (schema.compareTo("") != 0) {
                sqlTable = sqlTable + "and u.NAME = '" + schema + "'";
            }
        }
        sqlTable = sqlTable + " order by t.NAME";
        MachStatement stmtTable = (MachStatement)this.conn.createStatement();
        MachResultSet rsTable = (MachResultSet)stmtTable.executeQuery(sqlTable);
        MachStatement stmt = (MachStatement)this.conn.createStatement();
        MachResultSet rslt = null;
        String sql = "select '' as TABLE_CAT, u.NAME as TABLE_SCHEM, t.NAME as TABLE_NAME, c.NAME as COLUMN_NAME, decode(c.TYPE, 4,5, 8,4, 12,-5, 16,6, 20,8, 5,12, 6,93, 32,2104, 36,2106, 49,2110, 97,-2, 104,2201, 108,2202, 112,2203, 1111) as DATA_TYPE, decode(c.TYPE, 4,'SMALLINT', 8,'INTEGER', 12,'BIGINT', 16,'FLOAT', 20,'DOUBLE', 5,'VARCHAR', 6,'DATETIME', 32,'IPV4', 36,'IPV6', 49,'TEXT', 97,'BINARY',104, 'USMALLINT',108,'UINTEGER',112,'UBIGINT','UNKNOWN') as TYPE_NAME, decode(c.TYPE, 4,6, 8,11, 12,20, 16,17, 20,17, 6,31, 32,15, 36,45, 104,5, 108,10, 112,20, length) as COLUMN_SIZE, 0 as BUFFER_LENGTH, 0 as DECIMAL_DIGITS, 10 as NUM_PREC_RADIX, 1 as NULLABLE, 'NULL' as REMARKS, 'NULL' as COLUMN_DEF, 0 as SQL_DATA_TYPE, 0 as SQL_DATETIME_SUB, 0 as CHAR_OCTET_LENGTH, c.ID as ORDINAL_POSITION, 'YES' as IS_NULLABLE, c.TYPE as SOURCE_DATA_TYPE, 'NO' as IS_AUTOINCREMENT, 'NO' as IS_GENERATEDCOLUMN from M$SYS_COLUMNS as c, M$SYS_TABLES as t, M$SYS_USERS as u where c.TABLE_ID = t.ID and t.USER_ID = u.USER_ID";
        boolean sAdded = false;
        while (rsTable.next()) {
            int tid = rsTable.getInt(1);
            if (!sAdded) {
                sql = sql + " and (";
                sAdded = true;
            } else {
                sql = sql + " or ";
            }
            sql = sql + String.format("c.TABLE_ID = %d", tid);
        }
        if (sAdded) {
            sql = sql + ")";
        }
        if (column != null) {
            if (column.indexOf("%") > -1) {
                sql = sql + " and c.NAME LIKE '" + column + "'";
            } else if (column.compareTo("") != 0) {
                sql = sql + " and c.NAME = upper('" + column + "')";
            }
        }
        if (this.conn.showHiddenCols == 0) {
            sql = sql + " and c.NAME <> '_ARRIVAL_TIME' ";
        }
        sql = sql + " and c.ID <> 65534 order by c.TABLE_ID, c.ID";
        rslt = (MachResultSet)stmt.executeQuery(sql);
        if (rsTable != null) {
            rsTable.close();
        }
        if (stmtTable != null) {
            stmtTable.close();
        }
        if (rslt != null) {
            rslt.closeStmt = true;
        }
        return rslt;
    }

    @Override
    public synchronized ResultSet getColumnPrivileges(String catalog, String schema, String table, String column) throws SQLException {
        String sqlTable = "select t.ID as ID, t.NAME as NAME, u.NAME as UNAME from M$SYS_TABLES as t, M$SYS_USERS as u where t.USER_ID = u.USER_ID ";
        if (table != null) {
            if (table.indexOf("%") > -1) {
                sqlTable = sqlTable + "and t.NAME LIKE '" + table + "'";
            } else if (table.compareTo("") != 0) {
                sqlTable = sqlTable + "and t.NAME = upper('" + table + "')";
            }
        }
        if (schema != null) {
            if (schema.indexOf("%") > -1) {
                sqlTable = sqlTable + "and u.NAME LIKE '" + schema + "'";
            } else if (schema.compareTo("") != 0) {
                sqlTable = sqlTable + "and u.NAME='" + schema + "'";
            }
        }
        sqlTable = sqlTable + " order by t.NAME";
        MachStatement stmtTable = (MachStatement)this.conn.createStatement();
        MachResultSet rsTable = (MachResultSet)stmtTable.executeQuery(sqlTable);
        MachStatement stmt = (MachStatement)this.conn.createStatement();
        MachResultSet rslt = null;
        String sql = "select '' as TABLE_CAT, u.NAME as TABLE_SCHEM, t.NAME as TABLE_NAME, c.NAME as COLUMN_NAME, '' as GRANTOR, '' as GRANTEE, '' as PRIVILEGE, '' as IS_GRANTABLE from M$SYS_COLUMNS as c, M$SYS_TABLES as t, M$SYS_USERS as u where c.TABLE_ID = t.ID and t.USER_ID = u.USER_ID";
        boolean sAdded = false;
        while (rsTable.next()) {
            int tid = rsTable.getInt(1);
            if (!sAdded) {
                sql = sql + " and (";
                sAdded = true;
            } else {
                sql = sql + " or ";
            }
            sql = sql + String.format("c.TABLE_ID = %d", tid);
        }
        if (sAdded) {
            sql = sql + ")";
        }
        if (column != null) {
            if (column.indexOf("%") > -1) {
                sql = sql + " and c.NAME LIKE '" + column + "'";
            } else if (column.compareTo("") != 0) {
                sql = sql + " and c.NAME = upper('" + column + "')";
            }
        }
        if (this.conn.showHiddenCols == 0) {
            sql = sql + " and c.NAME <> '_ARRIVAL_TIME' ";
        }
        sql = sql + " and c.ID <> 65534 order by c.ID";
        rslt = (MachResultSet)stmt.executeQuery(sql);
        if (rsTable != null) {
            rsTable.close();
        }
        if (stmtTable != null) {
            stmtTable.close();
        }
        if (rslt != null) {
            rslt.closeStmt = true;
        }
        return rslt;
    }

    @Override
    public synchronized ResultSet getTablePrivileges(String catalog, String schema, String table) throws SQLException {
        MachStatement stmt;
        MachResultSet rslt;
        String sSql = "select '' as TABLE_CAT, u.NAME as TABLE_SCHEM, t.NAME as TABLE_NAME, '' as GRANTOR, '' as GRANTEE, '' as PRIVILEGE, '' as IS_GRANTABLE from M$SYS_TABLES as t, M$SYS_USERS as u WHERE t.USER_ID = u.USER_ID ";
        if (table != null) {
            if (table.indexOf("%") > -1) {
                sSql = sSql + "and t.NAME LIKE '" + table + "' ";
            } else if (table.compareTo("") != 0) {
                sSql = sSql + "and t.NAME=upper('" + table + "') ";
            }
        }
        if (schema != null) {
            if (schema.indexOf("%") > -1) {
                sSql = sSql + "and u.NAME LIKE '" + schema + "' ";
            } else if (schema.compareTo("") != 0) {
                sSql = sSql + "and u.NAME='" + schema + "' ";
            }
        }
        if ((rslt = (MachResultSet)(stmt = (MachStatement)this.conn.createStatement()).executeQuery(sSql)) != null) {
            rslt.closeStmt = true;
        }
        return rslt;
    }

    @Override
    public synchronized ResultSet getBestRowIdentifier(String catalog, String schema, String table, int scope, boolean nullable) throws SQLException {
        String sSql = "select 0 as SCOPE, '' as COLUMN_NAME, 0 as DATA_TYPE, '' as TYPE_NAME, 0 as COLUMN_SIZE,  0 as BUFFER_LENGTH, 0 as DECIMAL_DIGITS, 1 as PSEUDO_COLUMN from m$sys_columns cl, m$sys_tables tl  where cl.table_id = tl.id and tl.name='~~DUMMY~~'";
        MachStatement stmt = (MachStatement)this.conn.createStatement();
        MachResultSet rslt = (MachResultSet)stmt.executeQuery(sSql);
        if (rslt != null) {
            rslt.closeStmt = true;
        }
        return rslt;
    }

    @Override
    public ResultSet getVersionColumns(String catalog, String schema, String table) throws SQLException {
        String sSql = String.format("select 0 as SCOPE, cl.NAME as COLUMN_NAME, decode(cl.type, 4,5, 8,4, 12,-5, 16,6, 20,8, 5,12, 6,93, 32,2104, 36,2106, 49,2110, 97,-2, 104,2201, 108,2202, 112,2203, 1111) as DATA_TYPE, decode(cl.type, 4,'SMALLINT', 8,'INTEGER', 12,'BIGINT', 16,'FLOAT', 20,'DOUBLE', 5,'VARCHAR', 6,'DATETIME', 32,'IPV4', 36,'IPV6', 49,'TEXT', 97,'BINARY',104, 'USMALLINT',108,'UINTEGER',112,'UBIGINT','UNKNOWN') as TYPE_NAME, decode(cl.type, 4,6, 8,11, 12,20, 16,17, 20,17, 6,31, 32,15, 36,45, 104,5, 108,10, 112,20, length) as COLUMN_SIZE, 0 as BUFFER_LENGTH, 0 as DECIMAL_DIGITS, 1 as PSEUDO_COLUMN from m$sys_columns cl, m$sys_tables tl  where cl.table_id = tl.id and tl.name='%s'", table);
        if (this.conn.showHiddenCols == 0) {
            sSql = sSql + " and cl.name <> '_ARRIVAL_TIME' ";
        }
        sSql = sSql + " and cl.id <> 65534";
        MachStatement stmt = (MachStatement)this.conn.createStatement();
        MachResultSet rslt = (MachResultSet)stmt.executeQuery(sSql);
        if (rslt != null) {
            rslt.closeStmt = true;
        }
        return rslt;
    }

    @Override
    public synchronized ResultSet getPrimaryKeys(String catalog, String schema, String table) throws SQLException {
        if (table == null || table.compareTo("") == 0) {
            throw new SQLException("table cannot be a null.");
        }
        String userStr = "";
        if (schema != null && schema.compareTo("") != 0) {
            userStr = " and u.NAME='" + schema.toUpperCase() + "'";
        }
        String sql = "SELECT '' as TABLE_CAT, u.NAME as TABLE_SCHEM, t.NAME as TABLE_NAME, c.NAME as COLUMN_NAME, decode(i.TYPE, 1, 'BITMAP', 2, 'KEYWORD', 3, 'REDBLACK', 6, 'LSM', 8, 'REDBLACK', 9, 'KEYWORD LSM', 'UNKNOWN') as INDEX_TYPE, i.NAME as PK_NAME, 1 as KEY_SEQ FROM M$SYS_TABLES as t, M$SYS_USERS as u, M$SYS_INDEXES as i, M$SYS_INDEX_COLUMNS as c WHERE t.USER_ID = u.USER_ID and t.ID = i.TABLE_ID and c.INDEX_ID = i.ID and i.TYPE = 8 and substr(i.NAME, 1, 5) = '__PK_'" + userStr + " and t.NAME = '" + table + "' ORDER BY i.NAME";
        MachStatement stmt = (MachStatement)this.conn.createStatement();
        MachResultSet rslt = (MachResultSet)stmt.executeQuery(sql);
        if (rslt != null) {
            MachTableMetaData tMeta = rslt.getTableMetaData();
            tMeta.setColumnName(0, "TABLE_CAT");
            tMeta.setColumnName(1, "TABLE_SCHEM");
            tMeta.setColumnName(2, "TABLE_NAME");
            tMeta.setColumnName(3, "COLUMN_NAME");
            tMeta.setColumnName(4, "INDEX_TYPE");
            tMeta.setColumnName(5, "PK_NAME");
            tMeta.setColumnName(6, "KEY_SEQ");
            rslt.closeStmt = true;
        }
        return rslt;
    }

    @Override
    public synchronized ResultSet getImportedKeys(String catalog, String schema, String table) throws SQLException {
        String sql = "select '' as PKTABLE_CAT, 'SYS' as PKTABLE_SCHEM, '" + table + "' as PKTABLE_NAME,  '' as PKCOLUMN_NAME, '' as FKTABLE_CAT, 'SYS' as FKTABLE_SCHEM,'' as FKTABLE_NAME,  '' as FKCOLUMN_NAME, 0 as KEY_SEQ, 3 as UPDATE_RULE,3 as DELETE_RULE,'' as FK_NAME,  '' as PK_NAME, 7 as DEFERRABILITY  from m$tables limit 0";
        MachStatement stmt = (MachStatement)this.conn.createStatement();
        MachResultSet rslt = (MachResultSet)stmt.executeQuery(sql);
        if (rslt != null) {
            rslt.closeStmt = true;
        }
        return rslt;
    }

    @Override
    public synchronized ResultSet getExportedKeys(String catalog, String schema, String table) throws SQLException {
        String sql = "select '' as PKTABLE_CAT, 'SYS' as PKTABLE_SCHEM, '" + table + "' as PKTABLE_NAME,  '' as PKCOLUMN_NAME, '' as FKTABLE_CAT, 'SYS' as FKTABLE_SCHEM,'' as FKTABLE_NAME,  '' as FKCOLUMN_NAME, 0 as KEY_SEQ, 3 as UPDATE_RULE,3 as DELETE_RULE,'' as FK_NAME,  '' as PK_NAME, 7 as DEFERRABILITY  from m$tables limit 0";
        MachStatement stmt = (MachStatement)this.conn.createStatement();
        MachResultSet rslt = (MachResultSet)stmt.executeQuery(sql);
        if (rslt != null) {
            rslt.closeStmt = true;
        }
        return rslt;
    }

    @Override
    public synchronized ResultSet getCrossReference(String pcat, String pschem, String ptable, String fcat, String fschem, String ftable) throws SQLException {
        throw new SQLException("this method not supported.");
    }

    @Override
    public synchronized ResultSet getTypeInfo() throws SQLException {
        InfoResultSet iRs = new InfoResultSet(this.conn.getCatalog(), "TYPEINFO");
        iRs.addMeta("TYPE_NAME", 12);
        iRs.addMeta("DATA_TYPE", 5);
        iRs.addMeta("PRECISION", 4);
        iRs.addMeta("LITERAL_PREFIX", 12);
        iRs.addMeta("LITERAL_SUFFIX", 12);
        iRs.addMeta("CREATE_PARAMS", 12);
        iRs.addMeta("NULLABLE", 5);
        iRs.addMeta("CASE_SENSITIVE", 5);
        iRs.addMeta("SEARCHABLE", 5);
        iRs.addMeta("UNSIGNED_ATTRIBUTE", 5);
        iRs.addMeta("FIXED_PREC_SCALE", 5);
        iRs.addMeta("AUTO_INCREMENT", 5);
        iRs.addMeta("LOCAL_TYPE_NAME", 12);
        iRs.addMeta("MINIMUM_SCALE", 5);
        iRs.addMeta("MAXIMUM_SCALE", 5);
        iRs.addMeta("SQL_DATA_TYPE", 5);
        iRs.addMeta("SQL_DATETIME_SUB", 5);
        iRs.addMeta("NUM_PREC_RADIX", 4);
        Vector<Object> row = new Vector<Object>();
        row.removeAllElements();
        row.addElement("VARCHAR");
        row.addElement(new Integer(12));
        row.addElement(new Integer(2000));
        row.addElement("");
        row.addElement("");
        row.addElement("");
        row.addElement(new Integer(1));
        row.addElement(new Integer(1));
        row.addElement(new Integer(3));
        row.addElement(new Integer(0));
        row.addElement(new Integer(0));
        row.addElement(new Integer(0));
        row.addElement("");
        row.addElement(new Integer(0));
        row.addElement(new Integer(2000));
        row.addElement(new Integer(0));
        row.addElement(new Integer(0));
        row.addElement(new Integer(10));
        iRs.addRow(row);
        row.removeAllElements();
        row.addElement("TIMESTAMP");
        row.addElement(new Integer(93));
        row.addElement(new Integer(8));
        row.addElement("");
        row.addElement("");
        row.addElement("");
        row.addElement(new Integer(1));
        row.addElement(new Integer(1));
        row.addElement(new Integer(0));
        row.addElement(new Integer(1));
        row.addElement(new Integer(0));
        row.addElement(new Integer(0));
        row.addElement("");
        row.addElement(new Integer(0));
        row.addElement(new Integer(8));
        row.addElement(new Integer(0));
        row.addElement(new Integer(0));
        row.addElement(new Integer(10));
        iRs.addRow(row);
        row.removeAllElements();
        row.addElement("IPV4");
        row.addElement(new Integer(-8));
        row.addElement(new Integer(5));
        row.addElement("");
        row.addElement("");
        row.addElement("");
        row.addElement(new Integer(1));
        row.addElement(new Integer(1));
        row.addElement(new Integer(2));
        row.addElement(new Integer(0));
        row.addElement(new Integer(0));
        row.addElement(new Integer(0));
        row.addElement("");
        row.addElement(new Integer(5));
        row.addElement(new Integer(5));
        row.addElement(new Integer(0));
        row.addElement(new Integer(0));
        row.addElement(new Integer(10));
        iRs.addRow(row);
        return iRs;
    }

    @Override
    public synchronized ResultSet getIndexInfo(String catalog, String schema, String table, boolean unique, boolean approximate) throws SQLException {
        if (table == null || table.compareTo("") == 0) {
            throw new SQLException("table cannot be a null.");
        }
        String userStr = "";
        if (schema != null && schema.compareTo("") != 0) {
            userStr = " and u.NAME='" + schema.toUpperCase() + "'";
        }
        String sql = "SELECT '' as TABLE_CAT, u.NAME as TABLE_SCHEM, t.NAME as TABLE_NAME, i.KEY_COMPRESS as KEY_COMPRESS, i.NAME as INDEX_NAME, decode(i.TYPE, 1, 'BITMAP', 2, 'KEYWORD', 3, 'REDBLACK', 6, 'LSM', 8, 'REDBLACK', 9, 'KEYWORD LSM', 'UNKNOWN') as INDEX_TYPE, i.MAX_LEVEL as MAX_LEVEL, c.NAME as COLUMN_NAME, i.PART_VALUE_COUNT as PART_VALUE_COUNT, i.PAGE_SIZE as PAGE_SIZE, i.MAX_KEYWORD_SIZE as MAX_KEYWORD_SIZE, i.BITMAP_ENCODE as BITMAP_ENCODE, decode(substr(i.NAME, 1, 5), '__PK_', 0, 1) as NON_UNIQUE, 'NULL' as INDEX_QUALIFIER, 0 as CARDINALITY, 3 as TYPE, 1 as ORDINAL_POSITION, 'A' as ASC_OR_DESC, 0 as PAGES, 'NULL' as FILTER_CONDITION FROM M$SYS_TABLES as t, M$SYS_USERS as u, M$SYS_INDEXES as i, M$SYS_INDEX_COLUMNS as c WHERE t.USER_ID = u.USER_ID and t.ID = i.TABLE_ID and c.INDEX_ID = i.ID" + userStr + " and t.NAME = '" + table + "' ORDER BY i.NAME";
        MachStatement stmt = (MachStatement)this.conn.createStatement();
        MachResultSet rslt = (MachResultSet)stmt.executeQuery(sql);
        if (rslt != null) {
            MachTableMetaData tMeta = rslt.getTableMetaData();
            tMeta.setColumnName(0, "TABLE_CAT");
            tMeta.setColumnName(1, "TABLE_SCHEM");
            tMeta.setColumnName(2, "TABLE_NAME");
            tMeta.setColumnName(3, "KEY_COMPRESS");
            tMeta.setColumnName(4, "INDEX_NAME");
            tMeta.setColumnName(5, "INDEX_TYPE");
            tMeta.setColumnName(6, "MAX_LEVEL");
            tMeta.setColumnName(7, "COLUMN_NAME");
            tMeta.setColumnName(8, "PART_VALUE_COUNT");
            tMeta.setColumnName(9, "PAGE_SIZE");
            tMeta.setColumnName(10, "MAX_KEYWORD_SIZE");
            tMeta.setColumnName(11, "BITMAP_ENCODE");
            tMeta.setColumnName(12, "NON_UNIQUE");
            tMeta.setColumnName(13, "INDEX_QUALIFIER");
            tMeta.setColumnName(14, "CARDINALITY");
            tMeta.setColumnName(15, "TYPE");
            tMeta.setColumnName(16, "ORDINAL_POSITION");
            tMeta.setColumnName(17, "ASC_OR_DESC");
            tMeta.setColumnName(18, "PAGES");
            tMeta.setColumnName(19, "FILTER_CONDITION");
            rslt.closeStmt = true;
        }
        return rslt;
    }

    @Override
    public ResultSet getUDTs(String catalog, String schema, String table, int[] types) throws SQLException {
        String sSql = "SELECT '' as TYPE_CAT, '' as TYPE_SCHEM, '' as TYPE_NAME, '' as CLASS_NAME, '' as DATA_TYPE, '' as REMARKS FROM M$SYS_USERS WHERE USER_ID=-1";
        MachStatement stmt = (MachStatement)this.conn.createStatement();
        MachResultSet rslt = (MachResultSet)stmt.executeQuery(sSql);
        if (rslt != null) {
            rslt.closeStmt = true;
        }
        return rslt;
    }

    @Override
    public Connection getConnection() throws SQLException {
        return this.conn;
    }

    @Override
    public boolean supportsBatchUpdates() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsResultSetType(int type) throws SQLException {
        return true;
    }

    @Override
    public boolean supportsResultSetConcurrency(int type, int concur) throws SQLException {
        return false;
    }

    @Override
    public boolean deletesAreDetected(int type) throws SQLException {
        return false;
    }

    @Override
    public boolean insertsAreDetected(int type) throws SQLException {
        return false;
    }

    @Override
    public boolean updatesAreDetected(int type) throws SQLException {
        return false;
    }

    @Override
    public boolean othersDeletesAreVisible(int type) throws SQLException {
        return false;
    }

    @Override
    public boolean othersInsertsAreVisible(int type) throws SQLException {
        return false;
    }

    @Override
    public boolean othersUpdatesAreVisible(int type) throws SQLException {
        return false;
    }

    @Override
    public boolean ownDeletesAreVisible(int type) throws SQLException {
        return false;
    }

    @Override
    public boolean ownInsertsAreVisible(int type) throws SQLException {
        return false;
    }

    @Override
    public boolean ownUpdatesAreVisible(int type) throws SQLException {
        return false;
    }

    @Override
    public boolean autoCommitFailureClosesAllResultSets() throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public ResultSet getClientInfoProperties() throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public ResultSet getFunctionColumns(String catalog, String schemaPattern, String functionNamePattern, String columnNamePattern) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public ResultSet getFunctions(String catalog, String schemaPattern, String functionNamePattern) throws SQLException {
        String sSql = "SELECT '' as FUNCTION_CAT, '' as FUNCTION_SCHEM, '' as FUNCTION_NAME, '' as REMARKS, 0 as FUNCTION_TYPE, '' as SPECIFIC_NAME FROM M$SYS_USERS WHERE USER_ID=-1";
        MachStatement stmt = (MachStatement)this.conn.createStatement();
        MachResultSet rslt = (MachResultSet)stmt.executeQuery(sSql);
        if (rslt != null) {
            rslt.closeStmt = true;
        }
        return rslt;
    }

    @Override
    public RowIdLifetime getRowIdLifetime() throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public ResultSet getSchemas(String catalog, String schemaPattern) throws SQLException {
        String sql = "select NAME as TABLE_SCHEM, '' as TABLE_CATALOG from m$sys_users";
        MachStatement stmt = (MachStatement)this.conn.createStatement();
        MachResultSet rslt = (MachResultSet)stmt.executeQuery(sql);
        if (rslt != null) {
            rslt.closeStmt = true;
        }
        return rslt;
    }

    @Override
    public boolean supportsStoredFunctionsUsingCallSyntax() throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public ResultSet getPseudoColumns(String catalog, String schemaPattern, String tableNamePattern, String columnNamePattern) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean generatedKeyAlwaysReturned() throws SQLException {
        throw new UnsupportedOperationException();
    }
}

