/*
 * Decompiled with CFR 0.152.
 */
package com.machbase.jdbc;

import com.machbase.jdbc.MachConnection;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.util.Properties;
import java.util.logging.Logger;

public class MachDriver
implements Driver {
    private String urlDBname = "machbase";

    @Override
    public boolean acceptsURL(String url) throws SQLException {
        if (url.length() < this.urlDBname.length() + 5) {
            return false;
        }
        return url.substring(5, this.urlDBname.length() + 5).equals(this.urlDBname);
    }

    @Override
    public synchronized Connection connect(String url, Properties props) throws SQLException {
        String database;
        String host;
        int port;
        String orig = url;
        if (!this.acceptsURL(url)) {
            return null;
        }
        if (url.indexOf(94) != -1 && url.indexOf(44) != -1) {
            throw new SQLException("Invalid Machbase URL: " + orig + " (Connection string cannot contain host separator '^' and ',' at the same time.)");
        }
        if (url.indexOf(94) != -1) {
            props.put("randomHost", "true");
        }
        if (url.startsWith("jdbc:")) {
            if (url.length() < 6) {
                return null;
            }
            url = url.substring(5);
        }
        if (!url.startsWith(this.urlDBname + "://")) {
            return null;
        }
        if (url.length() < this.urlDBname.length() + 3) {
            return null;
        }
        int i = (url = url.substring(this.urlDBname.length() + 3)).indexOf(58);
        if (i == -1) {
            port = 5656;
            i = url.indexOf(47);
            if (i == -1) {
                throw new SQLException("Invalid Machbase URL: " + orig);
            }
            if (url.length() < i + 1) {
                throw new SQLException("Invalid Machbase URL: " + orig);
            }
            host = url.substring(0, i);
            database = url.substring(i + 1);
        } else {
            host = url.substring(0, i);
            if (url.length() < i + 1) {
                throw new SQLException("Invalid Machbase URL: " + orig);
            }
            if ((i = (url = url.substring(i + 1)).indexOf(47)) == -1) {
                throw new SQLException("Invalid Machbase URL: " + orig);
            }
            if (url.length() < i + 1) {
                throw new SQLException("Invalid Machbase URL: " + orig);
            }
            try {
                int sepIdx;
                String portString = url.substring(0, i);
                int n = sepIdx = portString.indexOf(44) != -1 ? portString.indexOf(44) : portString.indexOf(94);
                port = sepIdx != -1 ? Integer.parseInt(portString.substring(0, sepIdx)) : Integer.parseInt(url.substring(0, i));
            }
            catch (NumberFormatException e) {
                throw new SQLException("Invalid Machbase port number: " + url.substring(0, i));
            }
            database = url.substring(i + 1);
        }
        return new MachConnection(orig, host, port, database, props);
    }

    @Override
    public int getMajorVersion() {
        return 0;
    }

    @Override
    public int getMinorVersion() {
        return 1;
    }

    @Override
    public DriverPropertyInfo[] getPropertyInfo(String url, Properties info) throws SQLException {
        return new DriverPropertyInfo[0];
    }

    @Override
    public boolean jdbcCompliant() {
        return false;
    }

    @Override
    public Logger getParentLogger() {
        throw new UnsupportedOperationException();
    }

    static {
        try {
            DriverManager.registerDriver(new MachDriver());
        }
        catch (SQLException var) {
            throw new RuntimeException("Could not register driver", var);
        }
    }
}

