/*
 * Decompiled with CFR 0.152.
 */
package com.machbase.jdbc;

import com.machbase.jdbc.MachByteFunc;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;

public class MachInputStream {
    private BufferedInputStream input;
    private byte[] bytes_8 = new byte[8];
    private byte[] bytes_4 = new byte[4];
    private long mProtocol = 0L;
    private int mFlag = 0;
    private int mLength = 0;
    private int mStmtId = 0;
    final int PACKET_HEADER_SIZE = 16;

    public MachInputStream(InputStream in) throws IOException {
        this.input = new BufferedInputStream(in);
    }

    public void close() throws IOException {
        this.input.close();
    }

    public long getPacketProtocol() throws IOException {
        return this.mProtocol;
    }

    public int getPacketLength() throws IOException {
        return this.mLength;
    }

    public int getStmtId() throws IOException {
        return this.mStmtId;
    }

    public int isReadable() throws IOException {
        return this.input.available();
    }

    public byte[] read() throws IOException {
        byte[] bytes = null;
        int size = 0;
        this.input.skip(4L);
        for (int i = 3; i >= 0; --i) {
            bytes = this.readBytes(1);
            byte b = bytes[0];
            size += b << i * 8;
        }
        bytes = this.readBytes(size);
        return bytes;
    }

    public String readString(String encoding) throws IOException {
        return new String(this.read());
    }

    public String readHeader() throws IOException {
        byte[] sTmp = null;
        for (int i = 0; i < 4; ++i) {
            sTmp = this.readBytes(4);
        }
        return new String(sTmp);
    }

    public int readLength() throws IOException {
        int size = 0;
        byte[] sTmp = null;
        sTmp = this.readBytes(8);
        for (int i = 3; i >= 0; --i) {
            byte b = sTmp[7 - i];
            size += MachByteFunc.uInt(b) << i * 8;
        }
        return size;
    }

    public String readString(int size) throws IOException {
        byte[] bytes = null;
        bytes = this.readBytes(size);
        return new String(bytes);
    }

    public byte[] readBytes(int size) throws IOException {
        if (size < 1) {
            return null;
        }
        byte[] bytes = new byte[size];
        int now = 0;
        int total = 0;
        int unread = size;
        while (total < size) {
            now = this.input.read(bytes, total, unread);
            total += now;
            unread -= now;
        }
        return bytes;
    }

    public byte readSChar() throws IOException {
        byte[] sTmp = null;
        sTmp = this.readBytes(1);
        return sTmp[0];
    }

    public long readUInt() throws IOException {
        long value = 0L;
        byte[] sTmp = null;
        for (int i = 3; i >= 0; --i) {
            sTmp = this.readBytes(1);
            byte b = sTmp[0];
            value += MachByteFunc.uLong(b) << i * 8;
        }
        return value;
    }

    public long readProtocol() throws IOException {
        return this.readUInt();
    }

    public long readType() throws IOException {
        return this.readUInt();
    }

    public String readULong() throws IOException {
        byte[] sTmp = null;
        sTmp = this.readBytes(8);
        return new String(sTmp);
    }

    public final int readPacketFlag() throws IOException {
        byte[] sTmp = null;
        sTmp = this.readBytes(16);
        long sPacketHeader = (sTmp[4] & 0xFF) << 24 | (sTmp[5] & 0xFF) << 16 | (sTmp[6] & 0xFF) << 8 | sTmp[7] & 0xFF;
        this.mProtocol = sTmp[3];
        this.mFlag = (int)(((sPacketHeader &= 0xFFFFFFFFL) & 0xC0000000L) >> 30);
        this.mLength = (int)(sPacketHeader & 0x3FFFFFFFL);
        this.mStmtId = (sTmp[8] & 0xFF) << 24 | (sTmp[9] & 0xFF) << 16 | (sTmp[10] & 0xFF) << 8 | sTmp[11] & 0xFF;
        return this.mFlag;
    }

    final void dump() {
        System.out.println("readpacket dump");
        for (int i = 0; i < 8; ++i) {
            System.out.format("%02X ", this.bytes_8[i]);
        }
        System.out.println("\n");
    }

    final void dumpBody(int bodyLength) {
        try {
            if (bodyLength > 64) {
                this.input.mark(bodyLength);
                int dumpSize = 32;
                byte[] sBodyFirst = new byte[dumpSize];
                this.input.read(sBodyFirst, 0, dumpSize);
                System.out.print("readPacketFlag() dump bodyFirst32 [ ");
                for (int i = 0; i < dumpSize; ++i) {
                    System.out.format("%02X ", sBodyFirst[i]);
                }
                System.out.print("]\n");
                byte[] sBodyLast = new byte[dumpSize];
                long actualSkipped = this.input.skip(bodyLength - dumpSize * 2);
                this.input.read(sBodyLast, 0, dumpSize);
                System.out.print("readPacketFlag() dump bodyLast32  [ ");
                for (int i = 0; i < dumpSize; ++i) {
                    System.out.format("%02X ", sBodyLast[i]);
                }
                System.out.print("]\n");
                this.input.reset();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

