/*
 * Decompiled with CFR 0.152.
 */
package com.machbase.jdbc;

import java.io.PrintStream;
import java.sql.DriverManager;

public class MachLog {
    public static final int NONE = 0;
    public static final int FATAL = 1;
    public static final int JDBC = 2;
    public static final int MSQL = 4;
    public static final int ERROR = 8;
    public static final int DRIVER = 16;
    public static final int METHODS = 32;
    public static final int THREADS = 64;
    public static final int ALL = 127;
    private int level = 0;
    private Object owner = null;

    public MachLog(int lvl, Object own) {
        this.level = lvl;
        this.owner = own;
    }

    public void close() {
        PrintStream pw = DriverManager.getLogStream();
        if (pw != null) {
            pw.flush();
        }
    }

    public int getLevel() {
        return this.level;
    }

    public void log(String method, int type, String event) {
        String str;
        if ((this.level & type) == 0) {
            return;
        }
        switch (type) {
            case 0: {
                return;
            }
            case 1: {
                str = "FATAL ERROR";
                break;
            }
            case 2: {
                str = "JDBC";
                break;
            }
            case 4: {
                str = "mSQL";
                break;
            }
            case 8: {
                str = "ERROR";
                break;
            }
            case 16: {
                str = "DRIVER";
                break;
            }
            default: {
                str = "UNK";
            }
        }
        if ((this.level & 0x20) != 0) {
            str = str + " " + this.owner.getClass().getName() + "." + method;
        }
        if ((this.level & 0x40) != 0) {
            str = str + " (" + Thread.currentThread().getName() + ")";
        }
        str = str + ": " + event;
        PrintStream log = DriverManager.getLogStream();
        if (log == null) {
            if (type == 8 || type == 1) {
                System.err.println(str);
            } else {
                System.out.println(str);
            }
        } else {
            log.println(str);
        }
    }
}

