/*
 * Decompiled with CFR 0.152.
 */
package com.machbase.jdbc;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class MachOutputStream {
    private BufferedOutputStream output;
    private byte[] bytes_8 = new byte[8];
    private byte[] bytes_4 = new byte[4];

    public MachOutputStream(OutputStream out) throws IOException {
        this.output = new BufferedOutputStream(out);
    }

    public void close() throws IOException {
        this.output.close();
    }

    public void flush() throws IOException {
        this.output.flush();
    }

    public void write(byte[] bytes) throws IOException {
        int size = bytes.length;
        int size_t = 0;
        for (int i = 3; i >= 0; --i) {
            size_t = size >>> i * 8;
            this.bytes_4[3 - i] = (byte)size_t;
        }
        this.output.write(this.bytes_4, 0, 4);
        this.output.write(bytes, 0, bytes.length);
    }

    public void writeString(String str, String encoding) throws IOException {
        this.write(str.getBytes());
    }

    public void writeUInt(long val) throws IOException {
        long tmpValue = 0L;
        for (int i = 3; i >= 0; --i) {
            tmpValue = val >>> i * 8;
            this.bytes_4[3 - i] = (byte)tmpValue;
        }
        this.output.write(this.bytes_4, 0, 4);
    }

    public void writeProtocol(long val) throws IOException {
        this.bytes_4[0] = 0;
        this.bytes_4[1] = 0;
        this.bytes_4[2] = 0;
        this.bytes_4[3] = (byte)val;
        this.output.write(this.bytes_4, 0, 4);
    }

    public void writeType(long type) throws IOException {
        this.writeUInt(type);
    }

    public void writeLength(int size) throws IOException {
        int i;
        int size_t = 0;
        for (i = 0; i < 4; ++i) {
            this.bytes_8[i] = 0;
        }
        for (i = 3; i >= 0; --i) {
            size_t = size >>> i * 8;
            this.bytes_8[7 - i] = (byte)size_t;
        }
        this.output.write(this.bytes_8, 0, 8);
    }

    public void writeString(String str) throws IOException {
        this.output.write(str.getBytes(), 0, str.getBytes().length);
    }

    public void writeBytes(byte[] bytes, int size) throws IOException {
        this.output.write(bytes, 0, size);
    }

    public void writeBufferData(long protocol, byte[] bytes, int size) throws IOException {
        int i;
        byte[] sendB = new byte[16 + size];
        long tmpValue = 0L;
        int cnt = 0;
        for (int i2 = 3; i2 >= 0; --i2) {
            tmpValue = protocol >>> i2 * 8;
            sendB[cnt++] = (byte)tmpValue;
        }
        long type = 1L;
        for (int i3 = 3; i3 >= 0; --i3) {
            tmpValue = type >>> i3 * 8;
            sendB[cnt++] = (byte)tmpValue;
        }
        int size_t = 0;
        for (i = 0; i < 4; ++i) {
            sendB[cnt++] = 0;
        }
        for (i = 3; i >= 0; --i) {
            size_t = size >>> i * 8;
            sendB[cnt++] = (byte)size_t;
        }
        if (size > 0) {
            System.arraycopy(bytes, 0, sendB, cnt, size);
        }
        this.output.write(sendB, 0, size + 16);
    }
}

