/*
 * Decompiled with CFR 0.152.
 */
package com.machbase.jdbc;

import com.machbase.jdbc.MachByteFunc;
import com.machbase.jdbc.MachResult;

public class MachPacket {
    private long protocol;
    private long type;
    private byte[] value;
    int curPos = 0;

    public MachPacket() {
    }

    public MachPacket(long p, long t, byte[] v) {
        this.protocol = p;
        this.type = t;
        this.value = v;
        this.curPos = 0;
    }

    public void set(long p, long t, byte[] v) {
        this.protocol = p;
        this.type = t;
        this.value = v;
        this.curPos = 0;
    }

    public long getProtocol() {
        return this.protocol;
    }

    public long getType() {
        return this.type;
    }

    public byte[] getValue() {
        return this.value;
    }

    public void setProtocol(long p) {
        this.protocol = p;
    }

    public void setType(long t) {
        this.type = t;
    }

    public void setValue(byte[] v) {
        this.value = v;
    }

    public MachResult getResult() {
        this.curPos = 0;
        long val = this.readUIntNoCnt();
        long errorNum = this.readUIntNoCnt();
        MachResult re = new MachResult(val, errorNum);
        return re;
    }

    public String getVersion() {
        this.curPos = 0;
        int major = this.readUShortNoCnt();
        int minor = this.readUShortNoCnt();
        long patch = this.readUIntNoCnt();
        return major + "." + minor + "." + patch;
    }

    public String getString() {
        String val = new String(this.value);
        return val;
    }

    public long getEndian() {
        this.curPos = 0;
        return this.readSLong();
    }

    public long getSessionId() {
        this.curPos = 0;
        return this.readSLong();
    }

    public long getSuccessCount() {
        this.curPos = 0;
        return this.readSLong();
    }

    public long getFailureCount() {
        this.curPos = 0;
        return this.readSLong();
    }

    public String getTimeZone() {
        return this.getString();
    }

    final int getCount() {
        this.curPos = 0;
        for (int i = 0; i < 4; ++i) {
            ++this.curPos;
        }
        return (int)this.readUIntNoCnt();
    }

    final long getSLong() {
        long val = 0L;
        this.curPos = 0;
        return this.readSLong();
    }

    final byte[] getBytes(int len) {
        if (len > 0) {
            byte[] b = this.readBytesNoCnt(len);
            if (b[0] == -1) {
                return null;
            }
            return b;
        }
        return "".getBytes();
    }

    final byte[] getChar(int len) {
        if (len > 0) {
            byte[] b = this.readBytesNoCnt(len);
            if (b[0] == -1) {
                return null;
            }
            int cnt = 0;
            for (cnt = 0; cnt < b.length && b[cnt] != 0; ++cnt) {
            }
            byte[] ret = new byte[cnt];
            System.arraycopy(b, 0, ret, 0, cnt);
            return ret;
        }
        return "".getBytes();
    }

    final byte[] getBinary() {
        int readLen = (int)this.readUIntNoCnt();
        if (readLen == 0) {
            return null;
        }
        byte[] b = new byte[readLen];
        System.arraycopy(this.value, this.curPos, b, 0, readLen);
        this.curPos += readLen;
        return b;
    }

    final byte[] getNibbleValue(int precision) {
        int readLen = this.value[this.curPos];
        readLen = (readLen + 1 >> 1) + 1;
        if (this.value[this.curPos] == 255) {
            readLen = precision;
            this.curPos += readLen;
            return null;
        }
        if (readLen == 0) {
            return null;
        }
        byte[] b = new byte[readLen];
        System.arraycopy(this.value, this.curPos, b, 0, readLen);
        this.curPos += readLen;
        return b;
    }

    final byte[] getBytesValue(int len) {
        if (len > 0) {
            byte[] b = this.readBytesNoCnt(len);
            return b;
        }
        return "".getBytes();
    }

    final byte[] getBytesValue(int len, int inc) {
        if (len > 0) {
            byte[] b = new byte[len];
            System.arraycopy(this.value, this.curPos, b, 0, len);
            this.curPos += inc;
            if (inc % 2 == 1) {
                ++this.curPos;
            }
            return b;
        }
        return "".getBytes();
    }

    final byte[] getDate() {
        return this.readBytesNoCnt(8);
    }

    final byte[] getTNumeric() {
        return this.readBytesNoCnt(21);
    }

    final byte[] getNumeric(int p, int s) {
        int tmp = 0;
        tmp = p % 2 == 1 || s % 2 == 1 ? 1 : 0;
        int len = 1 + p / 2 + tmp;
        byte[] b = new byte[len];
        System.arraycopy(this.value, this.curPos, b, 0, len);
        this.curPos += len;
        return b;
    }

    final byte[] readBytesNoCnt(int len) {
        byte[] b = new byte[len];
        System.arraycopy(this.value, this.curPos, b, 0, len);
        this.curPos += len;
        return b;
    }

    final byte[] getQpdShort() {
        return this.readBytesNoCnt(2);
    }

    final byte[] getQpdUShort() {
        return this.readBytesNoCnt(2);
    }

    final byte[] getQpdInt() {
        return this.readBytesNoCnt(4);
    }

    final byte[] getQpdUInt() {
        return this.readBytesNoCnt(4);
    }

    final byte[] getQpdLong() {
        return this.readBytesNoCnt(8);
    }

    final byte[] getQpdULong() {
        return this.readBytesNoCnt(8);
    }

    final byte[] getQpdFloat() {
        return this.readBytesNoCnt(4);
    }

    final byte[] getQpdDouble() {
        return this.readBytesNoCnt(8);
    }

    final byte[] getIpv4() {
        return this.getBytesValue(5);
    }

    final byte[] getIpv6() {
        return this.getBytesValue(17);
    }

    final long readSLong() {
        long val = 0L;
        for (int i = 7; i >= 0; --i) {
            if (i > 0) {
                long tmp = MachByteFunc.uLong(this.value[this.curPos++]) << i * 8;
                val += tmp;
                continue;
            }
            val += MachByteFunc.uLong(this.value[this.curPos++]);
        }
        return val;
    }

    final int readByte() {
        return this.value[this.curPos++];
    }

    final int readUShortNoCnt() {
        int val = 0;
        for (int i = 1; i >= 0; --i) {
            if (i > 0) {
                int tmp = MachByteFunc.uInt(this.value[this.curPos++]) << i * 8;
                val += tmp;
                continue;
            }
            val += MachByteFunc.uInt(this.value[this.curPos++]);
        }
        return val;
    }

    final long readUIntNoCnt() {
        long val = 0L;
        for (int i = 3; i >= 0; --i) {
            if (i > 0) {
                long tmp = MachByteFunc.uLong(this.value[this.curPos++]) << i * 8;
                val += tmp;
                continue;
            }
            val += MachByteFunc.uLong(this.value[this.curPos++]);
        }
        return val;
    }

    final void dump() {
        System.out.println("value.length = " + this.value.length);
        for (int i = 0; i < this.value.length; ++i) {
            System.out.println("value[ " + i + "] = " + this.value[i]);
        }
    }
}

