/*
 * Decompiled with CFR 0.152.
 */
package com.machbase.jdbc;

import com.machbase.jdbc.MachConnection;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import javax.sql.ConnectionEvent;
import javax.sql.ConnectionEventListener;
import javax.sql.PooledConnection;
import javax.sql.StatementEventListener;

public class MachPooledConnection
implements PooledConnection {
    protected MachConnection conn = null;
    private ArrayList listeners;

    protected MachPooledConnection() {
        this.initConnection();
    }

    public MachPooledConnection(MachConnection con) throws SQLException {
        this.initConnection();
        this.conn = con;
        this.conn.setPooledConnection(this);
    }

    private void initConnection() {
        this.conn = null;
        this.listeners = new ArrayList();
    }

    @Override
    public synchronized Connection getConnection() throws SQLException {
        if (this.conn == null) {
            this.fireConnectionEvent(false, new SQLException());
            return null;
        }
        return this.conn;
    }

    @Override
    public synchronized void close() throws SQLException {
        this.conn.setPooledConnection(null);
        this.conn.close();
        this.conn = null;
        this.listeners.clear();
    }

    public synchronized void fireConnectionEvent(boolean closed, SQLException sqlException) {
        if (this.listeners.size() > 0) {
            ConnectionEvent connectionEvent = new ConnectionEvent(this, sqlException);
            for (ConnectionEventListener listener : this.listeners) {
                if (closed) {
                    listener.connectionClosed(connectionEvent);
                    continue;
                }
                try {
                    if (this.conn != null && !this.conn.isClosed()) continue;
                    listener.connectionErrorOccurred(connectionEvent);
                }
                catch (SQLException sQLException) {}
            }
        }
    }

    @Override
    public synchronized void addConnectionEventListener(ConnectionEventListener listener) {
        this.listeners = (ArrayList)this.listeners.clone();
        this.listeners.add(listener);
    }

    @Override
    public synchronized void removeConnectionEventListener(ConnectionEventListener listener) {
        this.listeners = (ArrayList)this.listeners.clone();
        this.listeners.remove(listener);
    }

    @Override
    public void addStatementEventListener(StatementEventListener listener) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void removeStatementEventListener(StatementEventListener listener) {
        throw new UnsupportedOperationException();
    }
}

